/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.dependencies.renderers;

import com.intellij.cdi.dependencies.edges.CdiEdge;
import com.intellij.cdi.dependencies.nodes.CdiNode;
import com.intellij.diagram.DiagramColors;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.builder.renderer.GradientFilledPanel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CdiNodeRenderer
extends AbstractColoredNodeCellRenderer {
    GraphBuilder<CdiNode<?>, CdiEdge<?>> myBuilder;

    public CdiNodeRenderer(@NotNull GraphBuilder<CdiNode<?>, CdiEdge<?>> builder, ModificationTracker modificationTracker) {
        if (builder == null) {
            CdiNodeRenderer.$$$reportNull$$$0(0);
        }
        super(modificationTracker);
        this.myBuilder = builder;
    }

    public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
        Node node = realizer.getNode();
        CdiNode beansNode = (CdiNode)this.myBuilder.getNodeObject(node);
        if (beansNode != null) {
            Object element = beansNode.getIdentifyingElement();
            if (!element.isValid()) {
                return;
            }
            JLabel nameLabel = new JLabel(this.getNodeTitle(beansNode), beansNode.getIcon(), 0);
            nameLabel.setFont(nameLabel.getFont().deriveFont(1));
            nameLabel.setBorder(JBUI.Borders.empty((int)3));
            nameLabel.setHorizontalAlignment(2);
            GradientFilledPanel namePanel = new GradientFilledPanel(DiagramColors.NODE_HEADER.getDefaultColor());
            namePanel.setLayout((LayoutManager)new BorderLayout());
            namePanel.add((Component)nameLabel, (Object)"Center");
            namePanel.setBorder(BorderFactory.createLineBorder((Color)JBColor.WHITE, 1));
            nameLabel.setForeground(JBColor.foreground());
            wrapper.add((Component)namePanel, "North");
            CellRendererPanel propertiesPanel = new CellRendererPanel();
            propertiesPanel.setLayout((LayoutManager)new GridBagLayout());
            propertiesPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
            propertiesPanel.setForcedBackground(DiagramColors.NODE_BACKGROUND.getDefaultColor());
            wrapper.add((Component)propertiesPanel, "Center");
        }
    }

    @NlsSafe
    protected String getNodeTitle(CdiNode<?> pointer) {
        return this.myBuilder.getNodeName(pointer);
    }

    protected int getSelectionBorderWidth() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/cdi/dependencies/renderers/CdiNodeRenderer", "<init>"));
    }
}

