/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.starter;

import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterProjectDownloader;
import com.intellij.micronaut.starter.MicronautOptions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;

public class MicronautProjectDownloader
extends WebStarterProjectDownloader<MicronautOptions> {
    protected MicronautProjectDownloader(WebStarterModuleBuilder<MicronautOptions> builder) {
        super(builder);
    }

    protected Url buildUrl() {
        MicronautOptions options = (MicronautOptions)this.myBuilder.getOptions();
        return this.composeUrl(options, "create");
    }

    public Url previewUrl() {
        MicronautOptions options = (MicronautOptions)this.myBuilder.getOptions();
        return this.composeUrl(options, "preview");
    }

    @NotNull
    private Url composeUrl(MicronautOptions options, String endpoint) {
        String serviceUrl = StringUtil.trimTrailing((String)this.myBuilder.getServiceUrl(), (char)'/');
        String packageAndName = options.group + "." + options.artifact;
        Url url = Urls.newFromEncoded((String)(serviceUrl + "/" + endpoint + "/" + MicronautProjectDownloader.getParameter(options.appTypeModel) + "/" + packageAndName));
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("build", MicronautProjectDownloader.getParameter(options.buildToolModel));
        parameters.put("test", MicronautProjectDownloader.getParameter(options.testFrameworkModel));
        parameters.put("lang", MicronautProjectDownloader.getParameter(options.languageModel));
        parameters.put("javaVersion", MicronautProjectDownloader.getParameter(options.javaVersionModel));
        url = url.addParameters(parameters);
        if (!options.selectedFeaturesIds.isEmpty()) {
            String features = StringUtil.join(options.selectedFeaturesIds, (String)",");
            url = url.addParameters(Collections.singletonMap("features", features));
        }
        Url url2 = url;
        if (url2 == null) {
            MicronautProjectDownloader.$$$reportNull$$$0(0);
        }
        return url2;
    }

    protected void unzip(File tempZipFile, File contentEntryDir) throws IOException {
        ZipUtil.extract((File)tempZipFile, (File)contentEntryDir, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/micronaut/starter/MicronautProjectDownloader", "composeUrl"));
    }
}

