/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.starter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoader;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoaderIteration;
import com.intellij.micronaut.starter.MicronautOptions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class MicronautOptionsLoader
extends WebStarterOptionsLoader<MicronautOptions> {
    protected MicronautOptions createEmptyOptionsContainer() {
        return new MicronautOptions();
    }

    @NotNull
    protected WebStarterOptionsLoaderIteration<MicronautOptions> getFirstIteration() {
        return new WebStarterOptionsLoaderIteration<MicronautOptions>(){

            protected RequestBuilder getPreparedRequestBuilder(String serviceUrl) {
                return HttpRequests.request((String)(serviceUrl + "/application-types"));
            }

            public void parseJsonResponse(JsonElement jsonRootElement, @NotNull MicronautOptions options) {
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                MicronautOptionsLoader.parseAppTypes(options, jsonRootElement);
            }

            public void addMoreIterationsToQueue(MicronautOptions options, Consumer<WebStarterOptionsLoaderIteration<MicronautOptions>> addIterationToProcess) {
                for (WebStarterOptions.Option appType : options.appTypeModel.getItems()) {
                    addIterationToProcess.accept(new MicronautAppTypeFeaturesLoaderIteration(appType.id));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/micronaut/starter/MicronautOptionsLoader$1", "parseJsonResponse"));
            }
        };
    }

    protected void doAfterAllIterations(MicronautOptions options) {
        for (List<WebStarterOptions.MultiSelectGroup> groups : options.appTypeId2SupportedFeatures.values()) {
            groups.sort(new MyGroupSortComparator());
        }
    }

    private static void parseAppTypes(@NotNull MicronautOptions options, JsonElement jsonRootElement) {
        if (options == null) {
            MicronautOptionsLoader.$$$reportNull$$$0(0);
        }
        JsonArray appTypeJsonElements = jsonRootElement.getAsJsonObject().get("types").getAsJsonArray();
        for (JsonElement appTypeJsonElement : appTypeJsonElements) {
            JsonObject appTypeJsonObject = appTypeJsonElement.getAsJsonObject();
            String id = appTypeJsonObject.get("name").getAsString();
            @NlsSafe String name = StringsKt.removePrefix((String)appTypeJsonObject.get("title").getAsString(), (CharSequence)"Micronaut ");
            @NlsSafe String description = appTypeJsonObject.get("description").getAsString();
            options.appTypeModel.add((Object)new WebStarterOptions.Option(id, name, description));
        }
        MicronautOptions.setFirstItemSelected(options.appTypeModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/micronaut/starter/MicronautOptionsLoader", "parseAppTypes"));
    }

    private static class MyGroupSortComparator
    implements Comparator<WebStarterOptions.MultiSelectGroup> {
        private final List<String> priorGroups = Arrays.asList("Server", "Client", "Database", "Validation", "Logging", "Security", "Management", "Messaging", "Reactive", "View Rendering");
        private final Map<String, Integer> someGroups2prior = new HashMap<String, Integer>();

        private MyGroupSortComparator() {
            int prior = this.priorGroups.size();
            for (String group : this.priorGroups) {
                this.someGroups2prior.put(group, prior);
                --prior;
            }
        }

        @Override
        public int compare(WebStarterOptions.MultiSelectGroup o1, WebStarterOptions.MultiSelectGroup o2) {
            int prior1 = this.someGroups2prior.getOrDefault(o1.name, 0);
            int prior2 = this.someGroups2prior.getOrDefault(o2.name, 0);
            return prior2 - prior1;
        }
    }

    private static final class MicronautAppTypeFeaturesLoaderIteration
    extends WebStarterOptionsLoaderIteration<MicronautOptions> {
        public static final Pattern LINK_IN_DESCRIPTION_PATTERN = Pattern.compile(" \\((http[s]?://[^\\s]+)\\)");
        private final String myAppTypeId;

        private MicronautAppTypeFeaturesLoaderIteration(String appTypeId) {
            this.myAppTypeId = appTypeId;
        }

        protected RequestBuilder getPreparedRequestBuilder(String serviceUrl) {
            return HttpRequests.request((String)(serviceUrl + "/application-types/" + this.myAppTypeId + "/features"));
        }

        public void parseJsonResponse(JsonElement jsonRootElement, @NotNull MicronautOptions options) {
            if (options == null) {
                MicronautAppTypeFeaturesLoaderIteration.$$$reportNull$$$0(0);
            }
            ArrayList<WebStarterOptions.MultiSelectGroup> categoriesKeeper = new ArrayList<WebStarterOptions.MultiSelectGroup>();
            HashMap<String, WebStarterOptions.MultiSelectGroup> groupName2group = new HashMap<String, WebStarterOptions.MultiSelectGroup>();
            JsonArray featureJsonElements = jsonRootElement.getAsJsonObject().get("features").getAsJsonArray();
            for (JsonElement featureJsonElement : featureJsonElements) {
                WebStarterOptions.MultiSelectGroup registeredGroup;
                JsonObject appTypeJsonObject = featureJsonElement.getAsJsonObject();
                @NlsSafe String groupName = appTypeJsonObject.get("category").getAsString();
                @NlsSafe String id = appTypeJsonObject.get("name").getAsString();
                @NlsSafe String name = appTypeJsonObject.get("title").getAsString();
                @NlsSafe Object description = appTypeJsonObject.get("description").getAsString();
                String link = null;
                Matcher matcher = LINK_IN_DESCRIPTION_PATTERN.matcher((CharSequence)description);
                if (matcher.find()) {
                    link = matcher.group(1);
                    description = ((String)description).substring(0, matcher.start()) + ((String)description).substring(matcher.end());
                }
                if ((registeredGroup = (WebStarterOptions.MultiSelectGroup)groupName2group.get(groupName)) == null) {
                    registeredGroup = new WebStarterOptions.MultiSelectGroup(groupName, new ArrayList());
                    groupName2group.put(groupName, registeredGroup);
                    categoriesKeeper.add(registeredGroup);
                }
                WebStarterOptions.Option feature = new WebStarterOptions.Option(id, name, "[" + id + "] " + (String)description);
                if (StringUtil.isNotEmpty((String)link)) {
                    feature.putUserData(MicronautOptions.ATTACHED_LINK_KEY, (Object)link);
                }
                registeredGroup.options.add(feature);
            }
            options.appTypeId2SupportedFeatures.put(this.myAppTypeId, categoriesKeeper);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/micronaut/starter/MicronautOptionsLoader$MicronautAppTypeFeaturesLoaderIteration", "parseJsonResponse"));
        }
    }
}

