/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.starter;

import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.dependencies.LinkData;
import com.intellij.openapi.util.Key;
import com.intellij.ui.CollectionComboBoxModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class MicronautOptions
extends WebStarterOptions {
    @NotNull
    public static final Key<String> ATTACHED_LINK_KEY = new Key("com.intellij.micronaut.starter.MicronautOptions.ATTACHED_LINK_KEY");
    String artifact = "demo";
    String group = "com.example";
    final CollectionComboBoxModel<WebStarterOptions.Option> buildToolModel = new CollectionComboBoxModel(Arrays.asList(new WebStarterOptions.Option("MAVEN", "Maven"), new WebStarterOptions.Option("GRADLE", "Gradle"), new WebStarterOptions.Option("GRADLE_KOTLIN", "Gradle Kotlin")));
    final CollectionComboBoxModel<WebStarterOptions.Option> testFrameworkModel = new CollectionComboBoxModel(Arrays.asList(new WebStarterOptions.Option("JUNIT", "JUnit"), new WebStarterOptions.Option("KOTLINTEST", "Kotest"), new WebStarterOptions.Option("SPOCK", "Spock")));
    final CollectionComboBoxModel<WebStarterOptions.Option> languageModel = new CollectionComboBoxModel(Arrays.asList(new WebStarterOptions.Option("JAVA", "Java"), new WebStarterOptions.Option("KOTLIN", "Kotlin"), new WebStarterOptions.Option("GROOVY", "Groovy")));
    final CollectionComboBoxModel<WebStarterOptions.Option> javaVersionModel = new CollectionComboBoxModel(Arrays.asList(new WebStarterOptions.Option("JDK_8", "8"), new WebStarterOptions.Option("JDK_9", "9"), new WebStarterOptions.Option("JDK_10", "10"), new WebStarterOptions.Option("JDK_11", "11"), new WebStarterOptions.Option("JDK_12", "12"), new WebStarterOptions.Option("JDK_13", "13"), new WebStarterOptions.Option("JDK_14", "14"), new WebStarterOptions.Option("JDK_15", "15")));
    private static final String DEFAULT_JDK_ID = "JDK_11";
    final CollectionComboBoxModel<WebStarterOptions.Option> appTypeModel = new CollectionComboBoxModel();
    final Map<String, List<WebStarterOptions.MultiSelectGroup>> appTypeId2SupportedFeatures = new HashMap<String, List<WebStarterOptions.MultiSelectGroup>>();
    final Set<String> selectedFeaturesIds = new HashSet<String>();

    public MicronautOptions() {
        MicronautOptions.setFirstItemSelected(this.buildToolModel);
        MicronautOptions.setFirstItemSelected(this.testFrameworkModel);
        MicronautOptions.setFirstItemSelected(this.languageModel);
        WebStarterOptions.Option defaultJdk = this.javaVersionModel.getItems().stream().filter(jdk -> DEFAULT_JDK_ID.equals(jdk.id)).findFirst().orElseThrow(() -> new IllegalStateException("Java version model does not contain default JDK"));
        this.javaVersionModel.setSelectedItem((Object)defaultJdk);
    }

    static void setFirstItemSelected(CollectionComboBoxModel<WebStarterOptions.Option> model) {
        if (model.getSize() > 0) {
            model.setSelectedItem(model.getElementAt(0));
        }
    }

    public String getArtifact() {
        return this.artifact;
    }

    public List<WebStarterOptions.MultiSelectGroup> getDependenciesCategories() {
        assert (this.appTypeModel.getSelected() != null);
        return this.appTypeId2SupportedFeatures.get(((WebStarterOptions.Option)this.appTypeModel.getSelected()).id);
    }

    public Set<String> getSelectedDependenciesIds() {
        return this.selectedFeaturesIds;
    }

    public List<LinkData> getLinksFor(WebStarterOptions.Option dependency) {
        String attachedLink = (String)dependency.getUserData(ATTACHED_LINK_KEY);
        return attachedLink != null ? Collections.singletonList(new LinkData(attachedLink, LinkData.LinkType.OTHER)) : null;
    }
}

