/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.starter;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.frameworks.starters.FrameworksStartersBundle;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterProjectDownloader;
import com.intellij.frameworks.starters.web.dependencies.WebStarterDependenciesStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.starter.MicronautModuleBuilder;
import com.intellij.micronaut.starter.MicronautProjectDownloader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.HttpUrlConnectionUtil;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MicronautDependenciesStep
extends WebStarterDependenciesStep {
    private final ThreadLocal<Boolean> myValidationContext;

    public MicronautDependenciesStep(WebStarterModuleBuilder<?> builder, @NotNull WizardContext wizardContext) {
        if (wizardContext == null) {
            MicronautDependenciesStep.$$$reportNull$$$0(0);
        }
        super(builder, wizardContext);
        this.myValidationContext = new ThreadLocal();
    }

    public boolean validate() {
        if (this.myValidationContext.get() == Boolean.TRUE) {
            return true;
        }
        if (!this.myPanel.isLoading()) {
            this.myPanel.setLoadingText(MicronautBundle.message("micronaut.starter.message.validating.dependencies", new Object[0]));
            this.myPanel.startLoading();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    ValidationResult result = this.validateOptions();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.myDisposed) {
                            return;
                        }
                        this.handleDependenciesValidation(result);
                    }, ModalityState.stateForComponent((Component)this.myPanel));
                }
                catch (IOException e) {
                    Logger.getInstance(MicronautDependenciesStep.class).info((Throwable)e);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.myDisposed) {
                            return;
                        }
                        this.handleDependenciesValidation(ValidationResult.error(FrameworksStartersBundle.message((String)"error.text.with.error.content", (Object[])new Object[]{e.getMessage()})));
                    }, ModalityState.stateForComponent((Component)this.myPanel));
                }
            });
        }
        return false;
    }

    public ValidationResult validateOptions() throws IOException {
        MicronautProjectDownloader downloader = new MicronautProjectDownloader((MicronautModuleBuilder)this.myBuilder);
        Url url = downloader.previewUrl();
        return (ValidationResult)HttpRequests.request((String)url.toExternalForm()).userAgent(WebStarterProjectDownloader.userAgent()).connectTimeout(10000).throwStatusCodeException(false).isReadResponseOnError(true).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<ValidationResult>(){

            public ValidationResult process(@NotNull HttpRequests.Request request2) throws IOException {
                int statusCode;
                URLConnection connection;
                if (request2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((connection = request2.getConnection()) instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 200) {
                    return ValidationResult.ok();
                }
                int n = statusCode = connection instanceof HttpURLConnection ? ((HttpURLConnection)connection).getResponseCode() : -1;
                if (statusCode == 400) {
                    String error = HttpUrlConnectionUtil.readString((InputStream)((HttpURLConnection)connection).getErrorStream(), (URLConnection)connection);
                    try {
                        JsonReader jsonReader = new JsonReader((Reader)new StringReader(error));
                        jsonReader.setLenient(true);
                        JsonElement jsonRootElement = JsonParser.parseReader((JsonReader)jsonReader);
                        JsonElement message = jsonRootElement.getAsJsonObject().get("message");
                        String errorMessage = message != null ? message.getAsString() : MicronautBundle.message("micronaut.starter.message.validation.error", new Object[0]);
                        return ValidationResult.error(errorMessage);
                    }
                    catch (Throwable e) {
                        throw new IOException("Error parsing JSON response", e);
                    }
                }
                throw new IOException(MicronautBundle.message("micronaut.starter.message.validation.error", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/micronaut/starter/MicronautDependenciesStep$1", "process"));
            }
        });
    }

    public void handleDependenciesValidation(ValidationResult result) {
        this.myPanel.stopLoading();
        if (result.isFailure()) {
            String message = FrameworksStartersBundle.message((String)"error.text.with.error.content", (Object[])new Object[]{result.getMessage()});
            Messages.showErrorDialog((String)message, (String)MicronautBundle.message("micronaut.starter.message.validation.title", new Object[0]));
        } else {
            this.myValidationContext.set(Boolean.TRUE);
            try {
                this.myWizardContext.getWizard().proceedToNextStep();
            }
            finally {
                this.myValidationContext.remove();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/micronaut/starter/MicronautDependenciesStep", "<init>"));
    }

    private static final class ValidationResult {
        @Nullable
        private final String message;

        private ValidationResult(@Nullable String message) {
            this.message = message;
        }

        @Nullable
        private String getMessage() {
            return this.message;
        }

        private boolean isFailure() {
            return this.message != null;
        }

        private static ValidationResult error(String message) {
            return new ValidationResult(message);
        }

        private static ValidationResult ok() {
            return new ValidationResult(null);
        }
    }
}

