/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.starter;

import com.intellij.frameworks.starters.shared.StartersValidationUtils;
import com.intellij.frameworks.starters.web.WebStarterApplicationInfoStep;
import com.intellij.frameworks.starters.web.WebStarterFormBuilder;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.starter.MicronautModuleBuilder;
import com.intellij.micronaut.starter.MicronautOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class MicronautApplicationInfoStep
extends WebStarterApplicationInfoStep<MicronautOptions> {
    private JPanel myBuildToolRadioButtonsPanel;
    private JBTextField myGroupField;
    private JBTextField myArtifactField;

    public MicronautApplicationInfoStep(MicronautModuleBuilder builder, WizardContext context) {
        super((WebStarterModuleBuilder)builder, context);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myArtifactField;
    }

    protected void fillAppSettingsPanel(WebStarterFormBuilder formBuilder, MicronautOptions options) {
        ArrayList<JPanel> radioButtonsPanelsToEqualizeWidth = new ArrayList<JPanel>();
        this.myBuildToolRadioButtonsPanel = formBuilder.addRadioButtonsGroup(MicronautBundle.message("micronaut.starter.label.title.build.tool", new Object[0]), options.buildToolModel);
        this.myGroupField = formBuilder.addTextField(MicronautBundle.message("micronaut.starter.label.title.group", new Object[0]), options.group);
        this.myArtifactField = formBuilder.addTextField(MicronautBundle.message("micronaut.starter.label.title.artifact", new Object[0]), options.artifact);
        formBuilder.addComboBox(MicronautBundle.message("micronaut.starter.label.title.application.type", new Object[0]), options.appTypeModel, true);
        formBuilder.addComboBox(MicronautBundle.message("micronaut.starter.label.title.java.version", new Object[0]), options.javaVersionModel);
        radioButtonsPanelsToEqualizeWidth.add(formBuilder.addRadioButtonsGroup(MicronautBundle.message("micronaut.starter.label.title.language", new Object[0]), options.languageModel));
        radioButtonsPanelsToEqualizeWidth.add(formBuilder.addRadioButtonsGroup(MicronautBundle.message("micronaut.starter.label.title.test.framework", new Object[0]), options.testFrameworkModel));
        MicronautApplicationInfoStep.equalizeAllInnerComponentsWidthByIndex(radioButtonsPanelsToEqualizeWidth);
        this.registerTextComponentValidation((JTextField)this.myGroupField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_NO_WHITESPACES, StartersValidationUtils.CHECK_GROUP_FORMAT, StartersValidationUtils.CHECK_NO_RESERVED_WORDS});
        this.registerTextComponentValidation((JTextField)this.myArtifactField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_NO_WHITESPACES, StartersValidationUtils.CHECK_ARTIFACT_FORMAT_FOR_WEB, StartersValidationUtils.CHECK_NO_RESERVED_WORDS});
    }

    protected void setInitialFocus(JBLoadingPanel settingsPanel) {
        Component radioButtonToFocusOn = null;
        for (Component component : this.myBuildToolRadioButtonsPanel.getComponents()) {
            if (!(component instanceof JRadioButton) || !((JRadioButton)component).isSelected()) continue;
            radioButtonToFocusOn = component;
            break;
        }
        if (radioButtonToFocusOn != null) {
            IdeFocusManager.findInstanceByComponent((Component)this.myBuildToolRadioButtonsPanel).requestFocus(radioButtonToFocusOn, true);
        } else {
            Logger.getInstance(MicronautApplicationInfoStep.class).error("There is no any selected JRadioButton to set focus on");
        }
    }

    public void updateDataModel() {
        super.updateDataModel();
        MicronautOptions options = (MicronautOptions)this.myBuilder.getOptions();
        options.group = this.myGroupField.getText();
        options.artifact = this.myArtifactField.getText();
    }
}

