/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.run.MnRunConfiguration;
import com.intellij.micronaut.run.MnRunConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/micronaut/run/MnRunConfigurationProducer;", "Lcom/intellij/execution/junit/JavaRunConfigurationProducerBase;", "Lcom/intellij/micronaut/run/MnRunConfiguration;", "()V", "findMainClass", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/psi/PsiElement;", "psiElement", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "shouldReplace", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "intellij.micronaut"})
public final class MnRunConfigurationProducer
extends JavaRunConfigurationProducerBase<MnRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return MnRunConfigurationType.Companion.getInstance().getConfigurationFactories()[0];
    }

    protected boolean setupConfigurationFromContext(@NotNull MnRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        Module module2 = module;
        if (!MicronautUtilsKt.hasMicronautLibrary(module2)) {
            return false;
        }
        Pair<PsiClass, PsiElement> pair = this.findMainClass((PsiElement)sourceElement.get());
        if (pair == null) {
            return false;
        }
        Pair<PsiClass, PsiElement> classWithAnchor = pair;
        if (classWithAnchor.second != null) {
            sourceElement.set(classWithAnchor.second);
        }
        configuration.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)classWithAnchor.first)));
        configuration.setGeneratedName();
        this.setupConfigurationModule(context, configuration);
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull MnRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration.getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)javaRunConfigurationModule, (String)"configuration.configurationModule");
        Module configurationModule = javaRunConfigurationModule.getModule();
        if (Intrinsics.areEqual((Object)context.getModule(), (Object)configurationModule) ^ true) {
            return false;
        }
        Pair<PsiClass, PsiElement> pair = this.findMainClass(context.getPsiLocation());
        if (pair == null) {
            return false;
        }
        Pair<PsiClass, PsiElement> contextClassWithAnchor = pair;
        String configFqn = configuration.getRunClass();
        Object object = contextClassWithAnchor.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"contextClassWithAnchor.first");
        return Comparing.strEqual((String)configFqn, (String)((PsiClass)object).getQualifiedName());
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        RunConfigurationModule runConfigurationModule;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        RunConfiguration runConfiguration = other.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"other.configuration");
        RunConfiguration configuration = runConfiguration;
        return configuration instanceof ModuleBasedConfiguration && configuration instanceof CommonJavaRunConfigurationParameters && (runConfigurationModule = ((ModuleBasedConfiguration)configuration).getConfigurationModule()) instanceof JavaRunConfigurationModule;
    }

    private final Pair<PsiClass, PsiElement> findMainClass(PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        UMethod uMethod = (UMethod)UastContextKt.getUastParentOfType$default((PsiElement)psiElement, UMethod.class, (boolean)false, (int)2, null);
        if (uMethod != null) {
            PsiClass psiClass = UastUtils.getMainMethodClass((UMethod)uMethod);
            if (psiClass == null) {
                return null;
            }
            PsiClass mainClass = psiClass;
            return Pair.create((Object)mainClass, null);
        }
        UFile file = (UFile)UastContextKt.toUElement((PsiElement)psiElement, UFile.class);
        if (file != null) {
            for (UClass uClass : file.getClasses()) {
                if (UastUtils.findMainInClass((UClass)uClass) == null) continue;
                return Pair.create((Object)uClass.getJavaPsi(), (Object)UElementKt.getSourcePsiElement((UElement)((UElement)uClass)));
            }
            return null;
        }
        PsiClass psiClass = ApplicationConfigurationType.getMainClass((PsiElement)psiElement);
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"ApplicationConfiguration\u2026siElement) ?: return null");
        PsiClass mainClass = psiClass;
        return Pair.pair((Object)mainClass, (Object)mainClass);
    }
}

