/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.websocket;

import com.intellij.icons.AllIcons;
import com.intellij.micronaut.jam.beans.MnStereotypeElement;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.jam.websocket.MnWebSocket;
import com.intellij.micronaut.provider.websocket.MnWebSocketTargetInfo;
import com.intellij.micronaut.provider.websocket.MnWebSocketUtilsKt;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.presentation.HttpUrlPresentation;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ValueKey;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uast.UastModificationTracker;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\tJ'\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/micronaut/provider/websocket/MnWebSocketFramework;", "T", "Lcom/intellij/micronaut/jam/websocket/MnWebSocket;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "()V", "createEndpointData", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "methodMapping", "(Lcom/intellij/micronaut/jam/websocket/MnWebSocket;)Ljava/lang/Iterable;", "getEndpointData", "", "group", "endpoint", "dataId", "", "(Lcom/intellij/micronaut/jam/websocket/MnWebSocket;Lcom/intellij/micronaut/jam/websocket/MnWebSocket;Ljava/lang/String;)Ljava/lang/Object;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "(Lcom/intellij/micronaut/jam/websocket/MnWebSocket;Lcom/intellij/micronaut/jam/websocket/MnWebSocket;)Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "isValidEndpoint", "", "(Lcom/intellij/micronaut/jam/websocket/MnWebSocket;Lcom/intellij/micronaut/jam/websocket/MnWebSocket;)Z", "intellij.micronaut"})
public abstract class MnWebSocketFramework<T extends MnWebSocket>
implements EndpointsProvider<T, T> {
    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MnWebSocketUtilsKt.hasWebSocketLibrary(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull T group, @NotNull T endpoint) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        String string = ((MnWebSocket)endpoint).getResourceValue();
        PsiClass psiClass = ((MnStereotypeElement)endpoint).getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"endpoint.psiElement");
        return (ItemPresentation)new HttpUrlPresentation(string, psiClass.getName(), AllIcons.Webreferences.WebSocket);
    }

    @Nullable
    public Object getEndpointData(@NotNull T group, @NotNull T endpoint, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        ValueKey.BeforeIf beforeIf = ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.URL_TARGET_INFO).thenGet((Supplier)new Supplier<Iterable<? extends UrlTargetInfo>>(this, (MnWebSocket)endpoint){
            final /* synthetic */ MnWebSocketFramework this$0;
            final /* synthetic */ MnWebSocket $endpoint;

            public final Iterable<UrlTargetInfo> get() {
                return MnWebSocketFramework.access$createEndpointData(this.this$0, this.$endpoint);
            }
            {
                this.this$0 = mnWebSocketFramework;
                this.$endpoint = mnWebSocket;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)beforeIf, (String)"ValueKey.match(dataId)\n \u2026eEndpointData(endpoint) }");
        return EndpointsViewUtils.orCheckCommonEndpointKeys((ValueKey.BeforeIf)beforeIf, (PsiElement)((PsiElement)((MnStereotypeElement)endpoint).getPsiElement()));
    }

    private final Iterable<UrlTargetInfo> createEndpointData(T methodMapping) {
        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(((MnWebSocket)methodMapping).getResourceValue());
        return CollectionsKt.listOf(new MnWebSocketTargetInfo<T>(UrlConstants.HTTP_SCHEMES, urlPath, methodMapping));
    }

    public boolean isValidEndpoint(@NotNull T group, @NotNull T endpoint) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        return ((MnStereotypeElement)endpoint).isValid();
    }

    @NotNull
    public Iterable<T> getEndpoints(@NotNull T group) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        return CollectionsKt.listOf(group);
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }

    public static final /* synthetic */ Iterable access$createEndpointData(MnWebSocketFramework $this, MnWebSocket methodMapping) {
        return $this.createEndpointData(methodMapping);
    }
}

