/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.mq;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.micronaut.jam.mq.kafka.MnKafkaListener;
import com.intellij.micronaut.jam.mq.rabbitmq.MnRabbitListener;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a-\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u00012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"getMqPropertyPatterns", "", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UElement;", "injection", "Lcom/intellij/patterns/uast/UExpressionPattern;", "Lorg/jetbrains/uast/UExpression;", "(Lcom/intellij/patterns/uast/UExpressionPattern;)[Lcom/intellij/patterns/ElementPattern;", "hasMicronautMessagingInProject", "", "project", "Lcom/intellij/openapi/project/Project;", "hasMnKafkaInProject", "hasMnRabbitInProject", "hasMqImplicitUsage", "element", "Lcom/intellij/psi/PsiElement;", "isKafkaTopicListener", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "psiClass", "Lcom/intellij/psi/PsiClass;", "isRabbitQueueListener", "intellij.micronaut"})
public final class MnMqUtilsKt {
    public static final boolean hasMqImplicitUsage(@NotNull PsiElement element) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!(element instanceof PsiMethod)) break block5;
                PsiAnnotation[] psiAnnotationArray = ((PsiMethod)element).getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"element.annotations");
                PsiAnnotation[] psiAnnotationArray2 = psiAnnotationArray;
                boolean bl = false;
                if (!(psiAnnotationArray2.length == 0)) break block6;
            }
            return false;
        }
        PsiClass psiClass = ((PsiMethod)element).getContainingClass();
        if (psiClass == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"element.containingClass ?: return false");
        PsiClass psiClass2 = psiClass;
        if (!MicronautBeanUtilsKt.isBeanCandidateClass(psiClass2)) {
            return false;
        }
        return MnMqUtilsKt.isKafkaTopicListener((PsiMethod)element, psiClass2) || MnMqUtilsKt.isRabbitQueueListener((PsiMethod)element, psiClass2);
    }

    private static final boolean isKafkaTopicListener(PsiMethod psiMethod, PsiClass psiClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (String)"io.micronaut.configuration.kafka.annotation.Topic", (int)0) && MnKafkaListener.META.getJamElement((PsiModifierListOwner)psiClass) != null;
    }

    private static final boolean isRabbitQueueListener(PsiMethod psiMethod, PsiClass psiClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)CollectionsKt.listOf((Object[])new String[]{"io.micronaut.configuration.rabbitmq.annotation.Queue", "io.micronaut.rabbitmq.annotation.Queue"}), (int)0) && MnRabbitListener.META.getJamElement((PsiModifierListOwner)psiClass) != null;
    }

    @NotNull
    public static final ElementPattern<? extends UElement>[] getMqPropertyPatterns(@NotNull UExpressionPattern<UExpression, ?> injection) {
        Intrinsics.checkNotNullParameter(injection, (String)"injection");
        ElementPattern[] elementPatternArray = new ElementPattern[7];
        elementPatternArray[0] = (ElementPattern)injection.annotationParam("io.micronaut.configuration.kafka.annotation.Topic", "value");
        StringPattern stringPattern = StandardPatterns.string().oneOf(new String[]{"value", "name"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"string().oneOf(\"value\", \"name\")");
        elementPatternArray[1] = (ElementPattern)injection.annotationParams("io.micronaut.http.annotation.Header", (ElementPattern)stringPattern);
        List list = CollectionsKt.listOf((Object[])new String[]{"io.micronaut.configuration.rabbitmq.annotation.RabbitClient", "io.micronaut.rabbitmq.annotation.RabbitClient"});
        StringPattern stringPattern2 = StandardPatterns.string().oneOf(new String[]{"value", "connection"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern2, (String)"string().oneOf(\"value\", \"connection\")");
        elementPatternArray[2] = (ElementPattern)injection.annotationParams(list, (ElementPattern)stringPattern2);
        List list2 = CollectionsKt.listOf((Object[])new String[]{"io.micronaut.configuration.rabbitmq.annotation.Queue", "io.micronaut.rabbitmq.annotation.Queue"});
        StringPattern stringPattern3 = StandardPatterns.string().oneOf(new String[]{"connection", "executor", "value"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern3, (String)"string().oneOf(\"connection\", \"executor\", \"value\")");
        elementPatternArray[3] = (ElementPattern)injection.annotationParams(list2, (ElementPattern)stringPattern3);
        List list3 = CollectionsKt.listOf((Object[])new String[]{"io.micronaut.configuration.rabbitmq.annotation.RabbitListener", "io.micronaut.rabbitmq.annotation.RabbitListener"});
        StringPattern stringPattern4 = StandardPatterns.string().oneOf(new String[]{"connection", "executor"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern4, (String)"string().oneOf(\"connection\", \"executor\")");
        elementPatternArray[4] = (ElementPattern)injection.annotationParams(list3, (ElementPattern)stringPattern4);
        List list4 = CollectionsKt.listOf((Object[])new String[]{"io.micronaut.configuration.rabbitmq.annotation.Binding", "io.micronaut.rabbitmq.annotation.Binding"});
        StringPattern stringPattern5 = StandardPatterns.string().oneOf(new String[]{"value", "connection"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern5, (String)"string().oneOf(\"value\", \"connection\")");
        elementPatternArray[5] = (ElementPattern)injection.annotationParams(list4, (ElementPattern)stringPattern5);
        elementPatternArray[6] = (ElementPattern)injection.annotationParam("io.micronaut.messaging.annotation.SendTo", "value");
        return elementPatternArray;
    }

    public static final boolean hasMicronautMessagingInProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"io.micronaut.messaging.annotation.SendTo");
    }

    public static final boolean hasMnRabbitInProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"io.micronaut.configuration.rabbitmq.annotation.RabbitListener") || JavaLibraryUtils.hasLibraryClass((Project)project, (String)"io.micronaut.rabbitmq.annotation.RabbitListener");
    }

    public static final boolean hasMnKafkaInProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"io.micronaut.configuration.kafka.annotation.KafkaClient");
    }
}

