/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.mq;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.micronaut.provider.mq.MnMqPsiReferenceContributor;
import com.intellij.microservices.uast.mq.MQReferenceRegistrarKt;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastReferenceByUsageAdapterKt;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/micronaut/provider/mq/MnMqPsiReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "()V", "clientMethodCall", "Lcom/intellij/patterns/uast/UCallExpressionPattern;", "isTopic", "", "expression", "Lorg/jetbrains/uast/UExpression;", "context", "Lcom/intellij/util/ProcessingContext;", "isTopicParameter", "param", "Lcom/intellij/psi/PsiParameter;", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "Companion", "intellij.micronaut"})
public final class MnMqPsiReferenceContributor
extends PsiReferenceContributor {
    private static final Key<Integer> TOPIC_PARAMETER_KEY;
    public static final Companion Companion;

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        UExpressionPattern singleInjectionHostVariable2 = (UExpressionPattern)UastReferenceByUsageAdapterKt.uInjectionHostInVariable().sourcePsiFilter((Function1)registerReferenceProviders.singleInjectionHostVariable.1.INSTANCE);
        UExpressionPattern.Capture injectionHostOrReferenceExpression2 = (UExpressionPattern.Capture)UastPatterns.injectionHostOrReferenceExpression().sourcePsiFilter((Function1)registerReferenceProviders.injectionHostOrReferenceExpression.1.INSTANCE);
        UastReferenceRegistrar.registerReferenceProviderByUsage$default((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)singleInjectionHostVariable2), (ElementPattern)((ElementPattern)((UExpressionPattern.Capture)injectionHostOrReferenceExpression2.inCall((ElementPattern)this.clientMethodCall())).filterWithContext((Function2)new Function2<UExpression, ProcessingContext, Boolean>(this){

            public final boolean invoke(@NotNull UExpression p1, @NotNull ProcessingContext p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return MnMqPsiReferenceContributor.access$isTopic((MnMqPsiReferenceContributor)((Object)this.receiver), p1, p2);
            }
        })), (UastReferenceProvider)((UastReferenceProvider)MQReferenceRegistrarKt.uastMqReferenceProvider((Function2)registerReferenceProviders.2.INSTANCE)), (double)0.0, (int)8, null);
    }

    private final boolean isTopic(UExpression expression, ProcessingContext context) {
        UCallExpression uCallExpression = UastUtils.getUCallExpression$default((UElement)((UElement)expression), (int)0, (int)1, null);
        if (uCallExpression == null) {
            return false;
        }
        UCallExpression call = uCallExpression;
        Integer n = (Integer)context.get(TOPIC_PARAMETER_KEY);
        if (n == null) {
            return false;
        }
        int index = n;
        UExpression uExpression = call.getArgumentForParameter(index);
        if (uExpression == null) {
            return false;
        }
        UExpression argumentForParameter = uExpression;
        return Intrinsics.areEqual((Object)UastUtils.skipParenthesizedExprDown((UExpression)argumentForParameter), (Object)expression);
    }

    private final UCallExpressionPattern clientMethodCall() {
        return (UCallExpressionPattern)UastPatterns.callExpression().filterWithContext((Function2)new Function2<UCallExpression, ProcessingContext, Boolean>(this){
            final /* synthetic */ MnMqPsiReferenceContributor this$0;

            public final boolean invoke(@NotNull UCallExpression call, @NotNull ProcessingContext context) {
                Object v5;
                block8: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    PsiMethod psiMethod = call.resolve();
                    if (psiMethod == null) {
                        return false;
                    }
                    PsiMethod resolvedMethod = psiMethod;
                    if (resolvedMethod.hasModifier(JvmModifier.STATIC) || resolvedMethod.hasModifier(JvmModifier.PRIVATE)) {
                        return false;
                    }
                    PsiClass psiClass = resolvedMethod.getContainingClass();
                    if (psiClass == null) {
                        return false;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"resolvedMethod.containin\u2026n@filterWithContext false");
                    PsiClass clientClass = psiClass;
                    String string = clientClass.getQualifiedName();
                    if (string != null) {
                        if (StringsKt.startsWith$default((String)string, (String)"java.lang", (boolean)false, (int)2, null)) {
                            return false;
                        }
                    }
                    if (!clientClass.isInterface()) {
                        return false;
                    }
                    PsiParameterList psiParameterList = resolvedMethod.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"resolvedMethod.parameterList");
                    Object[] objectArray = psiParameterList.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"resolvedMethod.parameterList.parameters");
                    Iterable iterable = ArraysKt.withIndex((Object[])objectArray);
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (T t : iterable2) {
                        IndexedValue $dstr$_u24__u24$param = (IndexedValue)t;
                        boolean bl3 = false;
                        PsiParameter param = (PsiParameter)$dstr$_u24__u24$param.component2();
                        if (!MnMqPsiReferenceContributor.access$isTopicParameter(this.this$0, param)) continue;
                        v5 = t;
                        break block8;
                    }
                    v5 = null;
                }
                IndexedValue indexedValue = v5;
                if (indexedValue == null) {
                    return false;
                }
                int index = indexedValue.getIndex();
                context.put(MnMqPsiReferenceContributor.access$getTOPIC_PARAMETER_KEY$cp(), (Object)index);
                return true;
            }
            {
                this.this$0 = mnMqPsiReferenceContributor;
                super(2);
            }
        });
    }

    private final boolean isTopicParameter(PsiParameter param) {
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)param), (String[])new String[]{"io.micronaut.configuration.kafka.annotation.Topic"}) != null;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"kafka.topic.parameter.key");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<Int>(\"kafka.topic.parameter.key\")");
        TOPIC_PARAMETER_KEY = key;
    }

    public static final /* synthetic */ boolean access$isTopic(MnMqPsiReferenceContributor $this, UExpression expression, ProcessingContext context) {
        return $this.isTopic(expression, context);
    }

    public static final /* synthetic */ boolean access$isTopicParameter(MnMqPsiReferenceContributor $this, PsiParameter param) {
        return $this.isTopicParameter(param);
    }

    public static final /* synthetic */ Key access$getTOPIC_PARAMETER_KEY$cp() {
        return TOPIC_PARAMETER_KEY;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/micronaut/provider/mq/MnMqPsiReferenceContributor$Companion;", "", "()V", "TOPIC_PARAMETER_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.micronaut"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

