/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.management;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.micronaut.jam.management.MnManagementConstants;
import com.intellij.micronaut.jam.management.MnManagementEndpoint;
import com.intellij.micronaut.jam.management.MnManagementMethod;
import com.intellij.micronaut.jam.management.MnManagementRead;
import com.intellij.micronaut.jam.management.MnManagementSelector;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a-\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00020\u00012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a8\u0006\u001c"}, d2={"getManagementPropertyPatterns", "", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UElement;", "injection", "Lcom/intellij/patterns/uast/UExpressionPattern;", "Lorg/jetbrains/uast/UExpression;", "(Lcom/intellij/patterns/uast/UExpressionPattern;)[Lcom/intellij/patterns/ElementPattern;", "getManagementResourcePath", "", "endpoint", "Lcom/intellij/micronaut/jam/management/MnManagementEndpoint;", "method", "Lcom/intellij/micronaut/jam/management/MnManagementMethod;", "getParentResourcePath", "hasManagementImplicitRead", "", "element", "Lcom/intellij/psi/PsiElement;", "hasManagementImplicitUsage", "hasManagementLibrary", "project", "Lcom/intellij/openapi/project/Project;", "isManagementAnnotatedMethod", "isMappedManagementMethod", "Lcom/intellij/psi/PsiMethod;", "containingClass", "Lcom/intellij/psi/PsiClass;", "intellij.micronaut"})
@JvmName(name="MnManagementUtils")
public final class MnManagementUtils {
    public static final boolean hasManagementLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"io.micronaut.management.endpoint.annotation.Endpoint");
    }

    public static final boolean isMappedManagementMethod(@NotNull PsiMethod element, @NotNull PsiClass containingClass) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        return !element.isConstructor() && !element.hasModifierProperty("abstract") && !element.hasModifierProperty("static") && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)MnManagementConstants.getMN_MANAGEMENT_METHODS(), (int)0) && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (String)"io.micronaut.management.endpoint.annotation.Endpoint", (int)0);
    }

    @Nullable
    public static final String getManagementResourcePath(@NotNull MnManagementMethod method) {
        PsiParameter firstParam;
        MnManagementRead selector;
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        UrlMappingBuilder builder = new UrlMappingBuilder();
        builder.appendSegment(MnManagementUtils.getParentResourcePath(method));
        PsiMethod psiMethod = method.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"method.psiElement");
        PsiParameterList psiParameterList = psiMethod.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.psiElement.parameterList");
        PsiParameterList parameterList = psiParameterList;
        if (parameterList.getParametersCount() > 0 && (selector = (MnManagementRead)MnManagementSelector.META.getJamElement((PsiModifierListOwner)(firstParam = parameterList.getParameters()[0]))) != null) {
            String firstParamName;
            PsiParameter psiParameter = firstParam;
            String string = firstParamName = psiParameter != null ? psiParameter.getName() : null;
            if (firstParamName != null) {
                builder.appendSegment("/{" + firstParamName + '}');
            }
        }
        return builder.buildOrNull();
    }

    @Nullable
    public static final String getManagementResourcePath(@NotNull MnManagementEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String path = endpoint.getResourceValue();
        if (path != null && !StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            path = '/' + path;
        }
        return path;
    }

    private static final String getParentResourcePath(MnManagementMethod method) {
        PsiMethod psiMethod = method.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"method.psiElement");
        PsiMethod psiMethod2 = psiMethod;
        PsiClass psiClass = psiMethod2.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiMethod.containingClass ?: return null");
        PsiClass containingClass = psiClass;
        MnManagementEndpoint mnManagementEndpoint = (MnManagementEndpoint)MnManagementEndpoint.META.getJamElement((PsiModifierListOwner)containingClass);
        if (mnManagementEndpoint == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)mnManagementEndpoint, (String)"MnManagementEndpoint.MET\u2026ningClass) ?: return null");
        MnManagementEndpoint endpoint = mnManagementEndpoint;
        return MnManagementUtils.getManagementResourcePath(endpoint);
    }

    public static final boolean hasManagementImplicitRead(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return MnManagementUtils.isManagementAnnotatedMethod(element);
    }

    public static final boolean hasManagementImplicitUsage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return MnManagementUtils.isManagementAnnotatedMethod(element);
    }

    private static final boolean isManagementAnnotatedMethod(PsiElement element) {
        block7: {
            block6: {
                if (!(element instanceof PsiMethod)) break block6;
                PsiModifierList psiModifierList = ((PsiMethod)element).getModifierList();
                Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"element.modifierList");
                PsiAnnotation[] psiAnnotationArray = psiModifierList.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"element.modifierList.annotations");
                PsiAnnotation[] psiAnnotationArray2 = psiAnnotationArray;
                boolean bl = false;
                if (!(psiAnnotationArray2.length == 0)) break block7;
            }
            return false;
        }
        PsiClass psiClass = ((PsiMethod)element).getContainingClass();
        if (psiClass == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"element.containingClass ?: return false");
        PsiClass psiClass2 = psiClass;
        if (!MicronautBeanUtilsKt.isBeanCandidateClass(psiClass2)) {
            return false;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)MnManagementConstants.getMN_MANAGEMENT_METHODS(), (int)0)) {
            return false;
        }
        return MnManagementEndpoint.META.getJamElement((PsiModifierListOwner)psiClass2) != null;
    }

    @NotNull
    public static final ElementPattern<? extends UElement>[] getManagementPropertyPatterns(@NotNull UExpressionPattern<UExpression, ?> injection) {
        Intrinsics.checkNotNullParameter(injection, (String)"injection");
        return new ElementPattern[]{(ElementPattern)injection.annotationParam("io.micronaut.management.endpoint.annotation.Endpoint", "prefix")};
    }
}

