/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.jam.JamService;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.jam.model.util.JamCommonUtilKt;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.micronaut.jam.beans.MnStereotypeElement;
import com.intellij.micronaut.jam.http.MnClient;
import com.intellij.micronaut.jam.http.MnController;
import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.jam.http.mapping.MnClassUriMapping;
import com.intellij.micronaut.jam.http.mapping.MnHttpMethodMapping;
import com.intellij.micronaut.jam.http.mapping.MnMethodUriMapping;
import com.intellij.microservices.utils.UrlMappingBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0000\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0002\u001a-\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00130\u00122\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u0017\u0012\u0002\b\u00030\u0016H\u0000\u00a2\u0006\u0002\u0010\u0018\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u001a\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0000\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0000\u001a\u0010\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0000\u001a\u0010\u0010&\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0000\u001a\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000bH\u0002\u001a\u0010\u0010)\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000bH\u0000\u001a\u0010\u0010*\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000bH\u0002\u00a8\u0006+"}, d2={"getClassUriMapping", "", "jamService", "Lcom/intellij/jam/JamService;", "psiClass", "Lcom/intellij/psi/PsiClass;", "getClientResourcePath", "getControllerResourcePath", "getHttpMapping", "Lcom/intellij/micronaut/jam/http/mapping/MnHttpMethodMapping;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "getHttpMappingsHolder", "Lcom/intellij/micronaut/jam/beans/MnStereotypeElement;", "getHttpParentResourcePath", "httpMethod", "holder", "getHttpPropertyPatterns", "", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UElement;", "injection", "Lcom/intellij/patterns/uast/UExpressionPattern;", "Lorg/jetbrains/uast/UExpression;", "(Lcom/intellij/patterns/uast/UExpressionPattern;)[Lcom/intellij/patterns/ElementPattern;", "getHttpResourcePath", "client", "Lcom/intellij/micronaut/jam/http/MnClient;", "controller", "Lcom/intellij/micronaut/jam/http/MnController;", "info", "Lcom/intellij/micronaut/jam/http/MnHttpMappingInfo;", "hasHttpClientLibrary", "", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "hasHttpServerLibrary", "hasRequestMappingJam", "method", "isHttpRequestHandler", "isRequestHandlerCandidate", "intellij.micronaut"})
@JvmName(name="MnHttpUtils")
public final class MnHttpUtils {
    public static final boolean hasHttpServerLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"io.micronaut.http.annotation.Controller");
    }

    public static final boolean hasHttpServerLibrary(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"io.micronaut.http.annotation.Controller");
    }

    public static final boolean hasHttpClientLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"io.micronaut.http.client.annotation.Client");
    }

    public static final boolean hasHttpClientLibrary(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)"io.micronaut.http.client.annotation.Client");
    }

    public static final boolean isHttpRequestHandler(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return MnHttpUtils.isRequestHandlerCandidate(method) && MnHttpUtils.hasRequestMappingJam(method);
    }

    @Nullable
    public static final MnStereotypeElement getHttpMappingsHolder(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        MnController mnController = (MnController)MnController.META.getJamElement((PsiModifierListOwner)psiClass);
        return mnController != null ? (MnStereotypeElement)mnController : (MnStereotypeElement)MnClient.META.getJamElement((PsiModifierListOwner)psiClass);
    }

    @Nullable
    public static final MnHttpMethodMapping getHttpMapping(@NotNull PsiMethod psiMethod) {
        JamService jamService;
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        if (psiMethod.hasModifierProperty("private")) {
            return null;
        }
        JamService jamService2 = jamService = JamService.getJamService((Project)psiMethod.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)jamService2, (String)"jamService");
        SemKey<MnHttpMethodMapping> semKey = MnHttpMethodMapping.HTTP_METHOD_JAM_KEY;
        Intrinsics.checkNotNullExpressionValue(semKey, (String)"MnHttpMethodMapping.HTTP_METHOD_JAM_KEY");
        return (MnHttpMethodMapping)JamCommonUtilKt.getJamElementForMethodOrSupers((JamService)jamService2, semKey, (PsiMethod)psiMethod);
    }

    private static final boolean isRequestHandlerCandidate(PsiMethod method) {
        return (method.hasModifierProperty("public") || method.hasModifierProperty("protected")) && !method.hasModifierProperty("static") && !method.isConstructor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasRequestMappingJam(PsiMethod method) {
        JamService jamService = JamService.getJamService((Project)method.getProject());
        if (jamService.getJamElement(MnHttpMethodMapping.HTTP_METHOD_JAM_KEY, (PsiElement)method) != null) return true;
        if (MnMethodUriMapping.META.getJamElement((PsiModifierListOwner)method) != null) return true;
        PsiMethod[] psiMethodArray = method.findSuperMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"method.findSuperMethods()");
        PsiMethod[] $this$any$iv = psiMethodArray;
        boolean $i$f$any = false;
        PsiMethod[] psiMethodArray2 = $this$any$iv;
        int n = psiMethodArray2.length;
        int n2 = 0;
        while (n2 < n) {
            PsiMethod element$iv;
            PsiMethod it = element$iv = psiMethodArray2[n2];
            boolean bl = false;
            PsiMethod psiMethod = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"it");
            if (MnHttpUtils.hasRequestMappingJam(psiMethod)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Nullable
    public static final String getHttpParentResourcePath(@Nullable MnHttpMethodMapping httpMethod) {
        if (httpMethod == null) {
            return null;
        }
        PsiMethod psiMethod = (PsiMethod)httpMethod.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"httpMethod.psiElement");
        return MnHttpUtils.getHttpParentResourcePath(psiMethod.getContainingClass());
    }

    private static final String getHttpParentResourcePath(PsiClass holder) {
        JamService jamService;
        PsiClass psiClass = holder;
        if (psiClass == null) {
            return null;
        }
        PsiClass containingClass = psiClass;
        JamService jamService2 = jamService = JamService.getJamService((Project)holder.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)jamService2, (String)"jamService");
        String string = MnHttpUtils.getControllerResourcePath(jamService2, containingClass);
        if (string == null) {
            string = MnHttpUtils.getClientResourcePath(jamService, containingClass);
        }
        return string;
    }

    @Nullable
    public static final String getHttpResourcePath(@NotNull MnHttpMappingInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return MnHttpUtils.getHttpResourcePath(info.getMapping(), info.getHolder());
    }

    @Nullable
    public static final String getHttpResourcePath(@NotNull MnHttpMethodMapping httpMethod, @Nullable PsiClass holder) {
        String methodPath;
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
        UrlMappingBuilder builder = new UrlMappingBuilder();
        builder.appendSegment(MnHttpUtils.getHttpParentResourcePath(holder));
        PsiMethod psiMethod = (PsiMethod)httpMethod.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"httpMethod.psiElement");
        PsiMethod psiMethod2 = psiMethod;
        JamService jamService = JamService.getJamService((Project)psiMethod2.getProject());
        MnMethodUriMapping mnMethodUriMapping = (MnMethodUriMapping)jamService.getJamElement((PsiElement)psiMethod2, new JamMemberMeta[]{(JamMemberMeta)MnMethodUriMapping.META});
        String string = methodPath = mnMethodUriMapping != null ? mnMethodUriMapping.getResourceValue() : null;
        if (methodPath != null) {
            builder.appendSegment(methodPath);
        } else {
            builder.appendSegment(httpMethod.getResourceValue());
        }
        return builder.buildOrNull();
    }

    @Nullable
    public static final String getHttpResourcePath(@NotNull MnController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        String string = controller.getResourceValue();
        if (string == null) {
            JamService jamService = JamService.getJamService((Project)controller.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)jamService, (String)"JamService.getJamService(controller.project)");
            PsiClass psiClass = controller.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"controller.psiElement");
            string = MnHttpUtils.getClassUriMapping(jamService, psiClass);
        }
        return string;
    }

    @Nullable
    public static final String getHttpResourcePath(@NotNull MnClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String string = client.getResourceValue();
        if (string == null) {
            JamService jamService = JamService.getJamService((Project)client.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)jamService, (String)"JamService.getJamService(client.project)");
            PsiClass psiClass = client.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"client.psiElement");
            string = MnHttpUtils.getClassUriMapping(jamService, psiClass);
        }
        return string;
    }

    private static final String getControllerResourcePath(JamService jamService, PsiClass psiClass) {
        Object object = (MnController)MnController.META.getJamElement((PsiModifierListOwner)psiClass);
        if (object == null || (object = ((MnController)object).getResourceValue()) == null) {
            object = MnHttpUtils.getClassUriMapping(jamService, psiClass);
        }
        return object;
    }

    private static final String getClientResourcePath(JamService jamService, PsiClass psiClass) {
        Object object = (MnClient)MnClient.META.getJamElement((PsiModifierListOwner)psiClass);
        if (object == null || (object = ((MnClient)object).getResourceValue()) == null) {
            object = MnHttpUtils.getClassUriMapping(jamService, psiClass);
        }
        return object;
    }

    private static final String getClassUriMapping(JamService jamService, PsiClass psiClass) {
        MnClassUriMapping mnClassUriMapping = (MnClassUriMapping)jamService.getJamElement((PsiElement)psiClass, new JamMemberMeta[]{(JamMemberMeta)MnClassUriMapping.META});
        return mnClassUriMapping != null ? mnClassUriMapping.getResourceValue() : null;
    }

    @NotNull
    public static final ElementPattern<? extends UElement>[] getHttpPropertyPatterns(@NotNull UExpressionPattern<UExpression, ?> injection) {
        Intrinsics.checkNotNullParameter(injection, (String)"injection");
        ElementPattern[] elementPatternArray = new ElementPattern[6];
        StringPattern stringPattern = StandardPatterns.string().oneOf(new String[]{"io.micronaut.http.annotation.UriMapping", "io.micronaut.http.annotation.HttpMethodMapping", "io.micronaut.http.annotation.Controller"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"string().oneOf(\n        \u2026    MN_CONTROLLER\n      )");
        elementPatternArray[0] = (ElementPattern)injection.annotationParam((ElementPattern)stringPattern, "value");
        StringPattern stringPattern2 = StandardPatterns.string().oneOf(new String[]{"value", "path", "id"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern2, (String)"string().oneOf(\"value\", \"path\", \"id\")");
        elementPatternArray[1] = (ElementPattern)injection.annotationParams("io.micronaut.http.client.annotation.Client", (ElementPattern)stringPattern2);
        List list = CollectionsKt.listOf((Object[])new String[]{"io.micronaut.http.annotation.Get", "io.micronaut.http.annotation.Patch", "io.micronaut.http.annotation.Put", "io.micronaut.http.annotation.Post", "io.micronaut.http.annotation.Delete", "io.micronaut.http.annotation.Head", "io.micronaut.http.annotation.Trace", "io.micronaut.http.annotation.Options", "io.micronaut.http.annotation.CustomHttpMethod"});
        StringPattern stringPattern3 = StandardPatterns.string().oneOf(new String[]{"value", "uri"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern3, (String)"string().oneOf(\"value\", \"uri\")");
        elementPatternArray[2] = (ElementPattern)injection.annotationParams(list, (ElementPattern)stringPattern3);
        StringPattern stringPattern4 = StandardPatterns.string().oneOf(new String[]{"io.micronaut.http.annotation.Body", "io.micronaut.http.annotation.CookieValue", "io.micronaut.http.annotation.QueryValue", "io.micronaut.http.annotation.Part"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern4, (String)"string().oneOf(\n        \u2026,\n        MN_PART\n      )");
        elementPatternArray[3] = (ElementPattern)injection.annotationParam((ElementPattern)stringPattern4, "value");
        StringPattern stringPattern5 = StandardPatterns.string().oneOf(new String[]{"value", "name"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern5, (String)"string().oneOf(\"value\", \"name\")");
        elementPatternArray[4] = (ElementPattern)injection.annotationParams("io.micronaut.http.annotation.Header", (ElementPattern)stringPattern5);
        StringPattern stringPattern6 = StandardPatterns.string().oneOf(new String[]{"value", "name"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern6, (String)"string().oneOf(\"value\", \"name\")");
        elementPatternArray[5] = (ElementPattern)injection.annotationParams("io.micronaut.http.annotation.RequestAttribute", (ElementPattern)stringPattern6);
        return elementPatternArray;
    }
}

