/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.provider.http.MnHttpUrlResolverKt;
import com.intellij.microservices.uast.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.psi.PsiElement;
import icons.JavaUltimateIcons;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\u000bJ\n\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\rR\u0014\u0010!\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpUrlTargetInfo;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "schemes", "", "", "path", "Lcom/intellij/microservices/url/UrlPath;", "info", "Lcom/intellij/micronaut/jam/http/MnHttpMappingInfo;", "authorities", "Lcom/intellij/microservices/url/Authority;", "(Ljava/util/List;Lcom/intellij/microservices/url/UrlPath;Lcom/intellij/micronaut/jam/http/MnHttpMappingInfo;Ljava/util/List;)V", "getAuthorities", "()Ljava/util/List;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "isDeprecated", "", "()Z", "methods", "", "getMethods", "()Ljava/util/Set;", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "queryParameters", "", "Lcom/intellij/microservices/url/UrlQueryParameter;", "getQueryParameters", "()Ljava/lang/Iterable;", "getSchemes", "source", "getSource", "()Ljava/lang/String;", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "intellij.micronaut"})
public final class MnHttpUrlTargetInfo
implements UrlTargetInfo {
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final UrlPath path;
    private final MnHttpMappingInfo info;
    @NotNull
    private final List<Authority> authorities;

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Web.RequestMapping;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Web.RequestMapping");
        return icon;
    }

    public boolean isDeprecated() {
        return UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)this.resolveToPsiElement());
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        if (!this.info.isValid()) {
            return null;
        }
        return (PsiElement)this.info.getMapping().getPsiElement();
    }

    @NotNull
    public Set<String> getMethods() {
        return UrlPathModelKt.getDeclaredHttpMethods((String)this.info.getMapping().getHttpMethod());
    }

    @NotNull
    public String getSource() {
        Object object = this.info.getHolder();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public Iterable<UrlQueryParameter> getQueryParameters() {
        return MnHttpUrlResolverKt.getMnQueryParameterSupport().getParametersFromDeclarationContext(this.resolveToPsiElement());
    }

    @NotNull
    public List<String> getSchemes() {
        return this.schemes;
    }

    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return this.authorities;
    }

    public MnHttpUrlTargetInfo(@NotNull List<String> schemes, @NotNull UrlPath path, @NotNull MnHttpMappingInfo info, @NotNull List<? extends Authority> authorities) {
        Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        this.schemes = schemes;
        this.path = path;
        this.info = info;
        this.authorities = authorities;
    }

    public /* synthetic */ MnHttpUrlTargetInfo(List list, UrlPath urlPath, MnHttpMappingInfo mnHttpMappingInfo, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            List list3 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"emptyList()");
            list2 = list3;
        }
        this(list, urlPath, mnHttpMappingInfo, list2);
    }
}

