/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.ide.presentation.Presentation;
import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.jam.http.MnHttpModel;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.provider.http.MnHttpUrlResolver;
import com.intellij.micronaut.provider.http.MnHttpUrlTargetInfo;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Micronaut HTTP", icon="JavaUltimateIcons.Web.RequestMapping")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getVariants", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "resolve", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "Factory", "intellij.micronaut"})
public final class MnHttpUrlResolver
extends HttpUrlResolver {
    private final Project myProject;

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(request2.getPath()), (Function1)((Function1)new Function1<UrlPath, Sequence<? extends MnHttpUrlTargetInfo>>(this){
            final /* synthetic */ MnHttpUrlResolver this$0;

            @NotNull
            public final Sequence<MnHttpUrlTargetInfo> invoke(@NotNull UrlPath path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Sequence<MnHttpMappingInfo> sequence = MnHttpModel.resolveUrl(MnHttpUrlResolver.access$getMyProject$p(this.this$0), path.toStringWithStars());
                Intrinsics.checkNotNullExpressionValue(sequence, (String)"MnHttpModel.resolveUrl(m\u2026path.toStringWithStars())");
                return SequencesKt.map(sequence, (Function1)((Function1)new Function1<MnHttpMappingInfo, MnHttpUrlTargetInfo>(this, path){
                    final /* synthetic */ resolve.1 this$0;
                    final /* synthetic */ UrlPath $path;

                    @NotNull
                    public final MnHttpUrlTargetInfo invoke(MnHttpMappingInfo resolved) {
                        List list = this.this$0.this$0.getSupportedSchemes();
                        MnHttpMappingInfo mnHttpMappingInfo = resolved;
                        Intrinsics.checkNotNullExpressionValue((Object)mnHttpMappingInfo, (String)"resolved");
                        return new MnHttpUrlTargetInfo(list, this.$path, mnHttpMappingInfo, null, 8, null);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$path = urlPath;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = mnHttpUrlResolver;
                super(1);
            }
        })));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        Sequence<MnHttpMappingInfo> sequence = MnHttpModel.getHttpMethodMappings(this.myProject);
        Intrinsics.checkNotNullExpressionValue(sequence, (String)"MnHttpModel.getHttpMethodMappings(myProject)");
        Sequence<MnHttpMappingInfo> sequence2 = sequence;
        boolean bl = false;
        return SequencesKt.asIterable((Sequence)SequencesKt.map(sequence2, (Function1)((Function1)new Function1<MnHttpMappingInfo, MnHttpUrlTargetInfo>(this){
            final /* synthetic */ MnHttpUrlResolver this$0;

            @NotNull
            public final MnHttpUrlTargetInfo invoke(MnHttpMappingInfo mapping) {
                MnHttpMappingInfo mnHttpMappingInfo = mapping;
                Intrinsics.checkNotNullExpressionValue((Object)mnHttpMappingInfo, (String)"mapping");
                UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(MnHttpUtils.getHttpResourcePath(mnHttpMappingInfo));
                return new MnHttpUrlTargetInfo(this.this$0.getSupportedSchemes(), urlPath, mapping, null, 8, null);
            }
            {
                this.this$0 = mnHttpUrlResolver;
                super(1);
            }
        })));
    }

    public MnHttpUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    public static final /* synthetic */ Project access$getMyProject$p(MnHttpUrlResolver $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.micronaut"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!MnHttpUtils.hasHttpClientLibrary(project) && !MnHttpUtils.hasHttpServerLibrary(project)) {
                return null;
            }
            return (UrlResolver)new MnHttpUrlResolver(project);
        }
    }
}

