/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.jam.http.MnClient;
import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.jam.http.MnHttpModel;
import com.intellij.micronaut.provider.http.MnHttpClientFramework;
import com.intellij.micronaut.provider.http.MnHttpUrlTargetInfo;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.micronaut.provider.url.MnUrlPathEscapeUtilsKt;
import com.intellij.microservices.cache.SourceTestLibSearcher;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ValueKey;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uast.UastModificationTracker;
import icons.JavaUltimateIcons;
import icons.MicronautIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00162\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpClientFramework;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/micronaut/jam/http/MnClient;", "Lcom/intellij/micronaut/jam/http/MnHttpMappingInfo;", "()V", "clientsSearcher", "Lcom/intellij/microservices/cache/SourceTestLibSearcher;", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getEndpointData", "", "group", "endpoint", "dataId", "", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "methodMapping", "isValidEndpoint", "", "intellij.micronaut"})
public final class MnHttpClientFramework
implements EndpointsProvider<MnClient, MnHttpMappingInfo> {
    private final SourceTestLibSearcher<MnClient> clientsSearcher = new SourceTestLibSearcher("MN_CLIENTS", (Function2)clientsSearcher.1.INSTANCE);
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("Micronaut-HTTP-Client", MicronautBundle.message("micronaut.http.client.framework.title", new Object[0]), MicronautIcons.MicronautLogo);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_CLIENT_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MnHttpUtils.hasHttpClientLibrary(project) ? EndpointsProvider.Status.AVAILABLE : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<MnClient> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!MnHttpUtils.hasHttpClientLibrary(((ModuleEndpointsFilter)filter).getModule())) {
            return CollectionsKt.emptyList();
        }
        return this.clientsSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<MnHttpMappingInfo> getEndpoints(@NotNull MnClient group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        List<MnHttpMappingInfo> list = MnHttpModel.getHttpMethods(group.getPsiElement());
        Intrinsics.checkNotNullExpressionValue(list, (String)"MnHttpModel.getHttpMethods(group.psiElement)");
        return list;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull MnClient group, @NotNull MnHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String string = MnHttpUtils.getHttpResourcePath(endpoint);
        String string2 = endpoint.getMapping().getHttpMethod();
        PsiClass psiClass = group.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"group.psiElement");
        return (ItemPresentation)new HttpMethodPresentation(string, string2, psiClass.getName(), JavaUltimateIcons.Web.RequestMapping);
    }

    @Nullable
    public Object getEndpointData(@NotNull MnClient group, @NotNull MnHttpMappingInfo endpoint, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        ValueKey.BeforeIf beforeIf = ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.URL_TARGET_INFO).thenGet((Supplier)new Supplier<Iterable<? extends UrlTargetInfo>>(this, endpoint){
            final /* synthetic */ MnHttpClientFramework this$0;
            final /* synthetic */ MnHttpMappingInfo $endpoint;

            public final Iterable<UrlTargetInfo> get() {
                return MnHttpClientFramework.access$getUrlTargetInfo(this.this$0, this.$endpoint);
            }
            {
                this.this$0 = mnHttpClientFramework;
                this.$endpoint = mnHttpMappingInfo;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)beforeIf, (String)"ValueKey.match(dataId)\n \u2026UrlTargetInfo(endpoint) }");
        return EndpointsViewUtils.orCheckCommonEndpointKeys((ValueKey.BeforeIf)beforeIf, (PsiElement)((PsiElement)endpoint.getMapping().getPsiElement()));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Iterable<UrlTargetInfo> getUrlTargetInfo(MnHttpMappingInfo methodMapping) {
        fullUrl = MnUrlPathEscapeUtilsKt.mnParseFullUrl(MnHttpUtils.getHttpResourcePath(methodMapping));
        v0 = fullUrl;
        if (v0 == null || (v0 = v0.getUrlPath()) == null) {
            v0 = UrlPath.Companion.getEMPTY();
        }
        urlPath = v0;
        v1 = fullUrl;
        $this$map$iv = CollectionsKt.listOfNotNull(v1 != null && (v1 = v1.getAuthority()) != null ? v1.getValueIfKnown() : null);
        $i$f$map = false;
        var7_8 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var12_21 = (String)item$iv$iv;
            var14_23 = destination$iv$iv;
            $i$a$-map-MnHttpClientFramework$getUrlTargetInfo$authorities$1 = false;
            var15_24 = new Authority.Exact((String)it);
            var14_23.add(var15_24);
        }
        authorities = (List)destination$iv$iv;
        v2 /* !! */  = fullUrl;
        if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .getScheme()) == null) ** GOTO lbl-1000
        var6_6 = v2 /* !! */ ;
        var7_9 = false;
        var8_12 = false;
        it = var6_6;
        $i$a$-takeUnless-MnHttpClientFramework$getUrlTargetInfo$schemes$1 = false;
        v2 /* !! */  = it.getSegments().isEmpty() == false ? var6_6 : null;
        if (v2 /* !! */  != null) {
            v3 = v2 /* !! */ .getValueIfKnown();
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        var6_7 = CollectionsKt.listOfNotNull(v3);
        var7_10 = false;
        var8_13 = false;
        it = var6_7;
        $i$a$-takeUnless-MnHttpClientFramework$getUrlTargetInfo$schemes$2 = false;
        v4 = it.isEmpty() == false ? var6_7 : null;
        if (v4 == null) {
            v4 = UrlConstants.HTTP_SCHEMES;
        }
        schemes = v4;
        return CollectionsKt.listOf((Object)new MnHttpUrlTargetInfo((List<String>)schemes, (UrlPath)urlPath, methodMapping, authorities));
    }

    public boolean isValidEndpoint(@NotNull MnClient group, @NotNull MnHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }

    public static final /* synthetic */ Iterable access$getUrlTargetInfo(MnHttpClientFramework $this, MnHttpMappingInfo methodMapping) {
        return $this.getUrlTargetInfo(methodMapping);
    }
}

