/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.beans;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.events.EventSubscription;
import com.intellij.micronaut.events.MnEventUtilsKt;
import com.intellij.micronaut.events.PublishEventPoint;
import com.intellij.micronaut.jam.beans.MnBeansConstants;
import com.intellij.micronaut.jam.beans.MnScheduled;
import com.intellij.micronaut.provider.base.MnLineMarkerProvider;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import icons.JavaUltimateIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J2\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/micronaut/provider/beans/MnEventsLineMarkers;", "Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "()V", "annotateClass", "", "uClass", "Lorg/jetbrains/uast/UClass;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "annotateMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "annotateMethodCall", "uMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "collectNavigationMarkers", "elements", "", "forNavigation", "", "findEventListeners", "", "psiElement", "findEventPublishers", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "getIcon", "Ljavax/swing/Icon;", "getName", "", "getPublishEventRenderer", "Lcom/intellij/ide/util/DefaultPsiElementCellRenderer;", "isLifecycleMethod", "isScheduledMethod", "intellij.micronaut"})
public final class MnEventsLineMarkers
extends MnLineMarkerProvider {
    @Nullable
    public String getName() {
        return MicronautBundle.message("micronaut.event.markers", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return JavaUltimateIcons.Cdi.Gutter.Listener;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
                if (psiElement == null) break block2;
                Project project = psiElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                if (MicronautUtilsKt.hasMicronautLibrary(project)) break block3;
            }
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    @Override
    protected void annotateClass(@NotNull UClass uClass, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        PsiClass psiClass = uClass.getJavaPsi();
        if (MnEventUtilsKt.isEventClass(psiClass)) {
            Icon icon = JavaUltimateIcons.Cdi.Gutter.Event;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Cdi.Gutter.Event");
            result.add((RelatedItemLineMarkerInfo<PsiElement>)this.marker(identifier, icon, MicronautBundle.message("micronaut.event.class.tooltip.text", new Object[0])));
        }
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        block8: {
            RelatedItemLineMarkerInfo receiverMarker;
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo;
            Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
            Intrinsics.checkNotNullParameter(result, (String)"result");
            PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor());
            if (psiElement == null) {
                return;
            }
            PsiElement identifier = psiElement;
            PsiMethod psiMethod = uMethod.getJavaPsi();
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null || psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract") || psiMethod.isConstructor() || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass)) {
                return;
            }
            if (this.isScheduledMethod(psiMethod)) {
                Icon icon = JavaUltimateIcons.Cdi.Gutter.ScheduledEvent;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Cdi.Gutter.ScheduledEvent");
                relatedItemLineMarkerInfo = this.marker(identifier, icon, MicronautBundle.message("micronaut.scheduled.method.tooltip.text", new Object[0]));
            } else if (this.isLifecycleMethod(psiMethod)) {
                Icon icon = JavaUltimateIcons.Cdi.Gutter.Publisher;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Cdi.Gutter.Publisher");
                relatedItemLineMarkerInfo = this.marker(identifier, icon, MicronautBundle.message("micronaut.lifecycle.method.tooltip.text", new Object[0]));
            } else if (MnEventUtilsKt.isEventListenerMethod(psiMethod)) {
                Icon icon = JavaUltimateIcons.Cdi.Gutter.Publisher;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Cdi.Gutter.Publisher");
                NavigationGutterIconBuilder navigationGutterIconBuilder = MnLineMarkerBuilder.INSTANCE.create(icon).setAlignment(GutterIconRenderer.Alignment.LEFT).setPopupTitle(MicronautBundle.message("micronaut.event.publishers.popup.title", new Object[0])).setEmptyPopupText(MicronautBundle.message("micronaut.event.publishers.popup.empty", new Object[0])).setTargets(this.findEventPublishers(psiMethod)).setTooltipText(MicronautBundle.message("micronaut.event.listener.tooltip.text", new Object[0])).setCellRenderer((PsiElementListCellRenderer)this.getPublishEventRenderer());
                Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"MnLineMarkerBuilder.crea\u2026etPublishEventRenderer())");
                NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
                relatedItemLineMarkerInfo = builder.createLineMarkerInfo(identifier);
            } else {
                relatedItemLineMarkerInfo = null;
            }
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo2 = receiverMarker = relatedItemLineMarkerInfo;
            if (relatedItemLineMarkerInfo2 == null) break block8;
            RelatedItemLineMarkerInfo relatedItemLineMarkerInfo3 = relatedItemLineMarkerInfo2;
            boolean bl = false;
            boolean bl2 = false;
            RelatedItemLineMarkerInfo it = relatedItemLineMarkerInfo3;
            boolean bl3 = false;
            result.add((RelatedItemLineMarkerInfo<PsiElement>)it);
        }
    }

    @Override
    protected void annotateMethodCall(@NotNull UCallExpression uMethodCall, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uMethodCall, (String)"uMethodCall");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (!MnEventUtilsKt.isPublishEventExpression(uMethodCall)) {
            return;
        }
        PsiElement psiElement = uMethodCall.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement sourcePsi = psiElement;
        PsiElement psiElement2 = UElementKt.getSourcePsiElement((UElement)((UElement)uMethodCall.getMethodIdentifier()));
        if (psiElement2 == null) {
            return;
        }
        PsiElement identifier = psiElement2;
        Icon icon = JavaUltimateIcons.Cdi.Gutter.Listener;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Cdi.Gutter.Listener");
        NavigationGutterIconBuilder navigationGutterIconBuilder = MnLineMarkerBuilder.INSTANCE.create(icon).setAlignment(GutterIconRenderer.Alignment.LEFT).setPopupTitle(MicronautBundle.message("micronaut.event.listeners.popup.title", new Object[0])).setEmptyPopupText(MicronautBundle.message("micronaut.event.listeners.popup.empty", new Object[0])).setTargets(this.findEventListeners(sourcePsi)).setTooltipText(MicronautBundle.message("micronaut.event.publisher.tooltip.text", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)navigationGutterIconBuilder, (String)"MnLineMarkerBuilder.crea\u2026publisher.tooltip.text\"))");
        NavigationGutterIconBuilder builder = navigationGutterIconBuilder;
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = builder.createLineMarkerInfo(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"builder.createLineMarkerInfo(identifier)");
        result.add((RelatedItemLineMarkerInfo<PsiElement>)relatedItemLineMarkerInfo);
    }

    private final DefaultPsiElementCellRenderer getPublishEventRenderer() {
        return new DefaultPsiElementCellRenderer(){

            @NotNull
            protected Icon getIcon(@NotNull PsiElement element) {
                Icon icon;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiMethodCallExpression) {
                    Icon icon2 = JavaUltimateIcons.Cdi.Gutter.Publisher;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"JavaUltimateIcons.Cdi.Gutter.Publisher");
                } else {
                    Icon icon3 = super.getIcon(element);
                    icon = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"super.getIcon(element)");
                }
                return icon;
            }

            @Nullable
            public String getContainerText(@NotNull PsiElement element, @NotNull String name) {
                PsiClass containingClass;
                PsiMethod psiMethod;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                if (element instanceof PsiMethodCallExpression && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) != null && (containingClass = psiMethod.getContainingClass()) != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)((PsiElement)containingClass))).append(".").append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)((PsiElement)psiMethod)));
                    return sb.toString();
                }
                return super.getContainerText(element, name);
            }
        };
    }

    private final boolean isLifecycleMethod(PsiMethod psiMethod) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)MnBeansConstants.getBEANS_LIFECYCLE_METHODS(), (int)0);
    }

    private final boolean isScheduledMethod(PsiMethod psiMethod) {
        return MnScheduled.META.getJamElement((PsiModifierListOwner)psiMethod) != null;
    }

    private final Collection<PsiElement> findEventPublishers(PsiMethod psiMethod) {
        PsiParameterList psiParameterList = psiMethod.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"psiMethod.parameterList");
        if (psiParameterList.getParametersCount() != 1) {
            return CollectionsKt.emptyList();
        }
        PsiParameterList psiParameterList2 = psiMethod.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList2, (String)"psiMethod.parameterList");
        PsiParameter psiParameter = psiParameterList2.getParameters()[0];
        Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"psiMethod.parameterList.parameters[0]");
        PsiType psiType = psiParameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"psiMethod.parameterList.parameters[0].type");
        PsiType eventType = psiType;
        if (!eventType.isValid() || !(eventType instanceof PsiClassType)) {
            return CollectionsKt.emptyList();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiMethod));
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026od) ?: return emptyList()");
        Module module2 = module;
        Collection<PublishEventPoint> publishPoints = MnEventUtilsKt.getEventPublishPoints(module2, eventType);
        ArrayList<PsiElement> list = new ArrayList<PsiElement>(publishPoints.size());
        for (PublishEventPoint point : publishPoints) {
            PsiElement element = point.getElement();
            if (element == null) continue;
            list.add(element.getNavigationElement());
        }
        return list;
    }

    private final Collection<PsiElement> findEventListeners(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026nt) ?: return emptyList()");
        Module module2 = module;
        PsiElement $this$toUElementOfType$iv = psiElement;
        boolean $i$f$toUElementOfType = false;
        UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UCallExpression.class);
        if (uCallExpression == null) {
            return CollectionsKt.emptyList();
        }
        UCallExpression uCallExpression2 = uCallExpression;
        if (uCallExpression2.getValueArgumentCount() != 1) {
            return CollectionsKt.emptyList();
        }
        PsiType psiType = ((UExpression)uCallExpression2.getValueArguments().get(0)).getExpressionType();
        if (psiType == null) {
            return CollectionsKt.emptyList();
        }
        PsiType eventType = psiType;
        Collection<EventSubscription> eventListeners = MnEventUtilsKt.getEventListeners(module2, eventType);
        ArrayList<PsiElement> list = new ArrayList<PsiElement>(eventListeners.size());
        for (EventSubscription listener : eventListeners) {
            PsiMethod m = listener.getMethod();
            if (m == null) continue;
            list.add(m.getNavigationElement());
        }
        return list;
    }
}

