/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.beans;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.jam.beans.JamPsiMemberMicronautBean;
import com.intellij.micronaut.jam.beans.MnBeansConstants;
import com.intellij.micronaut.jam.beans.MnFactoryMethodBean;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\u001a\u0016\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a-\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u00052\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\tH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a-\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u00052\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\tH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u001a\u0012\u0010\u0019\u001a\u00020\u000e2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0001\u001a\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u001b\u001a\u00020\u000e2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0001\u001a\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006!"}, d2={"getBeanMapping", "Lcom/intellij/micronaut/jam/beans/JamPsiMemberMicronautBean;", "psiClass", "Lcom/intellij/psi/PsiClass;", "getBeansPropertyPatterns", "", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UElement;", "injection", "Lcom/intellij/patterns/uast/UExpressionPattern;", "Lorg/jetbrains/uast/UExpression;", "(Lcom/intellij/patterns/uast/UExpressionPattern;)[Lcom/intellij/patterns/ElementPattern;", "getRetryPropertyPatterns", "hasBeansImplicitRead", "", "element", "Lcom/intellij/psi/PsiElement;", "hasBeansImplicitUsage", "hasBeansImplicitWrite", "hasWriteAnnotation", "isAnnotatedBeanMethod", "Lcom/intellij/psi/PsiMethod;", "annotations", "", "", "isBeanCandidateClass", "isBeanClassOrConstructor", "isBeanMappedClass", "isEventListenerAnnotatedMethod", "isEventListenerParameter", "isFactoryBeanMethod", "isLifeCycleMethod", "isStereotypeComponentOrMeta", "intellij.micronaut"})
public final class MicronautBeanUtilsKt {
    @Contract(value="null->false")
    public static final boolean isBeanCandidateClass(@Nullable PsiClass psiClass) {
        return psiClass != null && !(psiClass instanceof PsiTypeParameter) && !psiClass.hasModifierProperty("private") && !psiClass.isAnnotationType() && psiClass.getQualifiedName() != null && !PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass);
    }

    @Contract(value="null->false")
    public static final boolean isBeanMappedClass(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (!MicronautBeanUtilsKt.isBeanCandidateClass(psiClass)) {
            return false;
        }
        Project project = psiClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiClass.project");
        if (!MicronautUtilsKt.hasMicronautLibrary(project)) {
            return false;
        }
        return MicronautBeanUtilsKt.isStereotypeComponentOrMeta(psiClass);
    }

    @Nullable
    public static final JamPsiMemberMicronautBean<?> getBeanMapping(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (!MicronautBeanUtilsKt.isBeanCandidateClass(psiClass)) {
            return null;
        }
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        return (JamPsiMemberMicronautBean)jamService.getJamElement(JamPsiMemberMicronautBean.PSI_MEMBER_BEAN_JAM_KEY, (PsiElement)psiClass);
    }

    private static final boolean isStereotypeComponentOrMeta(PsiClass psiClass) {
        if (!MicronautBeanUtilsKt.isBeanCandidateClass(psiClass)) {
            return false;
        }
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        return jamService.getJamElement(JamPsiMemberMicronautBean.PSI_MEMBER_BEAN_JAM_KEY, (PsiElement)psiClass) != null;
    }

    @NotNull
    public static final ElementPattern<? extends UElement>[] getBeansPropertyPatterns(@NotNull UExpressionPattern<UExpression, ?> injection) {
        Intrinsics.checkNotNullParameter(injection, (String)"injection");
        ElementPattern[] elementPatternArray = new ElementPattern[3];
        elementPatternArray[0] = (ElementPattern)injection.annotationParam("io.micronaut.context.annotation.Value", "value");
        StringPattern stringPattern = StandardPatterns.string().oneOf(new String[]{"value", "defaultValue", "pattern"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"string().oneOf(\"value\", \"defaultValue\", \"pattern\")");
        elementPatternArray[1] = (ElementPattern)injection.annotationParams("io.micronaut.context.annotation.Requires", (ElementPattern)stringPattern);
        StringPattern stringPattern2 = StandardPatterns.string().oneOf(new String[]{"cron", "fixedDelay", "initialDelay", "fixedRate"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern2, (String)"string().oneOf(\"cron\", \"\u2026itialDelay\", \"fixedRate\")");
        elementPatternArray[2] = (ElementPattern)injection.annotationParams("io.micronaut.scheduling.annotation.Scheduled", (ElementPattern)stringPattern2);
        return elementPatternArray;
    }

    @NotNull
    public static final ElementPattern<? extends UElement>[] getRetryPropertyPatterns(@NotNull UExpressionPattern<UExpression, ?> injection) {
        Intrinsics.checkNotNullParameter(injection, (String)"injection");
        ElementPattern[] elementPatternArray = new ElementPattern[2];
        StringPattern stringPattern = StandardPatterns.string().oneOf(new String[]{"attempts", "delay", "maxDelay", "multiplier"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"string().oneOf(\"attempts\u2026\"maxDelay\", \"multiplier\")");
        elementPatternArray[0] = (ElementPattern)injection.annotationParams("io.micronaut.retry.annotation.Retryable", (ElementPattern)stringPattern);
        StringPattern stringPattern2 = StandardPatterns.string().oneOf(new String[]{"attempts", "delay", "maxDelay", "multiplier", "reset"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern2, (String)"string().oneOf(\"attempts\u2026\", \"multiplier\", \"reset\")");
        elementPatternArray[1] = (ElementPattern)injection.annotationParams("io.micronaut.retry.annotation.CircuitBreaker", (ElementPattern)stringPattern2);
        return elementPatternArray;
    }

    public static final boolean hasBeansImplicitRead(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return MicronautBeanUtilsKt.isFactoryBeanMethod(element);
    }

    public static final boolean hasBeansImplicitWrite(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return MicronautBeanUtilsKt.hasWriteAnnotation(element) || MicronautBeanUtilsKt.isLifeCycleMethod(element) || MicronautBeanUtilsKt.isEventListenerAnnotatedMethod(element);
    }

    public static final boolean hasBeansImplicitUsage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (MicronautBeanUtilsKt.hasWriteAnnotation(element) || MicronautBeanUtilsKt.isBeanClassOrConstructor(element) || MicronautBeanUtilsKt.isLifeCycleMethod(element) || MicronautBeanUtilsKt.isEventListenerAnnotatedMethod(element) || MicronautBeanUtilsKt.isFactoryBeanMethod(element)) {
            return true;
        }
        return MicronautBeanUtilsKt.isEventListenerParameter(element);
    }

    private static final boolean hasWriteAnnotation(PsiElement element) {
        block7: {
            block6: {
                if (!(element instanceof PsiModifierListOwner)) {
                    return false;
                }
                if (element instanceof PsiParameter || element instanceof PsiLocalVariable) {
                    return false;
                }
                PsiModifierList modifierList = ((PsiModifierListOwner)element).getModifierList();
                if (modifierList == null) break block6;
                PsiAnnotation[] psiAnnotationArray = modifierList.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"modifierList.annotations");
                PsiAnnotation[] psiAnnotationArray2 = psiAnnotationArray;
                boolean bl = false;
                if (!(psiAnnotationArray2.length == 0)) break block7;
            }
            return false;
        }
        Project project = ((PsiModifierListOwner)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        if (!MicronautUtilsKt.hasMicronautLibrary(project)) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)MnBeansConstants.getBEANS_IMPLICIT_WRITE_ANNOTATIONS(), (int)0);
    }

    private static final boolean isBeanClassOrConstructor(PsiElement element) {
        if (element instanceof PsiClass) {
            return MicronautBeanUtilsKt.isBeanMappedClass((PsiClass)element);
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return MicronautBeanUtilsKt.isBeanMappedClass(containingClass);
        }
        return false;
    }

    private static final boolean isLifeCycleMethod(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiParameterList psiParameterList = ((PsiMethod)element).getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"element.parameterList");
        int parametersCount = psiParameterList.getParametersCount();
        if (parametersCount > 0) {
            return false;
        }
        return MicronautBeanUtilsKt.isAnnotatedBeanMethod((PsiMethod)element, MnBeansConstants.getBEANS_EVENT_BASED_METHODS());
    }

    private static final boolean isEventListenerAnnotatedMethod(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiParameterList psiParameterList = ((PsiMethod)element).getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"element.parameterList");
        int parametersCount = psiParameterList.getParametersCount();
        if (parametersCount != 1) {
            return false;
        }
        return MicronautBeanUtilsKt.isAnnotatedBeanMethod((PsiMethod)element, CollectionsKt.listOf((Object)"io.micronaut.runtime.event.annotation.EventListener"));
    }

    private static final boolean isEventListenerParameter(PsiElement element) {
        PsiElement parentMethod;
        if (!(element instanceof PsiParameter)) {
            return false;
        }
        PsiElement psiElement = ((PsiParameter)element).getParent();
        Object object = parentMethod = psiElement != null ? psiElement.getParent() : null;
        if (!(parentMethod instanceof PsiMethod)) {
            return false;
        }
        if (!MicronautBeanUtilsKt.isEventListenerAnnotatedMethod(parentMethod)) {
            return false;
        }
        PsiTypeElement typeElement = ((PsiParameter)element).getTypeElement();
        return typeElement != null && typeElement.getType() instanceof PsiClassType;
    }

    private static final boolean isFactoryBeanMethod(PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiType returnType = ((PsiMethod)element).getReturnType();
        if (!(returnType instanceof PsiClassType) || ((PsiMethod)element).getModifierList().hasModifierProperty("private")) {
            return false;
        }
        JamService jamService = JamService.getJamService((Project)((PsiMethod)element).getProject());
        return jamService.getJamElement(MnFactoryMethodBean.FACTORY_BEAN_JAM_KEY, element) != null;
    }

    private static final boolean isAnnotatedBeanMethod(PsiMethod element, List<String> annotations) {
        PsiClass psiClass = element.getContainingClass();
        if (element.getNameIdentifier() == null) {
            return false;
        }
        PsiModifierList psiModifierList = element.getModifierList();
        Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"element.modifierList");
        PsiModifierList modifierList = psiModifierList;
        PsiAnnotation[] psiAnnotationArray = modifierList.getAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"modifierList.annotations");
        PsiAnnotation[] psiAnnotationArray2 = psiAnnotationArray;
        boolean bl = false;
        if (psiAnnotationArray2.length == 0) {
            return false;
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)annotations, (int)0)) {
            return false;
        }
        return MicronautBeanUtilsKt.isBeanMappedClass(psiClass);
    }
}

