/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider;

import com.intellij.micronaut.config.MnConfigPlaceholderReference;
import com.intellij.micronaut.jam.beans.MnBeansConstants;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.micronaut.provider.management.MnManagementUtils;
import com.intellij.micronaut.provider.mq.MnMqUtilsKt;
import com.intellij.micronaut.provider.websocket.MnWebSocketUtilsKt;
import com.intellij.microservices.url.UrlSpecialSegmentMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiClassPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.util.SmartList;
import com.intellij.util.text.PlaceholderTextRanges;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\bJ1\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u001b\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/micronaut/provider/MnPropertyReferenceContributor;", "Lcom/intellij/psi/PsiReferenceContributor;", "()V", "createPlaceholderPropertiesReferences", "", "Lcom/intellij/psi/PsiReference;", "host", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "textRanges", "", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/micronaut/provider/MnPropertyReferenceContributor$PlaceholderInfo;", "valueElement", "(Ljava/util/Map;Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "createPlaceholderReference", "element", "textRange", "info", "createPropertyReferences", "getFullTextRange", "getPlaceholderPrefixes", "", "Lcom/intellij/microservices/url/UrlSpecialSegmentMarker;", "getTextRangesWithNested", "hasNestedPlaceholders", "", "ranges", "registerReferenceProviders", "", "registrar", "Lcom/intellij/psi/PsiReferenceRegistrar;", "PlaceholderInfo", "intellij.micronaut"})
public final class MnPropertyReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        UExpressionPattern injection = UastPatterns.injectionHostUExpression$default((boolean)false, (int)1, null);
        ElementPattern[] elementPatternArray = new ElementPattern[3];
        elementPatternArray[0] = (ElementPattern)injection.annotationParam("io.micronaut.context.annotation.Property", "name");
        elementPatternArray[1] = (ElementPattern)injection.annotationParam("io.micronaut.context.annotation.EachProperty", "value");
        StringPattern stringPattern = PsiJavaPatterns.string().oneOf(new String[]{"property", "missingProperty"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"string().oneOf(\"property\", \"missingProperty\")");
        elementPatternArray[2] = (ElementPattern)injection.annotationParams("io.micronaut.context.annotation.Requires", (ElementPattern)stringPattern);
        ElementPattern elementPattern = StandardPatterns.or((ElementPattern[])elementPatternArray);
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern, (String)"or(\n        injection.an\u2026issingProperty\"))\n      )");
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)elementPattern, (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((Function2)((Function2)new Function2<UExpression, PsiLanguageInjectionHost, PsiReference[]>(this){
            final /* synthetic */ MnPropertyReferenceContributor this$0;

            @NotNull
            public final PsiReference[] invoke(@NotNull UExpression $noName_0, @NotNull PsiLanguageInjectionHost host) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                return MnPropertyReferenceContributor.access$createPropertyReferences(this.this$0, (PsiElement)host);
            }
            {
                this.this$0 = mnPropertyReferenceContributor;
                super(2);
            }
        }))), (double)100.0);
        PsiClassPattern propertyResolver = PsiJavaPatterns.psiClass().inheritorOf(false, "io.micronaut.core.value.PropertyResolver");
        UCallExpressionPattern uCallExpressionPattern = UastPatterns.callExpression();
        StringPattern stringPattern2 = PsiJavaPatterns.string().oneOf(new String[]{"getProperty", "containsProperty", "getRequiredProperty"});
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern2, (String)"string().oneOf(\n        \u2026RequiredProperty\"\n      )");
        UCallExpressionPattern uCallExpressionPattern2 = uCallExpressionPattern.withMethodName((ElementPattern)stringPattern2);
        PsiClassPattern psiClassPattern = propertyResolver;
        Intrinsics.checkNotNullExpressionValue((Object)psiClassPattern, (String)"propertyResolver");
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((ElementPattern)injection.callParameter(0, (ElementPattern)uCallExpressionPattern2.withReceiver((ElementPattern)psiClassPattern))), (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((Function2)((Function2)new Function2<UExpression, PsiLanguageInjectionHost, PsiReference[]>(this){
            final /* synthetic */ MnPropertyReferenceContributor this$0;

            @NotNull
            public final PsiReference[] invoke(@NotNull UExpression $noName_0, @NotNull PsiLanguageInjectionHost host) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                return MnPropertyReferenceContributor.access$createPropertyReferences(this.this$0, (PsiElement)host);
            }
            {
                this.this$0 = mnPropertyReferenceContributor;
                super(2);
            }
        }))), (double)100.0);
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        spreadBuilder.addSpread(MicronautBeanUtilsKt.getBeansPropertyPatterns(injection));
        spreadBuilder.addSpread(MnHttpUtils.getHttpPropertyPatterns(injection));
        spreadBuilder.addSpread(MicronautBeanUtilsKt.getRetryPropertyPatterns(injection));
        spreadBuilder.addSpread(MnWebSocketUtilsKt.getWebSocketPropertyPatterns(injection));
        spreadBuilder.addSpread(MnManagementUtils.getManagementPropertyPatterns(injection));
        spreadBuilder.addSpread(MnMqUtilsKt.getMqPropertyPatterns(injection));
        ElementPattern elementPattern2 = StandardPatterns.or((ElementPattern[])((ElementPattern[])spreadBuilder.toArray((Object[])new ElementPattern[spreadBuilder.size()])));
        Intrinsics.checkNotNullExpressionValue((Object)elementPattern2, (String)"or(\n        *getBeansPro\u2026tterns(injection)\n      )");
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)elementPattern2, (UastReferenceProvider)((UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((Function2)((Function2)new Function2<UExpression, PsiLanguageInjectionHost, PsiReference[]>(this){
            final /* synthetic */ MnPropertyReferenceContributor this$0;

            @NotNull
            public final PsiReference[] invoke(@NotNull UExpression $noName_0, @NotNull PsiLanguageInjectionHost host) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                return MnPropertyReferenceContributor.access$createPlaceholderPropertiesReferences(this.this$0, (PsiElement)host);
            }
            {
                this.this$0 = mnPropertyReferenceContributor;
                super(2);
            }
        }))), (double)100.0);
    }

    private final PsiReference[] createPropertyReferences(PsiElement host) {
        return this.createPlaceholderPropertiesReferences(this.getFullTextRange(host), host);
    }

    private final PsiReference[] createPlaceholderPropertiesReferences(PsiElement host) {
        return this.createPlaceholderPropertiesReferences(this.getTextRangesWithNested(host), host);
    }

    private final Map<TextRange, PlaceholderInfo> getTextRangesWithNested(PsiElement element) {
        THashMap textRanges = new THashMap();
        Set<UrlSpecialSegmentMarker> prefixes = this.getPlaceholderPrefixes();
        for (UrlSpecialSegmentMarker prefixAndSuffix : prefixes) {
            String text = element.getText();
            for (TextRange textRange : PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)prefixAndSuffix.getPrefix(), (String)prefixAndSuffix.getSuffix())) {
                String placeholderText;
                Intrinsics.checkNotNullExpressionValue((Object)textRange.substring(text), (String)"textRange.substring(text)");
                Map map = (Map)textRanges;
                String string = text;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                TextRange textRange2 = textRange;
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRange");
                map.put(textRange, new PlaceholderInfo(placeholderText, prefixAndSuffix, string, textRange2));
            }
        }
        return (Map)textRanges;
    }

    private final Map<TextRange, PlaceholderInfo> getFullTextRange(PsiElement element) {
        String string = ElementManipulators.getValueText((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ElementManipulators.getValueText(element)");
        String text = string;
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"ElementManipulators.getValueTextRange(element)");
        TextRange textRange2 = textRange;
        Map<TextRange, PlaceholderInfo> map = Collections.singletonMap(textRange2, new PlaceholderInfo(text, new UrlSpecialSegmentMarker("", "", null, 4, null), text, textRange2));
        Intrinsics.checkNotNullExpressionValue(map, (String)"singletonMap(textRange, \u2026\", \"\"), text, textRange))");
        return map;
    }

    private final Set<UrlSpecialSegmentMarker> getPlaceholderPrefixes() {
        return SetsKt.setOf((Object)MnBeansConstants.getMN_PLACEHOLDER_BRACES());
    }

    /*
     * WARNING - void declaration
     */
    private final PsiReference[] createPlaceholderPropertiesReferences(Map<TextRange, PlaceholderInfo> textRanges, PsiElement valueElement) {
        if (valueElement == null || textRanges.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList references = new SmartList();
        TextRange textRange = textRanges;
        boolean bl = false;
        Iterator<Map.Entry<TextRange, PlaceholderInfo>> iterator = textRange.entrySet().iterator();
        while (iterator.hasNext()) {
            void textRange2;
            Map.Entry<TextRange, PlaceholderInfo> entry;
            Map.Entry<TextRange, PlaceholderInfo> entry2 = entry = iterator.next();
            boolean bl2 = false;
            textRange = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            PlaceholderInfo info = entry2.getValue();
            if (this.hasNestedPlaceholders((TextRange)textRange2, textRanges.keySet())) continue;
            references.add((Object)this.createPlaceholderReference(valueElement, (TextRange)textRange2, info));
        }
        Collection $this$toTypedArray$iv = (Collection)references;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiReference[] psiReferenceArray = thisCollection$iv.toArray(new PsiReference[0]);
        if (psiReferenceArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return psiReferenceArray;
    }

    private final boolean hasNestedPlaceholders(TextRange textRange, Set<? extends TextRange> ranges) {
        for (TextRange textRange2 : ranges) {
            if (!(Intrinsics.areEqual((Object)textRange2, (Object)textRange) ^ true) || !textRange.contains(textRange2)) continue;
            return true;
        }
        return false;
    }

    private final PsiReference createPlaceholderReference(PsiElement element, TextRange textRange, PlaceholderInfo info) {
        TextRange textRange2;
        String text = info.getText();
        int defaultValueSeparatorIndex = StringsKt.indexOf$default((CharSequence)text, (String)":", (int)0, (boolean)false, (int)6, null);
        if (defaultValueSeparatorIndex < 0) {
            textRange2 = textRange;
        } else {
            TextRange textRange3 = TextRange.from((int)textRange.getStartOffset(), (int)defaultValueSeparatorIndex);
            textRange2 = textRange3;
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"TextRange.from(textRange\u2026faultValueSeparatorIndex)");
        }
        TextRange referenceRange = textRange2;
        return (PsiReference)new MnConfigPlaceholderReference.Builder(element, referenceRange, false).withMetaConfigKeyVariants().build();
    }

    public static final /* synthetic */ PsiReference[] access$createPropertyReferences(MnPropertyReferenceContributor $this, PsiElement host) {
        return $this.createPropertyReferences(host);
    }

    public static final /* synthetic */ PsiReference[] access$createPlaceholderPropertiesReferences(MnPropertyReferenceContributor $this, PsiElement host) {
        return $this.createPlaceholderPropertiesReferences(host);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/intellij/micronaut/provider/MnPropertyReferenceContributor$PlaceholderInfo;", "", "text", "", "prefixAndSuffix", "Lcom/intellij/microservices/url/UrlSpecialSegmentMarker;", "myElementText", "fullTextRange", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/String;Lcom/intellij/microservices/url/UrlSpecialSegmentMarker;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;)V", "getFullTextRange", "()Lcom/intellij/openapi/util/TextRange;", "getMyElementText", "()Ljava/lang/String;", "getPrefixAndSuffix", "()Lcom/intellij/microservices/url/UrlSpecialSegmentMarker;", "getText", "intellij.micronaut"})
    private static final class PlaceholderInfo {
        @NotNull
        private final String text;
        @NotNull
        private final UrlSpecialSegmentMarker prefixAndSuffix;
        @NotNull
        private final String myElementText;
        @NotNull
        private final TextRange fullTextRange;

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final UrlSpecialSegmentMarker getPrefixAndSuffix() {
            return this.prefixAndSuffix;
        }

        @NotNull
        public final String getMyElementText() {
            return this.myElementText;
        }

        @NotNull
        public final TextRange getFullTextRange() {
            return this.fullTextRange;
        }

        public PlaceholderInfo(@NotNull String text, @NotNull UrlSpecialSegmentMarker prefixAndSuffix, @NotNull String myElementText, @NotNull TextRange fullTextRange) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)prefixAndSuffix, (String)"prefixAndSuffix");
            Intrinsics.checkNotNullParameter((Object)myElementText, (String)"myElementText");
            Intrinsics.checkNotNullParameter((Object)fullTextRange, (String)"fullTextRange");
            this.text = text;
            this.prefixAndSuffix = prefixAndSuffix;
            this.myElementText = myElementText;
            this.fullTextRange = fullTextRange;
        }
    }
}

