/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.jam.management;

import com.intellij.jam.JamService;
import com.intellij.micronaut.jam.management.MnManagementEndpoint;
import com.intellij.micronaut.jam.management.MnManagementMethod;
import com.intellij.micronaut.provider.management.MnManagementUtils;
import com.intellij.microservices.cache.CacheKeyPair;
import com.intellij.microservices.cache.CachedSearchUtils;
import com.intellij.microservices.cache.SourceLibSearchProvider;
import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

public final class MnManagementModel {
    private static final SourceLibSearchProvider<List<MnManagementMethod>, UserDataHolder> ENDPOINT_METHODS_CACHE_KEY = new SourceLibSearchProvider("MN_ENDPOINT_METHODS", (project, holder, scope) -> MnManagementModel.getEndpointMethods(project, scope));
    private static final CacheKeyPair<List<MnManagementEndpoint>> ENDPOINTS_CACHE_KEY = new CacheKeyPair("MN_ENDPOINTS");

    @NotNull
    public static List<MnManagementMethod> getManagementMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MnManagementModel.$$$reportNull$$$0(0);
        }
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        List list = jamService.getAnnotatedMembersList(psiClass, MnManagementMethod.ENDPOINT_METHOD_JAM_KEY, 10);
        if (list == null) {
            MnManagementModel.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<MnManagementEndpoint> findEndpoints(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            MnManagementModel.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            MnManagementModel.$$$reportNull$$$0(3);
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        List list = jamService.getJamClassElements(MnManagementEndpoint.META, "io.micronaut.management.endpoint.annotation.Endpoint", scope);
        if (list == null) {
            MnManagementModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static Sequence<MnManagementMethod> resolveUrl(@NotNull Project project, @NotNull String starsUrl) {
        if (project == null) {
            MnManagementModel.$$$reportNull$$$0(5);
        }
        if (starsUrl == null) {
            MnManagementModel.$$$reportNull$$$0(6);
        }
        return SequencesKt.filter(MnManagementModel.getEndpointMethods(project), mapping -> {
            String resourcePath = UrlPath.toStarsString((String)MnManagementUtils.getManagementResourcePath(mapping));
            return Objects.equals(starsUrl, resourcePath);
        });
    }

    public static Sequence<MnManagementMethod> getEndpointMethods(@NotNull Project project) {
        if (project == null) {
            MnManagementModel.$$$reportNull$$$0(7);
        }
        return CachedSearchUtils.sequenceWithCache((Project)project, ENDPOINT_METHODS_CACHE_KEY);
    }

    private static List<MnManagementMethod> getEndpointMethods(Project project, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)project);
        List controllers = jamService.getJamClassElements(MnManagementEndpoint.META, "io.micronaut.management.endpoint.annotation.Endpoint", scope);
        return controllers.stream().flatMap(c -> MnManagementModel.getManagementMethods(c.getPsiElement()).stream()).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/jam/management/MnManagementModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starsUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/jam/management/MnManagementModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagementMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findEndpoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManagementMethods";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findEndpoints";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveUrl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

