/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.jam.http;

import com.intellij.jam.JamService;
import com.intellij.micronaut.jam.http.MnClient;
import com.intellij.micronaut.jam.http.MnController;
import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.jam.http.mapping.MnErrorMethod;
import com.intellij.micronaut.jam.http.mapping.MnHttpMethodMapping;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.microservices.cache.CachedSearchUtils;
import com.intellij.microservices.cache.SourceLibSearchProvider;
import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

public final class MnHttpModel {
    private static final SourceLibSearchProvider<List<MnHttpMappingInfo>, UserDataHolder> HTTP_MAPPINGS_CACHE_KEY = new SourceLibSearchProvider("MN_HTTP_MAPPINGS", (project, holder, scope) -> MnHttpModel.getHttpMappings(project, scope));

    @NotNull
    public static List<MnHttpMappingInfo> getHttpMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MnHttpModel.$$$reportNull$$$0(0);
        }
        List<MnHttpMappingInfo> list = MnHttpModel.getHttpMethods(JamService.getJamService((Project)psiClass.getProject()), psiClass).collect(Collectors.toList());
        if (list == null) {
            MnHttpModel.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<MnController> findControllers(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            MnHttpModel.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            MnHttpModel.$$$reportNull$$$0(3);
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        List list = jamService.getJamClassElements(MnController.META, "io.micronaut.http.annotation.Controller", scope);
        if (list == null) {
            MnHttpModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<MnClient> findClients(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            MnHttpModel.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            MnHttpModel.$$$reportNull$$$0(6);
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        List list = jamService.getJamClassElements(MnClient.META, "io.micronaut.http.client.annotation.Client", scope);
        if (list == null) {
            MnHttpModel.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static Sequence<MnHttpMappingInfo> getHttpMethodMappings(@NotNull Project project) {
        if (project == null) {
            MnHttpModel.$$$reportNull$$$0(8);
        }
        return CachedSearchUtils.sequenceWithCache((Project)project, HTTP_MAPPINGS_CACHE_KEY);
    }

    public static Sequence<MnHttpMappingInfo> resolveUrl(@NotNull Project project, @NotNull String starsUrl) {
        if (project == null) {
            MnHttpModel.$$$reportNull$$$0(9);
        }
        if (starsUrl == null) {
            MnHttpModel.$$$reportNull$$$0(10);
        }
        return SequencesKt.filter(MnHttpModel.getHttpMethodMappings(project), mapping -> {
            String resourcePath = UrlPath.toStarsString((String)MnHttpUtils.getHttpResourcePath(mapping));
            return Objects.equals(starsUrl, resourcePath);
        });
    }

    private static List<MnHttpMappingInfo> getHttpMappings(Project p, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)p);
        List controllers = jamService.getJamClassElements(MnController.META, "io.micronaut.http.annotation.Controller", scope);
        return controllers.stream().flatMap(c -> MnHttpModel.getHttpMethods(jamService, c.getPsiElement())).collect(Collectors.toList());
    }

    @NotNull
    private static Stream<MnHttpMappingInfo> getHttpMethods(JamService jamService, @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MnHttpModel.$$$reportNull$$$0(11);
        }
        Stream<MnHttpMappingInfo> stream = jamService.getAnnotatedMembersList(psiClass, MnHttpMethodMapping.HTTP_METHOD_JAM_KEY, 10).stream().filter(mapping -> !(mapping instanceof MnErrorMethod)).map(mapping -> new MnHttpMappingInfo((MnHttpMethodMapping)mapping, psiClass));
        if (stream == null) {
            MnHttpModel.$$$reportNull$$$0(12);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/jam/http/MnHttpModel";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starsUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/jam/http/MnHttpModel";
                break;
            }
            case 1: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findControllers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findClients";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHttpMethods";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findControllers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findClients";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHttpMethodMappings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

