/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.jpa.frameworks.data.util.inspections.PartTreeInconsistencyUtils;
import com.intellij.jpa.frameworks.data.util.parser.PartTree;
import com.intellij.jpa.frameworks.data.util.parser.PartTreeParserContext;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.data.inspections.MicronautDataRepositoriesInspection;
import com.intellij.micronaut.data.parser.MicronautPartTreeParserContext;
import com.intellij.micronaut.data.parser.MicronautProjection;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;

public class MicronautDataRepositoryMethodReturnTypeInspection
extends MicronautDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, @NotNull UClass repositoryClass, @NotNull UMethod uMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(0);
        }
        if (repositoryClass == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(1);
        }
        if (uMethod == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(2);
        }
        if (module == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(3);
        }
        if (typePair == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(4);
        }
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass domainType = (PsiClass)typePair.first;
        if (domainType == null) {
            return;
        }
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null) {
            return;
        }
        PartTree.Subject subject = MicronautDataRepositoryMethodReturnTypeInspection.getSubject(psiMethod, domainType);
        if (subject.isDelete().booleanValue()) {
            if (!returnType.equals(PsiType.VOID)) {
                MicronautDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, MicronautBundle.message("micronaut.data.incorrect.method.return.type.void", new Object[0]));
            }
        } else if (subject.isCountProjection()) {
            PsiClassType numberType = JavaPsiFacade.getElementFactory((Project)psiMethod.getProject()).createTypeByFQClassName("java.lang.Number");
            if (!numberType.isAssignableFrom(returnType)) {
                MicronautDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, MicronautBundle.message("micronaut.data.incorrect.method.return.type", "java.lang.Number"));
            }
        } else if (subject.isExistsProjection()) {
            if (!returnType.equals(PsiType.BOOLEAN)) {
                MicronautDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, MicronautBundle.message("micronaut.data.incorrect.method.return.type.boolean", new Object[0]));
            }
        } else {
            MicronautProjection projection = MicronautPartTreeParserContext.extractProjection(subject);
            if (projection != null) {
                PsiType projectionType = projection.getType(domainType);
                if (projectionType != null && !MicronautDataRepositoryMethodReturnTypeInspection.isAssignableReturnType(projectionType, psiMethod.getReturnType())) {
                    MicronautDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, MicronautBundle.message("micronaut.data.incorrect.method.return.type", projectionType.getCanonicalText()));
                }
            } else if (!MicronautDataRepositoryMethodReturnTypeInspection.isAssignableReturnType((PsiType)PsiTypesUtil.getClassType((PsiClass)domainType), psiMethod.getReturnType())) {
                MicronautDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, MicronautBundle.message("micronaut.data.incorrect.method.return.type", domainType.getName()));
            }
        }
    }

    @NotNull
    private static PartTree.Subject getSubject(@NotNull PsiMethod psiMethod, PsiClass domainType) {
        if (psiMethod == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(5);
        }
        String name = psiMethod.getName();
        PartTree partTree = new PartTree(name, domainType, (PartTreeParserContext)MicronautPartTreeParserContext.create());
        PartTree.Subject subject = partTree.getSubject();
        if (subject == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(6);
        }
        return subject;
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @NotNull UMethod psiMethod, @InspectionMessage String message) {
        UTypeReferenceExpression returnTypeRef;
        if (holder == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(7);
        }
        if (psiMethod == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(8);
        }
        if ((returnTypeRef = MicronautDataRepositoryMethodReturnTypeInspection.getReturnTypeRef(psiMethod)) == null) {
            return;
        }
        PsiElement identifier = returnTypeRef.getSourcePsi();
        if (identifier == null) {
            return;
        }
        TextRange textRange = identifier.getTextRange();
        if (textRange == null || textRange.isEmpty()) {
            return;
        }
        holder.registerProblem(identifier, message, new LocalQuickFix[0]);
    }

    private static UTypeReferenceExpression getReturnTypeRef(@NotNull UMethod psiMethod) {
        PsiElement sourcePsi;
        if (psiMethod == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(9);
        }
        if ((sourcePsi = psiMethod.getSourcePsi()) == null) {
            return null;
        }
        for (PsiElement child : sourcePsi.getChildren()) {
            UTypeReferenceExpression expression = (UTypeReferenceExpression)UastContextKt.toUElement((PsiElement)child, UTypeReferenceExpression.class);
            if (expression == null) continue;
            return expression;
        }
        return null;
    }

    public static boolean isAssignableReturnType(@NotNull PsiType expectedType, @Nullable PsiType methodReturnType) {
        if (expectedType == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(10);
        }
        if (methodReturnType == null) {
            return false;
        }
        if (methodReturnType instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)methodReturnType) != null) {
            return true;
        }
        if (MicronautDataRepositoryMethodReturnTypeInspection.isAssignableTypeType(expectedType, methodReturnType)) {
            return true;
        }
        PsiType genericType = PsiUtil.extractIterableTypeParameter((PsiType)methodReturnType, (boolean)false);
        genericType = genericType != null ? genericType : MicronautDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(methodReturnType);
        PsiType psiType = genericType = genericType != null ? genericType : MicronautDataRepositoryMethodReturnTypeInspection.getSubstitutedReactiveStreamsParameters(methodReturnType);
        if (genericType != null) {
            if (MicronautDataRepositoryMethodReturnTypeInspection.isAssignableTypeType(expectedType, genericType)) {
                return true;
            }
            PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)genericType, (boolean)false);
            if (iterableTypeParameter != null && MicronautDataRepositoryMethodReturnTypeInspection.isAssignableTypeType(expectedType, iterableTypeParameter)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignableTypeType(@NotNull PsiType expectedType, @NotNull PsiType methodReturnType) {
        if (expectedType == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(11);
        }
        if (methodReturnType == null) {
            MicronautDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(12);
        }
        return methodReturnType.isAssignableFrom(expectedType);
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType) {
        return PartTreeInconsistencyUtils.getSubstitutedTypeParameters((PsiType)returnType, (String[])new String[]{"java.util.stream.Stream", "java.util.Optional", "io.micronaut.data.model.Page", "io.micronaut.data.model.Slice", "java.util.concurrent.Future", "java.util.concurrent.CompletableFuture"});
    }

    @Nullable
    public static PsiType getSubstitutedReactiveStreamsParameters(@Nullable PsiType returnType) {
        return null;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "MicronautDataRepositoryMethodReturnTypeInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/data/inspections/MicronautDataRepositoryMethodReturnTypeInspection";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/data/inspections/MicronautDataRepositoryMethodReturnTypeInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSubject";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeRef";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableReturnType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableTypeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

