/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.micronaut.data.parser.MicronautPartTreeParserContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MicronautDataUtil {
    private static final MicronautPartTreeParserContext PART_TREE_CONTEXT = MicronautPartTreeParserContext.create();

    public static boolean hasMicronautDataSupport(Project project) {
        return JavaLibraryUtils.hasLibraryClass((Project)project, (String)"io.micronaut.data.repository.GenericRepository");
    }

    public static boolean isQueryMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MicronautDataUtil.$$$reportNull$$$0(0);
        }
        return PART_TREE_CONTEXT.prefixTemplate().matcher(psiMethod.getName()).find() && !MicronautDataUtil.isDefaultMethod(psiMethod);
    }

    public static boolean isDefaultMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MicronautDataUtil.$$$reportNull$$$0(1);
        }
        return psiMethod.getModifierList().hasModifierProperty("default");
    }

    public static boolean isRepository(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MicronautDataUtil.$$$reportNull$$$0(2);
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"io.micronaut.data.repository.GenericRepository") || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"io.micronaut.data.annotation.Repository", (int)1);
    }

    @Nullable
    public static Pair<PsiClass, ? extends PsiType> substituteRepositoryTypes(@NotNull PsiClass repositoryClass) {
        Project project;
        PsiClassType psiClassType;
        PsiType psiType;
        if (repositoryClass == null) {
            MicronautDataUtil.$$$reportNull$$$0(3);
        }
        if ((psiType = PsiUtil.substituteTypeParameter((PsiType)(psiClassType = JavaPsiFacade.getInstance((Project)(project = repositoryClass.getProject())).getElementFactory().createType(repositoryClass)), (String)"io.micronaut.data.repository.GenericRepository", (int)0, (boolean)false)) instanceof PsiClassType) {
            PsiType idPsiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"io.micronaut.data.repository.GenericRepository", (int)1, (boolean)false);
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            return psiClass == null || idPsiType == null ? null : Pair.create((Object)psiClass, (Object)idPsiType);
        }
        return null;
    }

    @Nullable
    private static Pair<PsiClass, ? extends PsiType> substituteRepositoryDefinitionTypes(@NotNull PsiClass repositoryClass) {
        if (repositoryClass == null) {
            MicronautDataUtil.$$$reportNull$$$0(4);
        }
        return null;
    }

    @NotNull
    public static List<PsiMethod> getRepositoryMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MicronautDataUtil.$$$reportNull$$$0(5);
        }
        List<PsiMethod> list = Arrays.stream(psiClass.getMethods()).filter(method -> MicronautDataUtil.isQueryMethod(method)).collect(Collectors.toList());
        if (list == null) {
            MicronautDataUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static Set<String> getProperties(@NotNull PsiClass domainClass) {
        String qualifiedName;
        if (domainClass == null) {
            MicronautDataUtil.$$$reportNull$$$0(7);
        }
        if ((qualifiedName = domainClass.getQualifiedName()) == null || qualifiedName.startsWith("java.lang")) {
            return Collections.emptySet();
        }
        HashSet<String> all = new HashSet<String>();
        all.addAll(PropertyUtilBase.getAllProperties((PsiClass)domainClass, (boolean)false, (boolean)true).keySet());
        all.addAll(ContainerUtil.map2List((Object[])domainClass.getFields(), field -> PropertyUtilBase.suggestPropertyName((PsiField)field)));
        return all;
    }

    public static boolean hasQueryAnnotation(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MicronautDataUtil.$$$reportNull$$$0(8);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"io.micronaut.data.annotation.Query", (int)1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/data/MicronautDataUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/data/MicronautDataUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isQueryMethod";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRepository";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "substituteRepositoryTypes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteRepositoryDefinitionTypes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryMethods";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasQueryAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

