/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.yaml;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.microservices.config.MicroservicesConfigBundle;
import com.intellij.microservices.config.MicroservicesConfigUtils;
import com.intellij.microservices.config.yaml.ShowDuplicateKeysQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/micronaut/config/yaml/MnYamlInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.micronaut"})
public final class MnYamlInspection
extends LocalInspectionTool {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                if (!(file instanceof YAMLFile)) {
                    return null;
                }
                Project project = ((YAMLFile)file).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                if (!MicronautUtilsKt.hasMicronautLibrary(project)) break block7;
                PsiFile psiFile = ((YAMLFile)file).getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file.containingFile");
                if (MnConfigUtilsKt.isMicronautConfigFile(psiFile)) break block8;
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        List yamlDocuments = ((YAMLFile)file).getDocuments();
        for (YAMLDocument document : yamlDocuments) {
            MultiMap duplicates = new MultiMap();
            document.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(holder, duplicates){
                final /* synthetic */ ProblemsHolder $holder;
                final /* synthetic */ MultiMap $duplicates;

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    super.visitElement(element);
                    if (!(element instanceof YAMLKeyValue) || ((YAMLKeyValue)element).getKey() == null) {
                        return;
                    }
                    YAMLValue valueElement = ((YAMLKeyValue)element).getValue();
                    if (valueElement != null && !(valueElement instanceof YAMLScalar) && !(valueElement instanceof YAMLSequence)) {
                        return;
                    }
                    if (valueElement != null) {
                        if (valueElement instanceof YAMLScalar) {
                            MicroservicesConfigUtils.highlightValueReferences((PsiElement)((PsiElement)valueElement), (ProblemsHolder)this.$holder);
                        } else {
                            YAMLSequence sequence = (YAMLSequence)valueElement;
                            Iterator<E> iterator = sequence.getItems().iterator();
                            while (iterator.hasNext()) {
                                YAMLScalar itemValue;
                                YAMLSequenceItem item;
                                YAMLSequenceItem yAMLSequenceItem = item = (YAMLSequenceItem)iterator.next();
                                Intrinsics.checkNotNullExpressionValue((Object)yAMLSequenceItem, (String)"item");
                                YAMLValue yAMLValue = yAMLSequenceItem.getValue();
                                if (!(yAMLValue instanceof YAMLScalar)) {
                                    yAMLValue = null;
                                }
                                if ((YAMLScalar)yAMLValue == null) {
                                    continue;
                                }
                                MicroservicesConfigUtils.highlightValueReferences((PsiElement)((PsiElement)itemValue), (ProblemsHolder)this.$holder);
                            }
                        }
                    }
                    if (PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{YAMLSequenceItem.class}) != null) {
                        return;
                    }
                    MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)element);
                    if (configKey == null) {
                        return;
                    }
                    if (!configKey.isAccessType(Arrays.copyOf(MetaConfigKey.AccessType.MAP_GROUP, MetaConfigKey.AccessType.MAP_GROUP.length))) {
                        this.$duplicates.putValue((Object)configKey.getName(), (Object)element);
                    }
                }
                {
                    this.$holder = $captured_local_variable$0;
                    this.$duplicates = $captured_local_variable$1;
                }
            });
            Iterator iterator = duplicates.entrySet().iterator();
            while (iterator.hasNext()) {
                void configKey;
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                boolean bl = false;
                String string = (String)entry2.getKey();
                entry2 = entry;
                bl = false;
                Collection values = (Collection)entry2.getValue();
                if (values.size() == 1) continue;
                void v2 = configKey;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"configKey");
                if (MnParametrizedConfigKey.Companion.getParametrizedConfigKey((String)v2) != null) continue;
                ShowDuplicateKeysQuickFix showDuplicatesFix = new ShowDuplicateKeysQuickFix((String)configKey, values);
                Iterator iterator2 = values.iterator();
                while (iterator2.hasNext()) {
                    YAMLKeyValue keyValue;
                    YAMLKeyValue yAMLKeyValue = keyValue = (YAMLKeyValue)iterator2.next();
                    Intrinsics.checkNotNull((Object)yAMLKeyValue);
                    holder.registerProblem((PsiElement)yAMLKeyValue, MicroservicesConfigBundle.message((String)"config.duplicate.key", (Object[])new Object[]{configKey}), new LocalQuickFix[]{(LocalQuickFix)showDuplicatesFix});
                }
            }
        }
        return holder.getResultsArray();
    }
}

