/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.yaml;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.micronaut.config.MnConfigFileContributor;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.yaml.ConfigYamlAccessor;
import com.intellij.microservices.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/micronaut/config/yaml/MnYamlConfigFileContributor;", "Lcom/intellij/micronaut/config/MnConfigFileContributor;", "()V", "findKey", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "key", "", "getKeyVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "intellij.micronaut"})
public final class MnYamlConfigFileContributor
extends MnConfigFileContributor {
    @Override
    @Nullable
    public PsiElement findKey(@NotNull PsiFile psiFile, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(psiFile instanceof YAMLFile)) {
            return null;
        }
        for (YAMLDocument document : ((YAMLFile)psiFile).getDocuments()) {
            YAMLKeyValue existingKey = new ConfigYamlAccessor(document, (MetaConfigKeyManager)MnMetaConfigKeyManager.INSTANCE).findExistingKey(key);
            if (existingKey == null) continue;
            return (PsiElement)existingKey;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<LookupElement> getKeyVariants(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!(psiFile instanceof YAMLFile)) {
            return CollectionsKt.emptyList();
        }
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        for (YAMLDocument document : ((YAMLFile)psiFile).getDocuments()) {
            ConfigYamlAccessor accessor = new ConfigYamlAccessor(document, (MetaConfigKeyManager)MnMetaConfigKeyManager.INSTANCE);
            Iterator iterator = accessor.getAllKeys().iterator();
            while (iterator.hasNext()) {
                String qualifiedKey;
                YAMLKeyValue yamlKeyValue;
                YAMLKeyValue yAMLKeyValue = yamlKeyValue = (YAMLKeyValue)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"yamlKeyValue");
                YAMLValue yamlValue = yAMLKeyValue.getValue();
                if (!(yamlValue instanceof YAMLScalar) && !(yamlValue instanceof YAMLSequence)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue), (String)"ConfigYamlUtils.getQuali\u2026nfigKeyName(yamlKeyValue)");
                result.add(LookupElementBuilder.create((Object)yamlKeyValue, (String)qualifiedKey).withRenderer(ConfigYamlUtils.getYamlPlaceholderLookupRenderer()));
            }
        }
        return result;
    }

    public MnYamlConfigFileContributor() {
        YAMLFileType yAMLFileType = YAMLFileType.YML;
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFileType, (String)"YAMLFileType.YML");
        super((FileType)yAMLFileType);
    }
}

