/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.yaml;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.config.MnConfigFileAnnotator;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.microservices.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLHighlighter;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/micronaut/config/yaml/MnYamlAnnotator;", "Lcom/intellij/micronaut/config/MnConfigFileAnnotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateKey", "yamlKeyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "yamlKey", "getPlaceholderTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Companion", "intellij.micronaut"})
public final class MnYamlAnnotator
extends MnConfigFileAnnotator {
    private static final Key<Long> PARAMETER_MARK_KEY;
    public static final Companion Companion;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof YAMLKeyValue)) {
            return;
        }
        AnnotationSession annotationSession = holder.getCurrentAnnotationSession();
        Intrinsics.checkNotNullExpressionValue((Object)annotationSession, (String)"holder.currentAnnotationSession");
        PsiFile psiFile = annotationSession.getFile();
        if (!(psiFile instanceof YAMLFile)) {
            psiFile = null;
        }
        YAMLFile yAMLFile = (YAMLFile)psiFile;
        if (yAMLFile == null) {
            return;
        }
        YAMLFile file = yAMLFile;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        if (!MicronautUtilsKt.hasMicronautLibrary(project) || !MnConfigUtilsKt.isMicronautConfigFile((PsiFile)file)) {
            return;
        }
        PsiElement psiElement = ((YAMLKeyValue)element).getKey();
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.key ?: return");
        PsiElement yamlKey = psiElement;
        this.annotateKey((YAMLKeyValue)element, yamlKey, holder);
        YAMLValue yamlValue = ((YAMLKeyValue)element).getValue();
        if (yamlValue instanceof YAMLScalar) {
            this.annotateValue((PsiElement)yamlValue, holder);
        } else if (yamlValue instanceof YAMLSequence) {
            Iterator iterator = ((YAMLSequence)yamlValue).getItems().iterator();
            while (iterator.hasNext()) {
                YAMLScalar value;
                YAMLSequenceItem item;
                YAMLSequenceItem yAMLSequenceItem = item = (YAMLSequenceItem)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)yAMLSequenceItem, (String)"item");
                YAMLValue yAMLValue = yAMLSequenceItem.getValue();
                if (!(yAMLValue instanceof YAMLScalar)) {
                    yAMLValue = null;
                }
                if ((YAMLScalar)yAMLValue == null) {
                    continue;
                }
                this.annotateValue((PsiElement)value, holder);
            }
        }
    }

    @Override
    @NotNull
    protected TextAttributesKey getPlaceholderTextAttributesKey() {
        TextAttributesKey textAttributesKey = YAMLHighlighter.SCALAR_KEY;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"YAMLHighlighter.SCALAR_KEY");
        return textAttributesKey;
    }

    private final void annotateKey(YAMLKeyValue yamlKeyValue, PsiElement yamlKey, AnnotationHolder holder) {
        Long markStamp;
        Long l = markStamp = (Long)yamlKeyValue.getUserData(PARAMETER_MARK_KEY);
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)yamlKeyValue.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"PsiModificationTracker.S\u2026nce(yamlKeyValue.project)");
        long l2 = psiModificationTracker.getModificationCount();
        if (l != null && l == l2) {
            TextRange textRange = yamlKey.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"yamlKey.textRange");
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES");
            this.doAnnotateEnforced(holder, textRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
            return;
        }
        MetaConfigKey metaConfigKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)((PsiElement)yamlKeyValue));
        if (metaConfigKey == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"MetaConfigKeyReference.g\u2026y(yamlKeyValue) ?: return");
        MetaConfigKey configKey = metaConfigKey;
        String string = configKey.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configKey.name");
        MnParametrizedConfigKey mnParametrizedConfigKey = MnParametrizedConfigKey.Companion.getParametrizedConfigKey(string);
        if (mnParametrizedConfigKey == null) {
            return;
        }
        MnParametrizedConfigKey parametrizedConfigKey = mnParametrizedConfigKey;
        String string2 = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ConfigYamlUtils.getQuali\u2026nfigKeyName(yamlKeyValue)");
        String keyName = string2;
        TextRange textRange = parametrizedConfigKey.getParameterRange(keyName);
        if (textRange == null) {
            return;
        }
        TextRange parameterRange = textRange;
        String string3 = parameterRange.substring(keyName);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameterRange.substring(keyName)");
        String parameter = string3;
        YAMLKeyValue parent = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)yamlKeyValue), YAMLKeyValue.class);
        while (parent != null) {
            if (Intrinsics.areEqual((Object)parameter, (Object)parent.getKeyText())) {
                PsiModificationTracker psiModificationTracker2 = PsiModificationTracker.SERVICE.getInstance((Project)yamlKeyValue.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker2, (String)"PsiModificationTracker.S\u2026nce(yamlKeyValue.project)");
                parent.putUserData(PARAMETER_MARK_KEY, (Object)psiModificationTracker2.getModificationCount());
                return;
            }
            parent = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)parent), YAMLKeyValue.class);
        }
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"PARAMETER_MARK");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"PARAMETER_MARK\")");
        PARAMETER_MARK_KEY = key;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/micronaut/config/yaml/MnYamlAnnotator$Companion;", "", "()V", "PARAMETER_MARK_KEY", "Lcom/intellij/openapi/util/Key;", "", "intellij.micronaut"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

