/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.micronaut.config.properties.MnPropertyKeyMetaConfigKeyReference;
import com.intellij.microservices.config.ConfigKeyParts;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u000fB\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertyKeyMetaConfigKeyReference;", "Lcom/intellij/microservices/config/MetaConfigKeyReference;", "Lcom/intellij/psi/PsiElement;", "element", "property", "Lcom/intellij/lang/properties/psi/Property;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/lang/properties/psi/Property;)V", "calculateDefaultRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getReferenceDisplayText", "", "getVariants", "", "", "()[Ljava/lang/Object;", "Companion", "intellij.micronaut"})
public final class MnPropertyKeyMetaConfigKeyReference
extends MetaConfigKeyReference<PsiElement> {
    private final Property property;
    @NotNull
    private static final Key<String> PARAMETER_KEY;
    private static final TailType MAP_DOT_TAIL;
    public static final Companion Companion;

    @NotNull
    protected TextRange calculateDefaultRangeInElement() {
        TextRange defaultRange = super.calculateDefaultRangeInElement();
        MetaConfigKey configKey = this.getResolvedKey();
        if (configKey != null && !configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            PsiElement psiElement = this.myElement;
            Intrinsics.checkNotNull((Object)psiElement);
            String string = defaultRange.substring(psiElement.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultRange.substring(myElement!!.text)");
            String keyText = string;
            ConfigKeyParts parts = ConfigKeyParts.splitToParts((MetaConfigKey)configKey, (String)keyText, (boolean)false);
            if (parts != null) {
                TextRange textRange = TextRange.allOf((String)parts.getConfigKey());
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.allOf(parts.configKey)");
                return textRange;
            }
        }
        TextRange textRange = defaultRange;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"defaultRange");
        return textRange;
    }

    @NotNull
    public String getReferenceDisplayText() {
        String string = this.property.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.text");
        return string;
    }

    @NotNull
    public Object[] getVariants() {
        PropertiesFile propertiesFile = this.property.getPropertiesFile();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesFile, (String)"property.propertiesFile");
        Set set = ContainerUtil.map2Set((Collection)propertiesFile.getProperties(), (Function)getVariants.existingKeys.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ContainerUtil.map2Set(pr\u2026j: IProperty -> obj.key }");
        Set existingKeys2 = set;
        PsiElement psiElement = this.myElement;
        Intrinsics.checkNotNull((Object)psiElement);
        PropertiesCodeStyleSettings propertiesCodeStyleSettings = PropertiesCodeStyleSettings.getInstance((Project)psiElement.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)propertiesCodeStyleSettings, (String)"PropertiesCodeStyleSetti\u2026ance(myElement!!.project)");
        char delimiterChar = propertiesCodeStyleSettings.getDelimiter();
        CharTailType defaultDelimiterType2 = new CharTailType(delimiterChar, delimiterChar){
            final /* synthetic */ char $delimiterChar;

            public int processTail(@NotNull Editor editor, int tailOffset) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                int offset = super.processTail(editor, tailOffset);
                Project project = editor.getProject();
                Intrinsics.checkNotNull((Object)project);
                AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
                return offset;
            }
            {
                this.$delimiterChar = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        List configKeys = this.getConfigKeyManager().getAllMetaConfigKeys(this.getElement());
        List result = new ArrayList(configKeys.size());
        Iterator iterator = configKeys.iterator();
        while (iterator.hasNext()) {
            String name;
            MetaConfigKey configKey;
            MetaConfigKey metaConfigKey = configKey = (MetaConfigKey)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"configKey");
            Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey.getName(), (String)"configKey.name");
            if (existingKeys2.contains(name)) continue;
            MetaConfigKey.MetaConfigKeyPresentation metaConfigKeyPresentation = configKey.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)metaConfigKeyPresentation, (String)"configKey.presentation");
            LookupElementBuilder builder = metaConfigKeyPresentation.getLookupElement();
            TailType tailType = configKey.isAccessType(Arrays.copyOf(MetaConfigKey.AccessType.MAP_GROUP, MetaConfigKey.AccessType.MAP_GROUP.length)) ? MAP_DOT_TAIL : (TailType)defaultDelimiterType2;
            Ref lookupElementRef = new Ref();
            String string = configKey.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configKey.name");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)".*.", (boolean)false, (int)2, null)) {
                TailType delegateTailType = tailType;
                tailType = new TailType(delegateTailType, configKey, lookupElementRef){
                    final /* synthetic */ TailType $delegateTailType;
                    final /* synthetic */ MetaConfigKey $configKey;
                    final /* synthetic */ Ref $lookupElementRef;

                    public int processTail(@NotNull Editor editor, int tailOffset) {
                        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                        int delegateTail = this.$delegateTailType.processTail(editor, tailOffset);
                        Document document = editor.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                        Document document2 = document;
                        MetaConfigKey metaConfigKey = this.$configKey;
                        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"configKey");
                        String string = metaConfigKey.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configKey.name");
                        int i = StringsKt.indexOf$default((CharSequence)string, (String)".*.", (int)0, (boolean)false, (int)6, null);
                        MetaConfigKey metaConfigKey2 = this.$configKey;
                        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey2, (String)"configKey");
                        int start = tailOffset - metaConfigKey2.getName().length() + i + 1;
                        String string2 = (String)((LookupElement)this.$lookupElementRef.get()).getUserData(MnPropertyKeyMetaConfigKeyReference.Companion.getPARAMETER_KEY$intellij_micronaut());
                        if (string2 == null) {
                            string2 = "";
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lookupElementRef.get().g\u2026Data(PARAMETER_KEY) ?: \"\"");
                        String replacement = string2;
                        document2.replaceString(start, start + 1, (CharSequence)replacement);
                        CharSequence charSequence = replacement;
                        boolean bl = false;
                        if (charSequence.length() == 0) {
                            CaretModel caretModel = editor.getCaretModel();
                            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                            CaretModel model = caretModel;
                            model.moveToOffset(start);
                            return start;
                        }
                        return delegateTail + replacement.length() - 1;
                    }
                    {
                        this.$delegateTailType = $captured_local_variable$0;
                        this.$configKey = $captured_local_variable$1;
                        this.$lookupElementRef = $captured_local_variable$2;
                    }
                };
            }
            TailTypeDecorator tailTypeDecorator = TailTypeDecorator.withTail((LookupElement)((LookupElement)builder), (TailType)tailType);
            LookupElement lookupElement = configKey.getPresentation().tuneLookupElement((LookupElement)tailTypeDecorator);
            lookupElementRef.set((Object)lookupElement);
            LookupElement lookupElement2 = lookupElement;
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement2, (String)"lookupElement");
            result.add(lookupElement2);
        }
        Collection collection = result;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"ArrayUtil.EMPTY_OBJECT_ARRAY");
        return UtilKt.toArray((Collection)collection, (Object[])ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    public MnPropertyKeyMetaConfigKeyReference(@Nullable PsiElement element, @NotNull Property property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super((MetaConfigKeyManager)MnMetaConfigKeyManager.INSTANCE, element, property.getName());
        this.property = property;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"PARAMETER_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"PARAMETER_KEY\")");
        PARAMETER_KEY = key;
        MAP_DOT_TAIL = (TailType)new CharTailType('.'){

            public int processTail(@NotNull Editor editor, int tailOffset) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                int offset = super.processTail(editor, tailOffset);
                Project project = editor.getProject();
                Intrinsics.checkNotNull((Object)project);
                AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
                return offset;
            }
        };
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertyKeyMetaConfigKeyReference$Companion;", "", "()V", "MAP_DOT_TAIL", "Lcom/intellij/codeInsight/TailType;", "PARAMETER_KEY", "Lcom/intellij/openapi/util/Key;", "", "getPARAMETER_KEY$intellij_micronaut", "()Lcom/intellij/openapi/util/Key;", "intellij.micronaut"})
    public static final class Companion {
        @NotNull
        public final Key<String> getPARAMETER_KEY$intellij_micronaut() {
            return PARAMETER_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

