/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesSkipAutopopupInParameters;", "Lcom/intellij/codeInsight/completion/CompletionConfidence;", "()V", "shouldSkipAutopopup", "Lcom/intellij/util/ThreeState;", "contextElement", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "", "intellij.micronaut"})
public final class MnPropertiesSkipAutopopupInParameters
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                if (!(contextElement instanceof PropertyKeyImpl)) break block6;
                Project project = ((PropertyKeyImpl)contextElement).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"contextElement.project");
                if (MicronautUtilsKt.hasMicronautLibrary(project) && MnConfigUtilsKt.isMicronautConfigFile(psiFile)) break block7;
            }
            return ThreeState.UNSURE;
        }
        MetaConfigKey metaConfigKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)contextElement);
        if (metaConfigKey == null) {
            return ThreeState.UNSURE;
        }
        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"MetaConfigKeyReference.g\u2026 return ThreeState.UNSURE");
        MetaConfigKey configKey = metaConfigKey;
        String string = configKey.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configKey.name");
        MnParametrizedConfigKey mnParametrizedConfigKey = MnParametrizedConfigKey.Companion.getParametrizedConfigKey(string);
        if (mnParametrizedConfigKey == null) {
            return ThreeState.UNSURE;
        }
        MnParametrizedConfigKey parametrizedConfigKey = mnParametrizedConfigKey;
        int offsetInElement = offset - ((PropertyKeyImpl)contextElement).getStartOffset();
        String string2 = ((PropertyKeyImpl)contextElement).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contextElement.text");
        TextRange textRange = parametrizedConfigKey.getParameterRange(string2);
        if (textRange == null || (textRange = textRange.grown(1)) == null) {
            return ThreeState.UNSURE;
        }
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"parametrizedConfigKey.ge\u2026 return ThreeState.UNSURE");
        TextRange parameterRange = textRange;
        return parameterRange.contains(offsetInElement) ? ThreeState.YES : ThreeState.UNSURE;
    }
}

