/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.properties.MnPropertiesUtils;
import com.intellij.microservices.config.ConfigKeyParts;
import com.intellij.microservices.config.ConfigKeyPathReference;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.microservices.config.MicroservicesConfigUtils;
import com.intellij.microservices.config.properties.IndexAccessTextProcessor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "highlightIndexAccessExpressions", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "propertyKey", "Lcom/intellij/lang/properties/psi/impl/PropertyKeyImpl;", "configKey", "Lcom/intellij/microservices/config/MetaConfigKey;", "intellij.micronaut"})
public final class MnPropertiesInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PropertiesFile propertiesFile;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                if (!(file instanceof PropertiesFile)) {
                    return null;
                }
                propertiesFile = (PropertiesFile)file;
                Project project = propertiesFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"propertiesFile.project");
                if (!MicronautUtilsKt.hasMicronautLibrary(project)) break block10;
                PsiFile psiFile = propertiesFile.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"propertiesFile.containingFile");
                if (MnConfigUtilsKt.isMicronautConfigFile(psiFile)) break block11;
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        for (IProperty property : propertiesFile.getProperties()) {
            PropertyValueImpl valueElement;
            ConfigKeyParts keyParts;
            PropertyKeyImpl propertyKey;
            ProgressManager.checkCanceled();
            if (!(property instanceof PropertyImpl)) continue;
            if (MnPropertiesUtils.INSTANCE.getPropertyKey((PropertyImpl)property) == null) {
                continue;
            }
            MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)((PsiElement)propertyKey));
            if (configKey == null) continue;
            if (configKey.isAccessType(Arrays.copyOf(MetaConfigKey.AccessType.MAP_GROUP, MetaConfigKey.AccessType.MAP_GROUP.length)) && ((keyParts = ConfigKeyParts.splitToParts((MetaConfigKey)configKey, (String)propertyKey.getText(), (boolean)false)) == null || keyParts.getKeyIndex() == null)) {
                holder.registerProblem((PsiElement)propertyKey, MicronautBundle.message("micronaut.inspections.config.properties.missing.map.key", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                continue;
            }
            this.highlightIndexAccessExpressions(holder, propertyKey, configKey);
            if (MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)configKey)) {
                for (PsiReference reference : propertyKey.getReferences()) {
                    if (!(reference instanceof ConfigKeyPathReference) || ((ConfigKeyPathReference)reference).isSoft() || reference.resolve() != null) continue;
                    holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
                }
            }
            if (MnPropertiesUtils.INSTANCE.getPropertyValue((PropertyImpl)property) == null) {
                continue;
            }
            MicroservicesConfigUtils.highlightValueReferences((PsiElement)((PsiElement)valueElement), (ProblemsHolder)holder);
        }
        return holder.getResultsArray();
    }

    private final void highlightIndexAccessExpressions(ProblemsHolder holder, PropertyKeyImpl propertyKey, MetaConfigKey configKey) {
        new IndexAccessTextProcessor(holder, propertyKey, configKey, propertyKey.getText(), configKey){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ PropertyKeyImpl $propertyKey;
            final /* synthetic */ MetaConfigKey $configKey;

            protected void onMissingClosingBracket(int startIdx) {
                this.$holder.registerProblem((PsiElement)this.$propertyKey, MicronautBundle.message("micronaut.inspections.config.properties.missing.closing.bracket", new Object[0]), ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)1), new LocalQuickFix[0]);
            }

            protected void onMissingIndexValue(int startIdx) {
                this.$holder.registerProblem((PsiElement)this.$propertyKey, MicronautBundle.message("micronaut.inspections.config.properties.missing.index.value", new Object[0]), ProblemHighlightType.ERROR, TextRange.from((int)startIdx, (int)2), new LocalQuickFix[0]);
            }

            protected void onBracket(int startIdx) {
            }

            protected void onIndexValue(@NotNull TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
            }

            protected void onIndexValueNotInteger(@NotNull TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
                this.$holder.registerProblem((PsiElement)this.$propertyKey, MicronautBundle.message("micronaut.inspections.config.properties.non.integer.index", new Object[0]), ProblemHighlightType.ERROR, indexValueRange, new LocalQuickFix[0]);
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$propertyKey = $captured_local_variable$1;
                this.$configKey = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        }.process();
    }
}

