/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.microservices.config.ConfigKeyDocumentationProviderBase;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesDocumentationProvider;", "Lcom/intellij/microservices/config/ConfigKeyDocumentationProviderBase;", "()V", "getConfigKey", "", "configKeyElement", "Lcom/intellij/psi/PsiElement;", "getConfigManager", "Lcom/intellij/microservices/config/MetaConfigKeyManager;", "intellij.micronaut"})
public final class MnPropertiesDocumentationProvider
extends ConfigKeyDocumentationProviderBase {
    @NotNull
    protected MetaConfigKeyManager getConfigManager() {
        return MnMetaConfigKeyManager.INSTANCE;
    }

    @Nullable
    protected String getConfigKey(@NotNull PsiElement configKeyElement) {
        Intrinsics.checkNotNullParameter((Object)configKeyElement, (String)"configKeyElement");
        if (!(configKeyElement instanceof PropertyImpl)) {
            return null;
        }
        PsiFile psiFile = ((PropertyImpl)configKeyElement).getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"configKeyElement.containingFile");
        PsiFile file = psiFile;
        if (!(file instanceof PropertiesFile) || !MnConfigUtilsKt.isMicronautConfigFile(file)) {
            return null;
        }
        return ((PropertyImpl)configKeyElement).getKey();
    }
}

