/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.config.MnConfigFileAnnotator;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.micronaut.config.properties.MnPropertiesAnnotator$WhenMappings;
import com.intellij.microservices.config.ConfigKeyPathReference;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.microservices.config.properties.IndexAccessTextProcessor;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.ui.SimpleTextAttributes;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/micronaut/config/properties/MnPropertiesAnnotator;", "Lcom/intellij/micronaut/config/MnConfigFileAnnotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateIndexAccessExpressions", "text", "", "configKey", "Lcom/intellij/microservices/config/MetaConfigKey;", "elementStartOffset", "", "annotateKey", "Lcom/intellij/lang/properties/psi/impl/PropertyKeyImpl;", "annotateParameter", "getPlaceholderTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.micronaut"})
public final class MnPropertiesAnnotator
extends MnConfigFileAnnotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof PropertyValueImpl) && !(element instanceof PropertyKeyImpl)) {
            return;
        }
        AnnotationSession annotationSession = holder.getCurrentAnnotationSession();
        Intrinsics.checkNotNullExpressionValue((Object)annotationSession, (String)"holder.currentAnnotationSession");
        PsiFile psiFile = annotationSession.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"holder.currentAnnotationSession.file");
        PsiFile file = psiFile;
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        Project project = ((PropertiesFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"(file as PropertiesFile).project");
        if (!MicronautUtilsKt.hasMicronautLibrary(project) || !MnConfigUtilsKt.isMicronautConfigFile(file)) {
            return;
        }
        if (element instanceof PropertyValueImpl) {
            this.annotateValue(element, holder);
        } else if (element instanceof PropertyKeyImpl) {
            this.annotateKey((PropertyKeyImpl)element, holder);
        }
    }

    @Override
    @NotNull
    protected TextAttributesKey getPlaceholderTextAttributesKey() {
        TextAttributesKey textAttributesKey = PropertiesHighlighter.PROPERTY_KEY;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"PropertiesHighlighter.PROPERTY_KEY");
        return textAttributesKey;
    }

    private final void annotateKey(PropertyKeyImpl element, AnnotationHolder holder) {
        MetaConfigKey metaConfigKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)((PsiElement)element));
        if (metaConfigKey == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"MetaConfigKeyReference.g\u2026figKey(element) ?: return");
        MetaConfigKey configKey = metaConfigKey;
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        String keyText = string;
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
        int elementStartOffset = aSTNode.getStartOffset();
        this.annotateIndexAccessExpressions(holder, keyText, configKey, elementStartOffset);
        this.annotateParameter(holder, keyText, configKey, elementStartOffset);
        if (configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            return;
        }
        block5: for (PsiReference psiReference : element.getReferences()) {
            if (!(psiReference instanceof ConfigKeyPathReference)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((ConfigKeyPathReference)psiReference).getRangeInElement().shiftRight(elementStartOffset), (String)"psiReference.rangeInElem\u2026Right(elementStartOffset)");
            switch (MnPropertiesAnnotator$WhenMappings.$EnumSwitchMapping$0[((ConfigKeyPathReference)psiReference).getPathType().ordinal()]) {
                case 1: {
                    TextRange referenceRange;
                    TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.CONSTANT;
                    Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DefaultLanguageHighlighterColors.CONSTANT");
                    this.doAnnotate(holder, referenceRange, textAttributesKey);
                    continue block5;
                }
                case 2: {
                    TextRange referenceRange;
                    TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.INSTANCE_METHOD;
                    Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DefaultLanguageHighlighterColors.INSTANCE_METHOD");
                    this.doAnnotate(holder, referenceRange, textAttributesKey);
                    PsiElement resolve2 = psiReference.resolve();
                    if (!(resolve2 instanceof BeanPropertyElement)) continue block5;
                    PsiMethod psiMethod = ((BeanPropertyElement)resolve2).getMethod();
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"resolve.method");
                    if (!psiMethod.isDeprecated()) continue block5;
                    TextAttributesKey textAttributesKey2 = CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"CodeInsightColors.DEPRECATED_ATTRIBUTES");
                    this.doAnnotate(holder, referenceRange, textAttributesKey2);
                    continue block5;
                }
                case 3: {
                    TextRange referenceRange;
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES");
                    this.doAnnotateEnforced(holder, referenceRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
                    continue block5;
                }
            }
        }
        if (configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.MAP}) && configKey.getKeyItemHint() != MetaConfigKey.ItemHint.NONE) {
            int configKeyNameLength = -1;
            for (PsiReference reference : element.getReferences()) {
                if (!(reference instanceof MetaConfigKeyReference)) continue;
                TextRange textRange = reference.getRangeInElement();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"reference.getRangeInElement()");
                configKeyNameLength = textRange.getEndOffset();
                break;
            }
            boolean reference = configKeyNameLength != -1;
            int n = 0;
            if (_Assertions.ENABLED && !reference) {
                boolean bl = false;
                String string2 = keyText;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            int endOffset = keyText.length() - configKeyNameLength - (StringUtil.endsWithChar((CharSequence)keyText, (char)']') ? 2 : 1);
            TextRange textRange = TextRange.from((int)(configKeyNameLength + 1), (int)endOffset).shiftRight(elementStartOffset);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.from(configKey\u2026Right(elementStartOffset)");
            TextRange genericKeyRange = textRange;
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES");
            this.doAnnotateEnforced(holder, genericKeyRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
        }
    }

    private final void annotateParameter(AnnotationHolder holder, String text, MetaConfigKey configKey, int elementStartOffset) {
        String string = configKey.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configKey.name");
        MnParametrizedConfigKey mnParametrizedConfigKey = MnParametrizedConfigKey.Companion.getParametrizedConfigKey(string);
        if (mnParametrizedConfigKey == null) {
            return;
        }
        MnParametrizedConfigKey parametrizedConfigKey = mnParametrizedConfigKey;
        TextRange textRange = parametrizedConfigKey.getParameterRange(text);
        if (textRange == null || (textRange = textRange.shiftRight(elementStartOffset)) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"parametrizedConfigKey.ge\u2026entStartOffset) ?: return");
        TextRange parameterRange = textRange;
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES");
        this.doAnnotateEnforced(holder, parameterRange, simpleTextAttributes, "REGULAR_ITALIC_ATTRIBUTES");
    }

    private final void annotateIndexAccessExpressions(AnnotationHolder holder, String text, MetaConfigKey configKey, int elementStartOffset) {
        new IndexAccessTextProcessor(this, holder, elementStartOffset, text, configKey, text, configKey){
            final /* synthetic */ MnPropertiesAnnotator this$0;
            final /* synthetic */ AnnotationHolder $holder;
            final /* synthetic */ int $elementStartOffset;
            final /* synthetic */ String $text;
            final /* synthetic */ MetaConfigKey $configKey;

            protected void onMissingClosingBracket(int startIdx) {
            }

            protected void onMissingIndexValue(int startIdx) {
            }

            protected void onBracket(int startIdx) {
                TextRange textRange = TextRange.from((int)startIdx, (int)1).shiftRight(this.$elementStartOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.from(startIdx,\u2026Right(elementStartOffset)");
                TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.BRACKETS;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DefaultLanguageHighlighterColors.BRACKETS");
                MnPropertiesAnnotator.access$doAnnotate(this.this$0, this.$holder, textRange, textAttributesKey);
            }

            protected void onIndexValue(@NotNull TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
                TextRange textRange = indexValueRange.shiftRight(this.$elementStartOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"indexValueRange.shiftRight(elementStartOffset)");
                TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.NUMBER;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DefaultLanguageHighlighterColors.NUMBER");
                MnPropertiesAnnotator.access$doAnnotate(this.this$0, this.$holder, textRange, textAttributesKey);
            }

            protected void onIndexValueNotInteger(@NotNull TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
                this.$elementStartOffset = $captured_local_variable$2;
                this.$text = $captured_local_variable$3;
                this.$configKey = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6);
            }
        }.process();
    }

    public static final /* synthetic */ void access$doAnnotate(MnPropertiesAnnotator $this, AnnotationHolder holder, TextRange range, TextAttributesKey key) {
        $this.doAnnotate(holder, range, key);
    }
}

