/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.json.psi.JsonFile;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.config.MnConfigKeyNameBinder;
import com.intellij.micronaut.config.MnConfigurationMetadataParser;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J>\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0006\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u0012H\u0002J>\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0006\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u0012H\u0002J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/micronaut/config/MnMetaConfigKeyManager;", "Lcom/intellij/microservices/config/MetaConfigKeyManager;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "collectKeys", "", "Lcom/intellij/microservices/config/MetaConfigKey;", "module", "Lcom/intellij/openapi/module/Module;", "inLibraries", "", "findConfigFilesInMetaInf", "T", "Lcom/intellij/psi/PsiFile;", "filename", "", "psiFileType", "Ljava/lang/Class;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getAllMetaConfigKeys", "getConfigFilesScope", "getConfigKeyNameBinder", "Lcom/intellij/microservices/config/MetaConfigKeyManager$ConfigKeyNameBinder;", "getConfigKeysForFile", "parser", "Lcom/intellij/micronaut/config/MnConfigurationMetadataParser;", "path", "intellij.micronaut"})
public final class MnMetaConfigKeyManager
extends MetaConfigKeyManager {
    private static final Logger LOG;
    public static final MnMetaConfigKeyManager INSTANCE;

    @NotNull
    public List<MetaConfigKey> getAllMetaConfigKeys(@Nullable Module module) {
        if (module == null || !MicronautUtilsKt.hasMicronautLibrary(module)) {
            return CollectionsKt.emptyList();
        }
        List libraryKeys2 = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<List<? extends MetaConfigKey>>(module){
            final /* synthetic */ Module $module;

            @Nullable
            public final CachedValueProvider.Result<List<MetaConfigKey>> compute() {
                return CachedValueProvider.Result.create((Object)MnMetaConfigKeyManager.access$collectKeys(MnMetaConfigKeyManager.INSTANCE, this.$module, true), (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.$module.getProject())});
            }
            {
                this.$module = module;
            }
        });
        List sourceKeys2 = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<List<? extends MetaConfigKey>>(module){
            final /* synthetic */ Module $module;

            @Nullable
            public final CachedValueProvider.Result<List<MetaConfigKey>> compute() {
                return CachedValueProvider.Result.create((Object)MnMetaConfigKeyManager.access$collectKeys(MnMetaConfigKeyManager.INSTANCE, this.$module, false), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)this.$module.getProject())});
            }
            {
                this.$module = module;
            }
        });
        List list = ContainerUtil.concat((List)libraryKeys2, (List)sourceKeys2);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.concat(libraryKeys, sourceKeys)");
        return list;
    }

    @NotNull
    public MetaConfigKeyManager.ConfigKeyNameBinder getConfigKeyNameBinder(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return MnConfigKeyNameBinder.INSTANCE;
    }

    private final List<MetaConfigKey> collectKeys(Module module, boolean inLibraries) {
        List<JsonFile> metaInfConfigFiles = this.findConfigFilesInMetaInf(module, inLibraries, "spring-configuration-metadata.json", JsonFile.class);
        List allKeys = new ArrayList();
        for (JsonFile configMetadataFile : metaInfConfigFiles) {
            MnConfigurationMetadataParser mnConfigurationMetadataParser = new MnConfigurationMetadataParser(configMetadataFile);
            VirtualFile virtualFile = configMetadataFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"configMetadataFile.virtualFile");
            String string = virtualFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configMetadataFile.virtualFile.path");
            List<MetaConfigKey> keys = this.getConfigKeysForFile(module, mnConfigurationMetadataParser, string);
            allKeys.addAll((Collection)keys);
        }
        if (!inLibraries) {
            Set modules = new LinkedHashSet();
            ModuleUtilCore.getDependencies((Module)module, (Set)modules);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            boolean unitTestMode = application.isUnitTestMode();
            for (Module dependentModule : modules) {
                File localJsonFile;
                if (MnMetaConfigKeyManager.access$findLocalMetadataJsonFile$s1443072373(module, "spring-configuration-metadata.json", unitTestMode) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)localJsonFile, (String)"findLocalMetadataJsonFil\u2026unitTestMode) ?: continue");
                MnConfigurationMetadataParser mnConfigurationMetadataParser = new MnConfigurationMetadataParser(module, localJsonFile);
                String string = localJsonFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localJsonFile.path");
                List<MetaConfigKey> keys = this.getConfigKeysForFile(module, mnConfigurationMetadataParser, string);
                allKeys.addAll((Collection)keys);
            }
        }
        return allKeys;
    }

    private final <T extends PsiFile> List<T> findConfigFilesInMetaInf(Module module, boolean inLibraries, String filename, Class<T> psiFileType) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.moduleRuntimeScope(module, true)");
        GlobalSearchScope moduleScope = globalSearchScope;
        GlobalSearchScope globalSearchScope2 = ProjectScope.getLibrariesScope((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"ProjectScope.getLibrariesScope(module.project)");
        GlobalSearchScope librariesScope = globalSearchScope2;
        if (inLibraries) {
            GlobalSearchScope globalSearchScope3 = moduleScope.intersectWith(librariesScope);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"moduleScope.intersectWith(librariesScope)");
            moduleScope = globalSearchScope3;
        } else {
            GlobalSearchScope globalSearchScope4 = moduleScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)librariesScope));
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope4, (String)"moduleScope.intersectWit\u2026notScope(librariesScope))");
            moduleScope = globalSearchScope4;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        return this.findConfigFilesInMetaInf(project, moduleScope, filename, psiFileType);
    }

    private final <T extends PsiFile> List<T> findConfigFilesInMetaInf(Project project, GlobalSearchScope scope, String filename, Class<T> psiFileType) {
        List list;
        Object[] configFiles;
        GlobalSearchScope globalSearchScope = this.getConfigFilesScope(project, scope);
        if (globalSearchScope == null) {
            return CollectionsKt.emptyList();
        }
        GlobalSearchScope searchScope = globalSearchScope;
        Object[] objectArray = FilenameIndex.getFilesByName((Project)project, (String)filename, (GlobalSearchScope)searchScope);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"FilenameIndex.getFilesBy\u2026t, filename, searchScope)");
        Object[] objectArray2 = configFiles = objectArray;
        boolean bl = false;
        if (objectArray2.length == 0) {
            list = CollectionsKt.emptyList();
        } else {
            List list2 = ContainerUtil.findAll((Object[])configFiles, psiFileType);
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ContainerUtil.findAll(configFiles, psiFileType)");
        }
        return list;
    }

    private final GlobalSearchScope getConfigFilesScope(Project project, GlobalSearchScope scope) {
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage("META-INF");
        if (psiPackage == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiPackage, (String)"JavaPsiFacade.getInstanc\u2026META-INF\") ?: return null");
        PsiPackage metaInfPackage = psiPackage;
        GlobalSearchScope globalSearchScope = PackageScope.packageScope((PsiPackage)metaInfPackage, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"PackageScope.packageScope(metaInfPackage, false)");
        GlobalSearchScope packageScope = globalSearchScope;
        return scope.intersectWith(packageScope);
    }

    private final List<MetaConfigKey> getConfigKeysForFile(Module module, MnConfigurationMetadataParser parser2, String path) {
        List keys = new ArrayList();
        Set names = new HashSet();
        try {
            parser2.processKeys(module, (Processor<? super MetaConfigKey>)((Processor)new Processor<MetaConfigKey>(names, keys){
                final /* synthetic */ Set $names;
                final /* synthetic */ List $keys;

                public final boolean process(MetaConfigKey it) {
                    ProgressManager.checkCanceled();
                    MetaConfigKey metaConfigKey = it;
                    Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"it");
                    String string = metaConfigKey.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    if (this.$names.add(string)) {
                        this.$keys.add(it);
                    }
                    return true;
                }
                {
                    this.$names = set;
                    this.$keys = list;
                }
            }));
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (IndexNotReadyException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            LOG.warn("Error parsing " + path, e);
        }
        return keys;
    }

    private MnMetaConfigKeyManager() {
    }

    static {
        MnMetaConfigKeyManager mnMetaConfigKeyManager;
        INSTANCE = mnMetaConfigKeyManager = new MnMetaConfigKeyManager();
        Logger logger = Logger.getInstance(MnMetaConfigKeyManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(MnMet\u2026igKeyManager::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ List access$collectKeys(MnMetaConfigKeyManager $this, Module module, boolean inLibraries) {
        return $this.collectKeys(module, inLibraries);
    }

    public static final /* synthetic */ File access$findLocalMetadataJsonFile$s1443072373(Module p0, String p1, boolean p2) {
        return MetaConfigKeyManager.findLocalMetadataJsonFile((Module)p0, (String)p1, (boolean)p2);
    }
}

