/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.ide.IconProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/micronaut/config/MnIconProvider;", "Lcom/intellij/ide/IconProvider;", "()V", "getIcon", "Ljavax/swing/Icon;", "element", "Lcom/intellij/psi/PsiElement;", "flags", "", "intellij.micronaut"})
public final class MnIconProvider
extends IconProvider {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        if (!MicronautUtilsKt.hasMicronautLibrary(project)) {
            return null;
        }
        if (element instanceof PropertyImpl) {
            PsiFile psiFile = ((PropertyImpl)element).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
            if (MnConfigUtilsKt.isMicronautConfigFile(psiFile)) {
                ASTNode aSTNode = ((PropertyImpl)element).getKeyNode();
                if (aSTNode == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.keyNode ?: return null");
                ASTNode keyNode = aSTNode;
                MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)keyNode.getPsi());
                if (configKey != null) {
                    MetaConfigKey.MetaConfigKeyPresentation metaConfigKeyPresentation = configKey.getPresentation();
                    Intrinsics.checkNotNullExpressionValue((Object)metaConfigKeyPresentation, (String)"configKey.presentation");
                    return metaConfigKeyPresentation.getIcon();
                }
            }
            return null;
        }
        if (element instanceof PropertiesFile) {
            PsiFile psiFile = ((PropertiesFile)element).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"(element as PropertiesFile).containingFile");
            return MnConfigUtilsKt.getMicronautConfigFileIcon(psiFile);
        }
        return null;
    }
}

