/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.intellij.json.psi.JsonFile;
import com.intellij.micronaut.config.Caching;
import com.intellij.micronaut.config.MnConfigKeyDeclarationPsiElement;
import com.intellij.micronaut.config.MnMetaConfigKey;
import com.intellij.microservices.config.ConfigKeyDocumentationProviderBase;
import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.RelaxedNames;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ8\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012H\u0002J8\u0010\u0017\u001a\u0018\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001dH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0006H\u0002J\u001e\u0010\"\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00062\u000e\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001f0$R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/micronaut/config/MnConfigurationMetadataParser;", "", "jsonPsiFile", "Lcom/intellij/json/psi/JsonFile;", "(Lcom/intellij/json/psi/JsonFile;)V", "localModule", "Lcom/intellij/openapi/module/Module;", "localJsonFile", "Ljava/io/File;", "(Lcom/intellij/openapi/module/Module;Ljava/io/File;)V", "caching", "Lcom/intellij/micronaut/config/Caching;", "libraryName", "", "getDeclaration", "Lkotlin/Triple;", "Lcom/intellij/microservices/config/MetaConfigKey$DeclarationResolveResult;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/PsiType;", "entry", "Lcom/google/gson/JsonObject;", "configKeyName", "type", "getFallbackDeclaration", "unresolvedSourceTypeClass", "", "openReader", "Lcom/google/gson/stream/JsonReader;", "pathRef", "Lcom/intellij/openapi/util/Ref;", "parseProperty", "Lcom/intellij/microservices/config/MetaConfigKey;", "property", "module", "processKeys", "processor", "Lcom/intellij/util/Processor;", "Companion", "intellij.micronaut"})
public final class MnConfigurationMetadataParser {
    private final JsonFile jsonPsiFile;
    private final File localJsonFile;
    private final String libraryName;
    private Caching caching;
    private static final String PROPERTIES = "properties";
    private static final String NAME = "name";
    private static final String SOURCE_TYPE = "sourceType";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final Logger LOG;
    private static final Pair<PsiType, MetaConfigKey.AccessType> DUMMY_TYPE;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean processKeys(@NotNull Module module, @NotNull Processor<? super MetaConfigKey> processor2) {
        boolean bl;
        block13: {
            Closeable closeable;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(processor2, (String)"processor");
            Ref ref = Ref.create();
            Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"Ref.create()");
            Ref path = ref;
            try {
                JsonObject jsonObject;
                closeable = (Closeable)this.openReader((Ref<String>)path);
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    JsonElement parse;
                    JsonReader reader = (JsonReader)closeable;
                    boolean bl4 = false;
                    reader.setLenient(true);
                    JsonElement jsonElement = parse = JsonParser.parseReader((JsonReader)reader);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"parse");
                    if (!jsonElement.isJsonObject()) {
                        boolean bl5 = true;
                        return bl5;
                    }
                    jsonObject = parse.getAsJsonObject();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                closeable = jsonObject;
            }
            catch (ProcessCanceledException ignored) {
                return true;
            }
            catch (Throwable e) {
                LOG.info("Error parsing Spring Boot metadata JSON from " + (String)path.get(), e);
                return true;
            }
            Closeable rootObject = closeable;
            JsonElement jsonElement = rootObject.get(PROPERTIES);
            if (jsonElement == null) {
                return true;
            }
            JsonElement propertiesElement = jsonElement;
            JsonArray jsonArray = propertiesElement.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"propertiesElement.asJsonArray");
            Sequence $this$all$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)jsonArray)), (Function1)((Function1)new Function1<JsonElement, MetaConfigKey>(this, module){
                final /* synthetic */ MnConfigurationMetadataParser this$0;
                final /* synthetic */ Module $module;

                @Nullable
                public final MetaConfigKey invoke(JsonElement it) {
                    JsonElement jsonElement = it;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"it");
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"it.asJsonObject");
                    return MnConfigurationMetadataParser.access$parseProperty(this.this$0, jsonObject, this.$module);
                }
                {
                    this.this$0 = mnConfigurationMetadataParser;
                    this.$module = module;
                    super(1);
                }
            }));
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                MetaConfigKey it = (MetaConfigKey)element$iv;
                boolean bl6 = false;
                if (processor2.process((Object)it)) continue;
                bl = false;
                break block13;
            }
            bl = true;
        }
        return bl;
    }

    private final JsonReader openReader(Ref<String> pathRef) {
        JsonReader jsonReader;
        if (this.jsonPsiFile != null) {
            VirtualFile file;
            VirtualFile virtualFile = file = this.jsonPsiFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
            pathRef.set((Object)virtualFile.getPath());
            String string = VfsUtilCore.loadText((VirtualFile)file);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.loadText(file)");
            String content = string;
            jsonReader = new JsonReader((Reader)new CharSequenceReader((CharSequence)content));
        } else {
            boolean bl = this.localJsonFile != null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            File file = this.localJsonFile;
            Intrinsics.checkNotNull((Object)file);
            pathRef.set((Object)file.getPath());
            jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(this.localJsonFile)), StandardCharsets.UTF_8));
        }
        return jsonReader;
    }

    private final MetaConfigKey parseProperty(JsonObject property, Module module) {
        String configKeyName = MnConfigurationMetadataParser.Companion.getStringLiteral(property, NAME);
        CharSequence charSequence = configKeyName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        String string = MnConfigurationMetadataParser.Companion.getStringLiteral(property, TYPE);
        bl2 = false;
        boolean bl3 = false;
        String it = string;
        boolean bl4 = false;
        String typeLiteral = Intrinsics.areEqual((Object)"java.util.Properties", (Object)it) ? "java.util.Map<java.lang.String,java.lang.String>" : it;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Pair typeWithAccess = MnConfigurationMetadataParser.Companion.getPsiTypeToAccessType(project, typeLiteral);
        PsiType type = Intrinsics.areEqual((Object)((PsiType)typeWithAccess.getFirst()), (Object)((PsiType)DUMMY_TYPE.getFirst())) ? null : (PsiType)typeWithAccess.getFirst();
        Triple<MetaConfigKey.DeclarationResolveResult, PsiElement, PsiType> triple = this.getDeclaration(property, configKeyName, type);
        if (triple == null) {
            return null;
        }
        Triple<MetaConfigKey.DeclarationResolveResult, PsiElement, PsiType> declaration = triple;
        if (declaration.getThird() != null) {
            type = (PsiType)declaration.getThird();
        }
        ((PsiElement)declaration.getSecond()).putUserData(ConfigKeyDocumentationProviderBase.CONFIG_KEY_DECLARATION_MODULE, (Object)module);
        return new MnMetaConfigKey((PsiElement)declaration.getSecond(), (MetaConfigKey.DeclarationResolveResult)declaration.getFirst(), configKeyName, MnConfigurationMetadataParser.Companion.getDescription(property), MnConfigurationMetadataParser.Companion.getValueAsString(property, DEFAULT_VALUE), type, (MetaConfigKey.AccessType)typeWithAccess.getSecond());
    }

    private final Triple<MetaConfigKey.DeclarationResolveResult, PsiElement, PsiType> getDeclaration(JsonObject entry, String configKeyName, PsiType type) {
        String sourceTypeText = MnConfigurationMetadataParser.Companion.getStringLiteral(entry, SOURCE_TYPE);
        CharSequence charSequence = sourceTypeText;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return this.getFallbackDeclaration(configKeyName, type, false);
        }
        PsiClass psiClass = this.caching.getCachedClasses().get(sourceTypeText);
        if (psiClass == null) {
            return this.getFallbackDeclaration(configKeyName, type, true);
        }
        PsiClass sourceTypeClass = psiClass;
        Pair target = MnConfigurationMetadataParser.Companion.findPropertyNavigationTarget(sourceTypeClass, configKeyName);
        return new Triple((Object)MetaConfigKey.DeclarationResolveResult.PROPERTY, (Object)new MnConfigKeyDeclarationPsiElement(this.libraryName, (PsiElement)sourceTypeClass, (PsiElement)target.getFirst(), configKeyName, sourceTypeText, type), target.getSecond());
    }

    private final Triple<MetaConfigKey.DeclarationResolveResult, PsiElement, PsiType> getFallbackDeclaration(String configKeyName, PsiType type, boolean unresolvedSourceTypeClass) {
        if (this.jsonPsiFile == null) {
            return null;
        }
        MetaConfigKey.DeclarationResolveResult declarationResolveResult = unresolvedSourceTypeClass ? MetaConfigKey.DeclarationResolveResult.JSON_UNRESOLVED_SOURCE_TYPE : MetaConfigKey.DeclarationResolveResult.JSON;
        MnConfigKeyDeclarationPsiElement declarationElement = new MnConfigKeyDeclarationPsiElement(this.libraryName, (PsiElement)this.jsonPsiFile, (PsiElement)this.jsonPsiFile, configKeyName, configKeyName, type);
        return new Triple((Object)declarationResolveResult, (Object)declarationElement, null);
    }

    public MnConfigurationMetadataParser(@NotNull JsonFile jsonPsiFile) {
        Intrinsics.checkNotNullParameter((Object)jsonPsiFile, (String)"jsonPsiFile");
        this.jsonPsiFile = jsonPsiFile;
        this.localJsonFile = null;
        this.libraryName = MnConfigurationMetadataParser.Companion.getLibraryOrContainingJarName(jsonPsiFile);
        GlobalSearchScope globalSearchScope = jsonPsiFile.getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"jsonPsiFile.resolveScope");
        this.caching = new Caching(globalSearchScope);
    }

    public MnConfigurationMetadataParser(@NotNull Module localModule, @NotNull File localJsonFile) {
        Intrinsics.checkNotNullParameter((Object)localModule, (String)"localModule");
        Intrinsics.checkNotNullParameter((Object)localJsonFile, (String)"localJsonFile");
        this.jsonPsiFile = null;
        this.localJsonFile = localJsonFile;
        String string = localModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"localModule.name");
        this.libraryName = string;
        GlobalSearchScope globalSearchScope = localModule.getModuleRuntimeScope(false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"localModule.getModuleRuntimeScope(false)");
        this.caching = new Caching(globalSearchScope);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MnConfigurationMetadataParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(MnCon\u2026tadataParser::class.java)");
        LOG = logger;
        DUMMY_TYPE = new Pair((Object)PsiType.NULL, (Object)MetaConfigKey.AccessType.NORMAL);
    }

    public static final /* synthetic */ MetaConfigKey access$parseProperty(MnConfigurationMetadataParser $this, JsonObject property, Module module) {
        return $this.parseProperty(property, module);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0004H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/micronaut/config/MnConfigurationMetadataParser$Companion;", "", "()V", "DEFAULT_VALUE", "", "DESCRIPTION", "DUMMY_TYPE", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiType;", "Lcom/intellij/microservices/config/MetaConfigKey$AccessType;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NAME", "PROPERTIES", "SOURCE_TYPE", "TYPE", "findPropertyNavigationTarget", "Lcom/intellij/psi/PsiElement;", "sourceTypeClass", "Lcom/intellij/psi/PsiClass;", "configKeyName", "getDescription", "Lcom/intellij/microservices/config/MetaConfigKey$DescriptionText;", "property", "Lcom/google/gson/JsonObject;", "getLibraryOrContainingJarName", "jsonFile", "Lcom/intellij/json/psi/JsonFile;", "getPsiTypeToAccessType", "project", "Lcom/intellij/openapi/project/Project;", "type", "getStringLiteral", "jsonObject", "propertyName", "getValueAsString", "intellij.micronaut"})
    public static final class Companion {
        private final String getLibraryOrContainingJarName(JsonFile jsonFile) {
            OrderEntry libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)jsonFile.getVirtualFile(), (Project)jsonFile.getProject());
            if (libraryEntry instanceof LibraryOrderEntry) {
                String libraryName = ((LibraryOrderEntry)libraryEntry).getLibraryName();
                if (libraryName != null) {
                    return libraryName;
                }
                VirtualFile jarRoot = JarFileSystem.getInstance().getLocalByEntry(jsonFile.getVirtualFile());
                if (jarRoot != null) {
                    String string = jarRoot.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarRoot.name");
                    return string;
                }
            }
            return "<unknown>";
        }

        private final MetaConfigKey.DescriptionText getDescription(JsonObject property) {
            MetaConfigKey.DescriptionText descriptionText;
            String descriptionText2;
            String string = descriptionText2 = this.getStringLiteral(property, MnConfigurationMetadataParser.DESCRIPTION);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                descriptionText = new MetaConfigKey.DescriptionText(it);
            } else {
                MetaConfigKey.DescriptionText descriptionText3 = MetaConfigKey.DescriptionText.NONE;
                descriptionText = descriptionText3;
                Intrinsics.checkNotNullExpressionValue((Object)descriptionText3, (String)"DescriptionText.NONE");
            }
            return descriptionText;
        }

        private final String getStringLiteral(JsonObject jsonObject, String propertyName) {
            JsonElement jsonElement = jsonObject.get(propertyName);
            return jsonElement != null ? jsonElement.getAsString() : null;
        }

        private final String getValueAsString(JsonObject jsonObject, String propertyName) {
            JsonElement jsonElement = jsonObject.get(propertyName);
            if (jsonElement == null) {
                return null;
            }
            JsonElement propertyElement = jsonElement;
            if (propertyElement.isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = propertyElement.getAsJsonPrimitive();
                Intrinsics.checkNotNullExpressionValue((Object)jsonPrimitive, (String)"propertyElement.asJsonPrimitive");
                return jsonPrimitive.getAsString();
            }
            if (!propertyElement.isJsonArray()) {
                return null;
            }
            JsonArray array = propertyElement.getAsJsonArray();
            List valueList = (List)new SmartList();
            Iterator iterator = array.iterator();
            while (iterator.hasNext()) {
                JsonElement jsonValue;
                JsonElement jsonElement2 = jsonValue = (JsonElement)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"jsonValue");
                if (!jsonElement2.isJsonPrimitive()) continue;
                JsonPrimitive jsonPrimitive = jsonValue.getAsJsonPrimitive();
                Intrinsics.checkNotNullExpressionValue((Object)jsonPrimitive, (String)"jsonValue.asJsonPrimitive");
                String string = jsonPrimitive.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonValue.asJsonPrimitive.asString");
                valueList.add(string);
            }
            return StringUtil.join((Collection)valueList, (String)", ");
        }

        private final Pair<PsiElement, PsiType> findPropertyNavigationTarget(PsiClass sourceTypeClass, String configKeyName) {
            String propertyName = RelaxedNames.dashedPropertyNameToCamelCase((String)configKeyName);
            PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)false);
            if (setter != null) {
                PsiParameter psiParameter = setter.getParameterList().getParameter(0);
                Intrinsics.checkNotNull((Object)psiParameter);
                Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"setter.parameterList.getParameter(0)!!");
                PsiType psiType = psiParameter.getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"setter.parameterList.getParameter(0)!!.type");
                PsiType type = psiType;
                return new Pair((Object)setter, (Object)type);
            }
            PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)false);
            return getter != null ? new Pair((Object)getter, (Object)getter.getReturnType()) : new Pair((Object)sourceTypeClass, null);
        }

        private final Pair<PsiType, MetaConfigKey.AccessType> getPsiTypeToAccessType(Project project, String type) {
            if (type == null) {
                return DUMMY_TYPE;
            }
            Map cachedTypes2 = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<Map<String, ? extends Pair<? extends PsiType, ? extends MetaConfigKey.AccessType>>>(project){
                final /* synthetic */ Project $project;

                @Nullable
                public final CachedValueProvider.Result<Map<String, Pair<PsiType, MetaConfigKey.AccessType>>> compute() {
                    JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.$project);
                    Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"JavaPsiFacade.getInstance(project)");
                    PsiElementFactory psiElementFactory = javaPsiFacade.getElementFactory();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"JavaPsiFacade.getInstance(project).elementFactory");
                    PsiElementFactory elementFactory = psiElementFactory;
                    ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap((Function)((Function)new Function<String, Pair<? extends PsiType, ? extends MetaConfigKey.AccessType>>(elementFactory){
                        final /* synthetic */ PsiElementFactory $elementFactory;

                        public final Pair<PsiType, MetaConfigKey.AccessType> fun(@NotNull String key) {
                            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                            try {
                                PsiType psiType = this.$elementFactory.createTypeFromText(StringsKt.replace$default((String)key, (char)'$', (char)'.', (boolean)false, (int)4, null), null);
                                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"elementFactory.createTyp\u2026.replace('$', '.'), null)");
                                PsiType psiType2 = psiType;
                                return new Pair((Object)psiType2, (Object)MetaConfigKey.AccessType.forPsiType((PsiType)psiType2));
                            }
                            catch (IncorrectOperationException e) {
                                return MnConfigurationMetadataParser.access$getDUMMY_TYPE$cp();
                            }
                        }
                        {
                            this.$elementFactory = psiElementFactory;
                        }
                    }));
                    Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026YPE\n          }\n        }");
                    Map factoryMap2 = concurrentMap;
                    return CachedValueProvider.Result.create((Object)factoryMap2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                {
                    this.$project = project;
                }
            });
            Pair pair = (Pair)cachedTypes2.get(type);
            if (pair == null) {
                String string = "cached types factory map got null value";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return pair;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

