/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.config.MnConfigFileContributor;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.microservices.config.ConfigPlaceholderReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import icons.MicronautIcons;
import java.util.function.BiFunction;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"createMicronautPlaceholderReferences", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "getMicronautConfigFileIcon", "Ljavax/swing/Icon;", "file", "Lcom/intellij/psi/PsiFile;", "isMicronautConfigFile", "", "isMicronautConfigFileName", "fileName", "", "intellij.micronaut"})
public final class MnConfigUtilsKt {
    public static final boolean isMicronautConfigFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MnConfigUtilsKt.getMicronautConfigFileIcon(file) != null;
    }

    @Nullable
    public static final Icon getMicronautConfigFileIcon(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.getVirtualFile() == null) {
            return null;
        }
        Module fileModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
        if (fileModule == null || !MicronautUtilsKt.hasMicronautLibrary(fileModule)) {
            return null;
        }
        return (Icon)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), (CachedValueProvider)((CachedValueProvider)new CachedValueProvider<Icon>(file){
            final /* synthetic */ PsiFile $file;

            @Nullable
            public final CachedValueProvider.Result<Icon> compute() {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.$file));
                if (module != null && !module.isDisposed()) {
                    VirtualFile virtualFile = this.$file.getVirtualFile();
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                    Object[] objectArray = moduleRootManager.getSourceRoots();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleRootManager.getInstance(module).sourceRoots");
                    Object[] sourceRoots = objectArray;
                    for (MnConfigFileContributor contributor : (MnConfigFileContributor[])MnConfigFileContributor.Companion.getEP_NAME().getExtensions()) {
                        if (!Intrinsics.areEqual((Object)contributor.getFileType(), (Object)this.$file.getFileType())) continue;
                        VirtualFile virtualFile2 = virtualFile;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"virtualFile");
                        String string = virtualFile2.getNameWithoutExtension();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.nameWithoutExtension");
                        if (!MnConfigUtilsKt.isMicronautConfigFileName(string) || !ArraysKt.contains((Object[])sourceRoots, (Object)virtualFile.getParent())) continue;
                        return CachedValueProvider.Result.create((Object)MicronautIcons.MicronautLogo, (Object[])new Object[]{this.$file, ProjectRootManager.getInstance((Project)this.$file.getProject())});
                    }
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{this.$file, ProjectRootManager.getInstance((Project)this.$file.getProject())});
            }
            {
                this.$file = psiFile;
            }
        }));
    }

    public static final boolean isMicronautConfigFileName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return Intrinsics.areEqual((Object)fileName, (Object)"application") || StringsKt.startsWith$default((String)fileName, (String)"application-", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final PsiReference[] createMicronautPlaceholderReferences(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiReference[] psiReferenceArray = ConfigPlaceholderReference.createPlaceholderReferences((PsiElement)element, (BiFunction)createMicronautPlaceholderReferences.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"ConfigPlaceholderReferen\u2026ties()\n      .build()\n  }");
        return psiReferenceArray;
    }
}

