/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.micronaut.MicronautUtilsKt;
import com.intellij.micronaut.config.MnConfigFileContributor;
import com.intellij.micronaut.config.MnConfigKeyDeclarationPsiElement;
import com.intellij.microservices.config.RelaxedNames;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/micronaut/config/MnConfigMethodUsageSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "()V", "processQuery", "", "parameters", "consumer", "Lcom/intellij/util/Processor;", "MnConfigKeyDeclarationSearchTarget", "intellij.micronaut"})
public final class MnConfigMethodUsageSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    /*
     * WARNING - void declaration
     */
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters parameters, @NotNull Processor<? super PsiReference> consumer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"parameters.project");
        if (!MicronautUtilsKt.hasMicronautLibrary(project)) {
            return;
        }
        PsiMethod psiMethod = parameters.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"parameters.method");
        PsiMethod psiMethod2 = psiMethod;
        if (!psiMethod2.hasModifier(JvmModifier.PUBLIC) || psiMethod2.hasModifier(JvmModifier.STATIC) || psiMethod2.hasModifier(JvmModifier.ABSTRACT)) {
            return;
        }
        String string = PropertyUtilBase.getPropertyName((PsiMethod)psiMethod2);
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PropertyUtilBase.getProp\u2026Name(psiMethod) ?: return");
        String name = string;
        String uniformName = RelaxedNames.camelCaseToHyphen((String)name);
        List list = MnConfigFileContributor.Companion.getEP_NAME().getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"MnConfigFileContributor.EP_NAME.extensionList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FileType fileType = ((MnConfigFileContributor)receiver).getFileType();
            collection.add(fileType);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FileType[] fileTypeArray = thisCollection$iv.toArray(new FileType[0]);
        if (fileTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        FileType[] fileTypes = fileTypeArray;
        SearchScope searchScope = PsiSearchScopeUtil.restrictScopeTo((SearchScope)parameters.getEffectiveSearchScope(), (FileType[])Arrays.copyOf(fileTypes, fileTypes.length));
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"PsiSearchScopeUtil.restr\u2026eSearchScope, *fileTypes)");
        SearchScope searchScope2 = searchScope;
        MnConfigKeyDeclarationSearchTarget searchTarget = new MnConfigKeyDeclarationSearchTarget((PsiElement)psiMethod2);
        parameters.getOptimizer().searchWord(uniformName, searchScope2, (short)255, true, (PsiElement)searchTarget);
        if (Intrinsics.areEqual((Object)name, (Object)uniformName) ^ true) {
            parameters.getOptimizer().searchWord(name, searchScope2, (short)255, true, (PsiElement)searchTarget);
        }
    }

    public MnConfigMethodUsageSearcher() {
        super(true);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/micronaut/config/MnConfigMethodUsageSearcher$MnConfigKeyDeclarationSearchTarget;", "Lcom/intellij/psi/impl/FakePsiElement;", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "getParent", "isEquivalentTo", "", "another", "intellij.micronaut"})
    private static final class MnConfigKeyDeclarationSearchTarget
    extends FakePsiElement {
        private final PsiElement psiElement;

        @NotNull
        public PsiElement getParent() {
            return this.psiElement;
        }

        public boolean isEquivalentTo(@Nullable PsiElement another) {
            if (this == another) {
                return true;
            }
            if (another instanceof MnConfigKeyDeclarationPsiElement) {
                return this.psiElement.getManager().areElementsEquivalent(this.psiElement, ((MnConfigKeyDeclarationPsiElement)another).getNavigationElement());
            }
            if (another instanceof BeanPropertyElement) {
                return this.psiElement.getManager().areElementsEquivalent(this.psiElement, (PsiElement)((BeanPropertyElement)another).getMethod());
            }
            return false;
        }

        public MnConfigKeyDeclarationSearchTarget(@NotNull PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            this.psiElement = psiElement;
        }
    }
}

