/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\fH\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000fJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/intellij/micronaut/config/MnConfigFileContributor;", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "(Lcom/intellij/openapi/fileTypes/FileType;)V", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "collectConfigDirectories", "", "module", "Lcom/intellij/openapi/module/Module;", "configDirectories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "testScope", "", "visitedModules", "findConfigFiles", "", "includeTests", "findKey", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "key", "", "getConfigFileSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getKeyVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Companion", "intellij.micronaut"})
public abstract class MnConfigFileContributor {
    @NotNull
    private final FileType fileType;
    @NotNull
    private static final ExtensionPointName<MnConfigFileContributor> EP_NAME;
    public static final Companion Companion;

    @Nullable
    public abstract PsiElement findKey(@NotNull PsiFile var1, @NotNull String var2);

    @NotNull
    public abstract Collection<LookupElement> getKeyVariants(@NotNull PsiFile var1);

    @NotNull
    public final List<VirtualFile> findConfigFiles(@NotNull Module module, boolean includeTests) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        GlobalSearchScope globalSearchScope = this.getConfigFileSearchScope(module, includeTests);
        if (globalSearchScope == null) {
            return CollectionsKt.emptyList();
        }
        GlobalSearchScope configFileSearchScope = globalSearchScope;
        SmartList result = new SmartList();
        CommonProcessors.CollectProcessor<VirtualFile> processor2 = new CommonProcessors.CollectProcessor<VirtualFile>(result, (Collection)result){
            final /* synthetic */ SmartList $result;

            protected boolean accept(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ProgressManager.checkCanceled();
                String string = file.getNameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.nameWithoutExtension");
                return MnConfigUtilsKt.isMicronautConfigFileName(string);
            }
            {
                this.$result = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        FileTypeIndex.processFiles((FileType)this.fileType, (Processor)((Processor)processor2), (GlobalSearchScope)configFileSearchScope);
        return (List)result;
    }

    private final GlobalSearchScope getConfigFileSearchScope(Module module, boolean testScope) {
        GlobalSearchScope globalSearchScope;
        if (module.isDisposed()) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return module.getModuleScope(testScope);
        }
        LinkedHashSet configDirectories = new LinkedHashSet();
        MnConfigFileContributor.collectConfigDirectories$default(this, module, configDirectories, testScope, null, 8, null);
        if (configDirectories.isEmpty()) {
            globalSearchScope = null;
        } else {
            VirtualFile[] virtualFileArray = configDirectories.toArray(VirtualFile.EMPTY_ARRAY);
            globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)module.getProject(), (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        }
        return globalSearchScope;
    }

    private final void collectConfigDirectories(Module module, Set<VirtualFile> configDirectories, boolean testScope, Set<? super Module> visitedModules) {
        if (visitedModules.contains(module)) {
            return;
        }
        visitedModules.add((Module)module);
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List list = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)(testScope ? JavaResourceRootType.TEST_RESOURCE : JavaResourceRootType.RESOURCE));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"moduleRootManager.getSou\u2026esourceRootType.RESOURCE)");
        configDirectories.addAll(list);
        Module[] moduleArray = moduleRootManager.getDependencies(testScope);
        int n = moduleArray.length;
        for (int i = 0; i < n; ++i) {
            Module dependentModule;
            Module module2 = dependentModule = moduleArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"dependentModule");
            this.collectConfigDirectories(module2, configDirectories, testScope, visitedModules);
        }
    }

    static /* synthetic */ void collectConfigDirectories$default(MnConfigFileContributor mnConfigFileContributor, Module module, Set set, boolean bl, Set set2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectConfigDirectories");
        }
        if ((n & 8) != 0) {
            set2 = new HashSet();
        }
        mnConfigFileContributor.collectConfigDirectories(module, set, bl, set2);
    }

    @NotNull
    public final FileType getFileType() {
        return this.fileType;
    }

    public MnConfigFileContributor(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        this.fileType = fileType;
    }

    static {
        Companion = new Companion(null);
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.micronaut.configFileContributor");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026t.configFileContributor\")");
        EP_NAME = extensionPointName;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/micronaut/config/MnConfigFileContributor$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/micronaut/config/MnConfigFileContributor;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.micronaut"})
    public static final class Companion {
        @NotNull
        public final ExtensionPointName<MnConfigFileContributor> getEP_NAME() {
            return EP_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

