/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.micronaut.config.MnConfigPlaceholderReference;
import com.intellij.microservices.config.hints.HintReferenceBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b \u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0004J \u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\b\u0010\u0012\u001a\u00020\rH$\u00a8\u0006\u0014"}, d2={"Lcom/intellij/micronaut/config/MnConfigFileAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotateValue", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "doAnnotate", "range", "Lcom/intellij/openapi/util/TextRange;", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "doAnnotateEnforced", "Lcom/intellij/ui/SimpleTextAttributes;", "debugMessage", "", "getPlaceholderTextAttributesKey", "Companion", "intellij.micronaut"})
public abstract class MnConfigFileAnnotator
implements Annotator {
    private static final boolean DEBUG_MODE;
    public static final Companion Companion;

    @NotNull
    protected abstract TextAttributesKey getPlaceholderTextAttributesKey();

    protected final void annotateValue(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
        int elementOffset = aSTNode.getStartOffset();
        Object[] references = element.getReferences();
        boolean highlightOnlyPlaceholders = ContainerUtil.findInstance((Object[])references, MnConfigPlaceholderReference.class) != null;
        Set annotatedOffsets = (Set)new SmartHashSet();
        for (Object reference : references) {
            TextRange highlightTextRange;
            TextAttributesKey key = null;
            if (highlightOnlyPlaceholders) {
                if (reference instanceof MnConfigPlaceholderReference) {
                    key = this.getPlaceholderTextAttributesKey();
                }
            } else if (reference instanceof JavaClassReference || reference instanceof PsiPackageReference) {
                if (reference.resolve() != null) {
                    key = DefaultLanguageHighlighterColors.CLASS_REFERENCE;
                }
            } else if (reference instanceof HintReferenceBase) {
                key = ((HintReferenceBase)reference).getTextAttributesKey();
            }
            if (key == null) continue;
            Object object = reference;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reference");
            Intrinsics.checkNotNullExpressionValue((Object)object.getRangeInElement().shiftRight(elementOffset), (String)"reference.rangeInElement.shiftRight(elementOffset)");
            if (!annotatedOffsets.add(highlightTextRange.getStartOffset())) continue;
            this.doAnnotate(holder, highlightTextRange, key);
        }
    }

    protected final void doAnnotate(@NotNull AnnotationHolder holder, @NotNull TextRange range, @NotNull TextAttributesKey key) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (range.isEmpty()) {
            return;
        }
        AnnotationBuilder annotationBuilder = DEBUG_MODE ? holder.newAnnotation(HighlightSeverity.INFORMATION, key.getExternalName()) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION);
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"if (DEBUG_MODE) {\n      \u2026rity.INFORMATION)\n      }");
        AnnotationBuilder annotationBuilder2 = annotationBuilder;
        annotationBuilder2.range(range).textAttributes(key).create();
    }

    protected final void doAnnotateEnforced(@NotNull AnnotationHolder holder, @NotNull TextRange range, @NotNull SimpleTextAttributes key, @NotNull String debugMessage) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)debugMessage, (String)"debugMessage");
        if (range.isEmpty()) {
            return;
        }
        String message = DEBUG_MODE ? debugMessage : null;
        AnnotationBuilder annotationBuilder = message != null ? holder.newAnnotation(HighlightSeverity.INFORMATION, message) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION);
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"if (message != null) {\n \u2026rity.INFORMATION)\n      }");
        AnnotationBuilder annotationBuilder2 = annotationBuilder;
        annotationBuilder2.range(range).enforcedTextAttributes(key.toTextAttributes()).create();
    }

    static {
        Companion = new Companion(null);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        DEBUG_MODE = application.isUnitTestMode();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/intellij/micronaut/config/MnConfigFileAnnotator$Companion;", "", "()V", "DEBUG_MODE", "", "getDEBUG_MODE$annotations", "intellij.micronaut"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getDEBUG_MODE$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

