/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.router;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.angularjs.codeInsight.router.AngularRouterStateLoader;
import org.angularjs.codeInsight.router.AngularUiRouterGraphBuilder;
import org.angularjs.codeInsight.router.RootTemplate;
import org.angularjs.codeInsight.router.Template;
import org.angularjs.codeInsight.router.UiRouterState;
import org.angularjs.codeInsight.router.UiView;
import org.angularjs.index.AngularAppIndex;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularModuleIndex;
import org.angularjs.index.AngularNamedItemDefinition;
import org.angularjs.index.AngularUiRouterStatesIndex;
import org.angularjs.index.AngularUiRouterViewsIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularUiRouterDiagramBuilder {
    private final List<UiRouterState> myStates;
    private final Map<VirtualFile, Template> myTemplatesMap;
    private final Map<VirtualFile, RootTemplate> myRootTemplates;
    @NotNull
    private final Project myProject;
    private final SmartPointerManager mySmartPointerManager;
    private final Map<PsiFile, Set<VirtualFile>> myModuleRecursiveDependencies;
    private Map<VirtualFile, Map<String, UiRouterState>> myRootTemplates2States;
    private Map<VirtualFile, Map<String, UiRouterState>> myDefiningFiles2States;

    public AngularUiRouterDiagramBuilder(@NotNull Project project) {
        if (project == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myStates = new ArrayList<UiRouterState>();
        this.myTemplatesMap = new HashMap<VirtualFile, Template>();
        this.myRootTemplates = new HashMap<VirtualFile, RootTemplate>();
        this.mySmartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        this.myModuleRecursiveDependencies = new HashMap<PsiFile, Set<VirtualFile>>();
    }

    public void build() {
        this.addStatesFromIndex();
        this.addGenericStates();
        this.getRootPages();
        this.groupStates();
    }

    private void addStatesFromIndex() {
        Collection<String> stateIds = AngularIndexUtil.getAllKeys(AngularUiRouterStatesIndex.KEY, this.myProject);
        for (String id : stateIds) {
            if (id.startsWith(".")) continue;
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            AngularIndexUtil.multiResolve(this.myProject, AngularUiRouterStatesIndex.KEY, id, (Processor<? super JSImplicitElement>)processor);
            for (JSImplicitElement element : processor.getResults()) {
                JSExpression[] arguments;
                JSReferenceExpression methodExpression;
                JSCallExpression call;
                UiRouterState state = new UiRouterState(id, element.getContainingFile().getVirtualFile());
                if (!element.getContainingFile().getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) && PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class) != null) {
                    this.createRootTemplatesForEmbedded(element.getContainingFile());
                }
                if ((call = AngularUiRouterDiagramBuilder.findWrappingCallExpression(element)) != null && (methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)call.getMethodExpression(), JSReferenceExpression.class)) != null && methodExpression.getQualifier() != null && "state".equals(methodExpression.getReferenceName()) && (arguments = call.getArguments()).length > 0 && PsiTreeUtil.isAncestor((PsiElement)arguments[0], (PsiElement)element.getNavigationElement(), (boolean)false)) {
                    JSProperty name;
                    JSObjectLiteralExpression object;
                    state.setPointer((SmartPsiElementPointer<PsiElement>)this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)arguments[0]));
                    if (arguments.length > 1 && arguments[1] instanceof JSObjectLiteralExpression) {
                        object = (JSObjectLiteralExpression)arguments[1];
                        this.fillStateParameters(state, object);
                    } else if (arguments[0] instanceof JSObjectLiteralExpression && (name = (object = (JSObjectLiteralExpression)arguments[0]).findProperty("name")) != null && PsiTreeUtil.isAncestor((PsiElement)name, (PsiElement)element.getNavigationElement(), (boolean)false)) {
                        this.fillStateParameters(state, object);
                    }
                }
                this.myStates.add(state);
            }
        }
    }

    private void addGenericStates() {
        List<JSProperty> freeStates = new AngularRouterStateLoader(this.myProject).loadFreelyDefinedStates();
        for (JSProperty property : freeStates) {
            if (property.getValue() == null || !(property.getParent() instanceof JSObjectLiteralExpression)) continue;
            String name = StringUtil.unquoteString((String)property.getValue().getText());
            UiRouterState uiState = new UiRouterState(name, property.getContainingFile().getViewProvider().getVirtualFile());
            uiState.setGeneric(true);
            uiState.setPointer((SmartPsiElementPointer<PsiElement>)this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)property));
            this.fillStateParameters(uiState, (JSObjectLiteralExpression)property.getParent());
            if (this.myStates.contains(uiState)) continue;
            this.myStates.add(uiState);
        }
    }

    @Nullable
    public static JSCallExpression findWrappingCallExpression(JSImplicitElement element) {
        if (element.getNavigationElement() instanceof JSCallExpression) {
            return (JSCallExpression)element.getNavigationElement();
        }
        return (JSCallExpression)ObjectUtils.tryCast((Object)JSStubBasedPsiTreeUtil.getContextOfType((PsiElement)element, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.CALL_EXPRESSION}), (boolean)true), JSCallExpression.class);
    }

    private void groupStates() {
        this.myRootTemplates2States = new HashMap<VirtualFile, Map<String, UiRouterState>>();
        HashSet<UiRouterState> statesUsedInRoots = new HashSet<UiRouterState>();
        for (Map.Entry<VirtualFile, RootTemplate> entry : this.myRootTemplates.entrySet()) {
            Set<VirtualFile> modulesFiles = entry.getValue().getModulesFiles();
            for (UiRouterState state : this.myStates) {
                PsiElement element = entry.getValue().getPointer().getElement();
                if (!modulesFiles.contains(state.getFile()) && (element == null || !element.getContainingFile().getVirtualFile().equals(state.getFile()))) continue;
                AngularUiRouterDiagramBuilder.putState2map(entry.getKey(), state, this.myRootTemplates2States);
                statesUsedInRoots.add(state);
            }
        }
        this.myDefiningFiles2States = new HashMap<VirtualFile, Map<String, UiRouterState>>();
        for (UiRouterState state : this.myStates) {
            if (statesUsedInRoots.contains(state)) continue;
            if (state.isGeneric()) {
                AngularUiRouterDiagramBuilder.putState2map(this.myRootTemplates.keySet().iterator().next(), state, this.myRootTemplates2States);
                continue;
            }
            AngularUiRouterDiagramBuilder.putState2map(state.getFile(), state, this.myDefiningFiles2States);
        }
    }

    private static void putState2map(@NotNull VirtualFile rootFile, @NotNull UiRouterState state, @NotNull Map<VirtualFile, Map<String, UiRouterState>> rootMap) {
        Map<String, UiRouterState> map;
        if (rootFile == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(1);
        }
        if (state == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(2);
        }
        if (rootMap == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(3);
        }
        if ((map = rootMap.get(rootFile)) == null) {
            map = new HashMap<String, UiRouterState>();
            rootMap.put(rootFile, map);
        }
        if (map.containsKey(state.getName())) {
            UiRouterState existing = map.get(state.getName());
            if (!Comparing.equal(existing.getPointer(), state.getPointer()) && state.getPointer() != null) {
                existing.addDuplicateDefinition(state);
            }
        } else {
            map.put(state.getName(), state);
        }
    }

    private void getRootPages() {
        ArrayList roots = new ArrayList();
        HashMap files = new HashMap();
        FileBasedIndex instance = FileBasedIndex.getInstance();
        Collection keys = instance.getAllKeys(AngularAppIndex.ANGULAR_APP_INDEX, this.myProject);
        if (keys.isEmpty()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
        for (String string : keys) {
            instance.processValues(AngularAppIndex.ANGULAR_APP_INDEX, (Object)string, null, (file, value) -> {
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile != null) {
                    files.put(psiFile, value);
                }
                return true;
            }, projectScope);
        }
        for (Map.Entry entry : files.entrySet()) {
            PsiFile file2 = (PsiFile)entry.getKey();
            String relativeUrl = this.findPossibleRelativeUrl(roots, file2.getVirtualFile());
            if (relativeUrl == null) continue;
            Template template = AngularUiRouterDiagramBuilder.readTemplateFromFile(this.myProject, relativeUrl, (PsiElement)file2);
            String mainModule = ((AngularNamedItemDefinition)entry.getValue()).getName();
            Set<VirtualFile> moduleFiles = this.getModuleFiles(file2, mainModule);
            RootTemplate rootTemplate = new RootTemplate((SmartPsiElementPointer<PsiElement>)this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)file2), relativeUrl, template, moduleFiles);
            this.myRootTemplates.put(file2.getVirtualFile(), rootTemplate);
        }
    }

    private void createRootTemplatesForEmbedded(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(4);
        }
        Template template = AngularUiRouterDiagramBuilder.readTemplateFromFile(this.myProject, "/", (PsiElement)containingFile);
        RootTemplate rootTemplate = new RootTemplate((SmartPsiElementPointer<PsiElement>)this.mySmartPointerManager.createSmartPsiElementPointer((PsiElement)containingFile), "/", template, Collections.singleton(containingFile.getVirtualFile()));
        this.myRootTemplates.put(containingFile.getVirtualFile(), rootTemplate);
    }

    @NotNull
    private Set<VirtualFile> getModuleFiles(PsiFile file, String mainModule) {
        Set<VirtualFile> moduleFiles = this.myModuleRecursiveDependencies.get(file);
        if (moduleFiles != null) {
            Set<VirtualFile> set = moduleFiles;
            if (set == null) {
                AngularUiRouterDiagramBuilder.$$$reportNull$$$0(5);
            }
            return set;
        }
        NonCyclicQueue<String> modulesQueue = new NonCyclicQueue<String>();
        NonCyclicQueue<VirtualFile> filesQueue = new NonCyclicQueue<VirtualFile>(){

            @Override
            protected boolean check(VirtualFile file) {
                return !NodeModuleUtil.isFromNodeModules((Project)AngularUiRouterDiagramBuilder.this.myProject, (VirtualFile)file);
            }
        };
        if (!StringUtil.isEmptyOrSpaces((String)mainModule)) {
            modulesQueue.add(mainModule);
        }
        filesQueue.add(file.getVirtualFile());
        while (!modulesQueue.isEmpty()) {
            String moduleName = (String)modulesQueue.removeNext();
            this.moduleDependenciesStep(moduleName, (NonCyclicQueue<? super VirtualFile>)filesQueue, modulesQueue);
        }
        while (!filesQueue.isEmpty()) {
            VirtualFile moduleFile = (VirtualFile)filesQueue.removeNext();
            this.filesDependenciesStep(moduleFile, (NonCyclicQueue<? super VirtualFile>)filesQueue);
        }
        Set<VirtualFile> processed = filesQueue.getProcessed();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
        processed = new HashSet(ContainerUtil.filter(processed, file1 -> file1.getFileType() instanceof LanguageFileType && ((LanguageFileType)file1.getFileType()).getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) && projectScope.contains(file1)));
        this.myModuleRecursiveDependencies.put(file, processed);
        Set<VirtualFile> set = processed;
        if (set == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(6);
        }
        return set;
    }

    private void moduleDependenciesStep(String mainModule, NonCyclicQueue<? super VirtualFile> filesQueue, NonCyclicQueue<? super String> modulesQueue) {
        JSImplicitElement element;
        this.addContainingFile(filesQueue, mainModule);
        if (!StringUtil.isEmptyOrSpaces((String)mainModule) && (element = AngularIndexUtil.resolve(this.myProject, AngularModuleIndex.KEY, mainModule)) != null) {
            JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSCallExpression.class);
            if (callExpression == null) {
                return;
            }
            List<String> dependenciesInModuleDeclaration = AngularModuleIndex.findDependenciesInModuleDeclaration(callExpression);
            if (dependenciesInModuleDeclaration != null) {
                for (String module : dependenciesInModuleDeclaration) {
                    modulesQueue.add(module);
                    this.addContainingFile(filesQueue, module);
                }
            }
        }
    }

    private void addContainingFile(@NotNull NonCyclicQueue<? super VirtualFile> filesQueue, @NotNull String module) {
        if (filesQueue == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(7);
        }
        if (module == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(8);
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        AngularIndexUtil.multiResolve(this.myProject, AngularModuleIndex.KEY, module, (Processor<? super JSImplicitElement>)collectProcessor);
        if (collectProcessor.getResults().size() != 1) {
            return;
        }
        for (JSImplicitElement element : collectProcessor.getResults()) {
            VirtualFile file;
            if (element == null || element.getNavigationElement() == null || element.getNavigationElement().getContainingFile() == null || !NodeModuleUtil.isFromNodeModules((Project)this.myProject, (VirtualFile)(file = element.getNavigationElement().getContainingFile().getVirtualFile()))) continue;
            return;
        }
        JSImplicitElement element = (JSImplicitElement)collectProcessor.getResults().iterator().next();
        if (element != null && element.getNavigationElement() != null && element.getNavigationElement().getContainingFile() != null) {
            filesQueue.add((VirtualFile)element.getNavigationElement().getContainingFile().getVirtualFile());
        }
    }

    private void filesDependenciesStep(VirtualFile file, NonCyclicQueue<? super VirtualFile> filesQueue) {
        VirtualFile[] includedFiles = FileIncludeManager.getManager((Project)this.myProject).getIncludedFiles(file, true, true);
        filesQueue.addAll(Arrays.asList(includedFiles));
    }

    private String findPossibleRelativeUrl(@NotNull List<? extends VirtualFile> roots, @NotNull VirtualFile file) {
        VirtualFile ancestor;
        if (roots == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(9);
        }
        if (file == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(10);
        }
        VirtualFile contentRoot = null;
        for (VirtualFile virtualFile : roots) {
            if (!virtualFile.equals(VfsUtilCore.getCommonAncestor((VirtualFile)virtualFile, (VirtualFile)file))) continue;
            contentRoot = virtualFile;
            break;
        }
        VirtualFile virtualFile = ancestor = contentRoot == null ? this.myProject.getBaseDir() : contentRoot;
        if (ancestor == null) {
            return null;
        }
        String string = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)ancestor);
        return string == null ? null : AngularUiRouterGraphBuilder.normalizeTemplateUrl(string);
    }

    private void fillStateParameters(UiRouterState state, JSObjectLiteralExpression object) {
        JSProperty abstractProperty;
        JSProperty[] viewsProperties;
        JSExpression value;
        JSProperty views;
        PsiElement templateDefinition;
        String parentKey;
        String url = AngularUiRouterDiagramBuilder.getPropertyValueIfExists(object, "url");
        if (url != null) {
            state.setUrl(StringUtil.unquoteString((String)url));
        }
        if ((parentKey = AngularUiRouterDiagramBuilder.getPropertyValueIfExists(object, "parent")) != null) {
            state.setParentName(parentKey);
        }
        String templateUrl = AngularUiRouterDiagramBuilder.getPropertyValueIfExists(object, "templateUrl");
        Object templateFile = null;
        if (templateUrl != null) {
            state.setTemplateUrl(templateUrl);
            JSProperty urlProperty = object.findProperty("templateUrl");
            state.setTemplateFile(this.parseTemplate(templateUrl, urlProperty));
        }
        JSProperty template = object.findProperty("template");
        if (templateUrl == null && object.findProperty("templateUrl") != null || template != null || object.findProperty("templateProvider") != null) {
            state.setHasTemplateDefined(true);
        }
        if (template != null && (templateDefinition = AngularUiRouterDiagramBuilder.findTemplateDefinitionObject(template)) != null) {
            state.setTemplatePointer((SmartPsiElementPointer<PsiElement>)this.mySmartPointerManager.createSmartPsiElementPointer(templateDefinition));
        }
        if ((views = object.findProperty("views")) != null && (value = views.getValue()) instanceof JSObjectLiteralExpression && (viewsProperties = ((JSObjectLiteralExpression)value).getProperties()) != null && viewsProperties.length > 0) {
            ArrayList<UiView> viewsList = new ArrayList<UiView>();
            for (JSProperty property : viewsProperties) {
                if (property.getName() == null || property.getValue() == null) continue;
                viewsList.add(this.processView(property));
            }
            state.setViews(viewsList);
        }
        if ((abstractProperty = object.findProperty("abstract")) != null && abstractProperty.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)abstractProperty.getValue()).isBooleanLiteral() && Boolean.TRUE.equals(((JSLiteralExpression)abstractProperty.getValue()).getValue())) {
            state.setAbstract(true);
        }
    }

    @Nullable
    private static PsiElement findTemplateDefinitionObject(@NotNull JSProperty template) {
        PsiElement resolve;
        JSExpression value;
        if (template == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(11);
        }
        if ((value = template.getValue()) instanceof JSLiteralExpression) {
            return value;
        }
        if (value instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)value).resolve()) != null && resolve.isValid() && resolve instanceof JSVariable && ((JSVariable)resolve).getInitializer() instanceof JSLiteralExpression) {
            return ((JSVariable)resolve).getInitializer();
        }
        return null;
    }

    @Nullable
    private VirtualFile parseTemplate(@NotNull String url, @Nullable JSProperty urlProperty) {
        if (url == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(12);
        }
        PsiFile templateFile = null;
        Template template = null;
        if (urlProperty != null && urlProperty.getValue() != null) {
            PsiElement templateFileElement;
            int offset = urlProperty.getValue().getTextRange().getEndOffset() - 1;
            PsiReference reference = urlProperty.getContainingFile().findReferenceAt(offset);
            if (reference != null && (templateFileElement = reference.resolve()) != null && templateFileElement.isValid()) {
                templateFile = templateFileElement.getContainingFile();
                if (this.myTemplatesMap.containsKey(templateFile.getVirtualFile())) {
                    return templateFile.getVirtualFile();
                }
                template = AngularUiRouterDiagramBuilder.readTemplateFromFile(urlProperty.getProject(), url, (PsiElement)templateFile);
                this.myTemplatesMap.put(templateFile.getVirtualFile(), template);
                return templateFile.getVirtualFile();
            }
        }
        return null;
    }

    @NotNull
    static Template readTemplateFromFile(@NotNull Project project, @NotNull String url, PsiElement templateElement) {
        if (project == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(13);
        }
        if (url == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(14);
        }
        PsiFile templateFile = templateElement.getContainingFile();
        HashMap<String, SmartPsiElementPointer<PsiElement>> placeholders = new HashMap<String, SmartPsiElementPointer<PsiElement>>();
        HashSet placeholdersSet = new HashSet();
        FileBasedIndex instance = FileBasedIndex.getInstance();
        GlobalSearchScope scope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)templateFile.getVirtualFile());
        instance.processAllKeys(AngularUiRouterViewsIndex.UI_ROUTER_VIEWS_CACHE_INDEX, view -> {
            placeholdersSet.add(view);
            return true;
        }, scope, null);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        for (String key : placeholdersSet) {
            instance.processValues(AngularUiRouterViewsIndex.UI_ROUTER_VIEWS_CACHE_INDEX, (Object)key, null, (file, value) -> {
                JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName((String)key), null);
                JSOffsetBasedImplicitElement implicitElement = new JSOffsetBasedImplicitElement(builder, (int)value.getStartOffset(), templateFile);
                if (templateElement instanceof PsiFile || PsiTreeUtil.isAncestor((PsiElement)templateElement, (PsiElement)implicitElement, (boolean)false)) {
                    placeholders.put(key, smartPointerManager.createSmartPsiElementPointer((PsiElement)implicitElement));
                }
                return true;
            }, scope);
        }
        Template template = new Template(url, (SmartPsiElementPointer<PsiElement>)smartPointerManager.createSmartPsiElementPointer(templateElement));
        template.setViewPlaceholders(placeholders);
        Template template2 = template;
        if (template2 == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(15);
        }
        return template2;
    }

    private UiView processView(@NotNull JSProperty property) {
        PsiElement templateDefinition;
        JSProperty template;
        if (property == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(16);
        }
        String name = property.getName();
        JSExpression value = property.getValue();
        JSObjectLiteralExpression expression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)value, JSObjectLiteralExpression.class);
        String templateUrl = null;
        VirtualFile templateFile = null;
        if (expression != null && (templateUrl = AngularUiRouterDiagramBuilder.getPropertyValueIfExists(expression, "templateUrl")) != null) {
            JSProperty urlProperty = expression.findProperty("templateUrl");
            templateFile = this.parseTemplate(templateUrl, urlProperty);
        }
        UiView view = new UiView(name, templateUrl, templateFile, property.getNameIdentifier() == null ? null : this.mySmartPointerManager.createSmartPsiElementPointer(property.getNameIdentifier()));
        if (expression != null && (template = expression.findProperty("template")) != null && (templateDefinition = AngularUiRouterDiagramBuilder.findTemplateDefinitionObject(template)) != null) {
            view.setTemplatePointer((SmartPsiElementPointer<PsiElement>)this.mySmartPointerManager.createSmartPsiElementPointer(templateDefinition));
        }
        return view;
    }

    @Nullable
    private static String getPropertyValueIfExists(@NotNull JSObjectLiteralExpression object, @NotNull String name) {
        JSProperty urlProperty;
        if (object == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(17);
        }
        if (name == null) {
            AngularUiRouterDiagramBuilder.$$$reportNull$$$0(18);
        }
        if ((urlProperty = object.findProperty(name)) != null && urlProperty.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)urlProperty.getValue()).isQuotedLiteral()) {
            return StringUtil.unquoteString((String)urlProperty.getValue().getText());
        }
        return null;
    }

    public Map<VirtualFile, Template> getTemplatesMap() {
        return this.myTemplatesMap;
    }

    public Map<VirtualFile, RootTemplate> getRootTemplates() {
        return this.myRootTemplates;
    }

    public Map<VirtualFile, Map<String, UiRouterState>> getRootTemplates2States() {
        return this.myRootTemplates2States;
    }

    public Map<VirtualFile, Map<String, UiRouterState>> getDefiningFiles2States() {
        return this.myDefiningFiles2States;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/codeInsight/router/AngularUiRouterDiagramBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesQueue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/codeInsight/router/AngularUiRouterDiagramBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readTemplateFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putState2map";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRootTemplatesForEmbedded";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addContainingFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPossibleRelativeUrl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateDefinitionObject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseTemplate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readTemplateFromFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processView";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValueIfExists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonCyclicQueue<T> {
        private final Set<T> processed = new HashSet<T>();
        private final ArrayDeque<T> toProcess = new ArrayDeque();

        private NonCyclicQueue() {
        }

        public void add(@NotNull T t) {
            if (t == null) {
                NonCyclicQueue.$$$reportNull$$$0(0);
            }
            if (this.processed.contains(t) || !this.check(t)) {
                return;
            }
            this.processed.add(t);
            this.toProcess.add(t);
        }

        protected boolean check(T t) {
            return true;
        }

        public void addAll(Collection<? extends T> collection) {
            for (T t : collection) {
                this.add(t);
            }
        }

        public boolean isEmpty() {
            return this.toProcess.isEmpty();
        }

        @Nullable
        public T removeNext() {
            return this.toProcess.isEmpty() ? null : (T)this.toProcess.remove();
        }

        public Set<T> getProcessed() {
            return this.processed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/angularjs/codeInsight/router/AngularUiRouterDiagramBuilder$NonCyclicQueue", "add"));
        }
    }
}

