/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.router;

import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.angularjs.codeInsight.router.AngularUiRouterDiagramBuilder;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularUiRouterGenericStatesIndex;
import org.jetbrains.annotations.NotNull;

public class AngularRouterStateLoader {
    @NotNull
    private final Project myProject;

    public AngularRouterStateLoader(@NotNull Project project) {
        if (project == null) {
            AngularRouterStateLoader.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public List<JSProperty> loadFreelyDefinedStates() {
        ArrayList<JSProperty> states = new ArrayList<JSProperty>();
        Collection<String> allKeys = AngularIndexUtil.getAllKeys(AngularUiRouterGenericStatesIndex.KEY, this.myProject);
        for (String key : allKeys) {
            ArrayList list = new ArrayList();
            AngularIndexUtil.multiResolve(this.myProject, AngularUiRouterGenericStatesIndex.KEY, key, (Processor<? super JSImplicitElement>)((Processor)list::add));
            for (JSImplicitElement element : list) {
                JSCallExpression callExpression = AngularUiRouterDiagramBuilder.findWrappingCallExpression(element);
                if (callExpression == null) continue;
                AngularRouterStateLoader.findPossibleReferences(callExpression, (Processor<? super JSObjectLiteralExpression>)((Processor)object -> {
                    JSProperty nameProp = object.findProperty("name");
                    if (nameProp != null && nameProp.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)nameProp.getValue()).isQuotedLiteral()) {
                        states.add(nameProp);
                    }
                    return true;
                }));
            }
        }
        return states;
    }

    private static void findPossibleReferences(@NotNull JSCallExpression callExpression, @NotNull Processor<? super JSObjectLiteralExpression> processor) {
        JSExpression[] arguments;
        if (callExpression == null) {
            AngularRouterStateLoader.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            AngularRouterStateLoader.$$$reportNull$$$0(2);
        }
        if ((arguments = callExpression.getArguments()).length == 1 && arguments[0] instanceof JSReferenceExpression) {
            AngularRouterStateLoader.processReference(processor, arguments[0]);
        }
    }

    private static void processReference(@NotNull Processor<? super JSObjectLiteralExpression> processor, JSExpression argument) {
        JSReferenceExpression reference;
        PsiElement resolved;
        if (processor == null) {
            AngularRouterStateLoader.$$$reportNull$$$0(3);
        }
        if ((resolved = (reference = (JSReferenceExpression)argument).resolve()) instanceof JSVariable) {
            JSExpression initializer = ((JSVariable)resolved).getInitializerOrStub();
            if (initializer instanceof JSObjectLiteralExpression && processor.process((Object)((JSObjectLiteralExpression)initializer))) {
                return;
            }
            JSElement declarationScope = (JSElement)ObjectUtils.tryCast((Object)((JSVariable)resolved).getDeclarationScope(), JSElement.class);
            if (declarationScope != null) {
                Collection assignments = PsiTreeUtil.findChildrenOfType((PsiElement)declarationScope, JSAssignmentExpression.class);
                assignments.stream().map(as -> as.getDefinitionExpression()).filter(definition -> definition != null && StringUtil.equals((CharSequence)reference.getReferenceName(), (CharSequence)definition.getName()) && definition.getInitializerOrStub() instanceof JSObjectLiteralExpression).forEach(definition -> processor.process((Object)((JSObjectLiteralExpression)definition.getInitializerOrStub())));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "org/angularjs/codeInsight/router/AngularRouterStateLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findPossibleReferences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

