/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.xml.XmlAttributeDescriptor;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularAttributeDescriptor;
import org.angularjs.codeInsight.attributes.AngularJSAttributeDescriptorsProvider;
import org.angularjs.index.AngularControllerIndex;
import org.angularjs.index.AngularModuleIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AngularAttributesRegistry {
    @NotNull
    public static AngularAttributeDescriptor createDescriptor(@Nullable Project project, @NotNull String attributeName, @Nullable PsiElement declaration) {
        if (attributeName == null) {
            AngularAttributesRegistry.$$$reportNull$$$0(0);
        }
        if ("ngController".equals(DirectiveUtil.normalizeAttributeName(attributeName))) {
            return new AngularAttributeDescriptor(project, attributeName, AngularControllerIndex.KEY, declaration);
        }
        if ("ngApp".equals(DirectiveUtil.normalizeAttributeName(attributeName))) {
            return new AngularAttributeDescriptor(project, attributeName, AngularModuleIndex.KEY, declaration);
        }
        return new AngularAttributeDescriptor(project, attributeName, null, declaration);
    }

    public static boolean isAngularExpressionAttribute(XmlAttribute parent) {
        String type = AngularAttributesRegistry.getType(parent);
        return type.endsWith("expression") || type.startsWith("string");
    }

    public static boolean isJSONAttribute(XmlAttribute parent) {
        String value = parent.getValue();
        if (value == null || !value.startsWith("{")) {
            return false;
        }
        String type = AngularAttributesRegistry.getType(parent);
        return type.contains("object literal") || type.equals("mixed");
    }

    @NotNull
    private static String getType(XmlAttribute parent) {
        PsiElement directive;
        XmlAttributeDescriptor descriptor = AngularJSAttributeDescriptorsProvider.getDescriptor(parent.getName(), parent.getParent());
        PsiElement psiElement = directive = descriptor != null ? descriptor.getDeclaration() : null;
        if (directive instanceof JSImplicitElement) {
            String restrict = ((JSImplicitElement)directive).getTypeString();
            String[] args = restrict != null ? restrict.split(";", -1) : null;
            return args != null && args.length > 2 ? args[2] : "";
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "org/angularjs/codeInsight/attributes/AngularAttributesRegistry", "createDescriptor"));
    }
}

