/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.navigation;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.angular2.Angular2InjectionUtils;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2ComponentLocator;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2Entity;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.Angular2LangUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2GotoRelatedProvider
extends GotoRelatedProvider {
    private static final int COMPONENT_INDEX = 1;
    private static final int TEMPLATE_INDEX = 2;
    private static final int TEST_INDEX = 3;
    private static final int STYLES_INDEX_START = 4;
    private static final int MODULE_INDEX = 5;

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        PsiFile file;
        if (psiElement == null) {
            Angular2GotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if ((file = psiElement.getContainingFile()) == null || !Angular2LangUtil.isAngular2Context((PsiElement)file)) {
            List list = Collections.emptyList();
            if (list == null) {
                Angular2GotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        SmartList componentClasses = new SmartList();
        if (DialectDetector.isTypeScript((PsiElement)file)) {
            ContainerUtil.addIfNotNull((Collection)componentClasses, (Object)((TypeScriptClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, TypeScriptClass.class)));
            if (componentClasses.isEmpty()) {
                for (PsiElement el : TestFinderHelper.findClassesForTest((PsiElement)file)) {
                    if (!(el instanceof JSFile)) continue;
                    componentClasses.addAll(PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)el, TypeScriptClass.class));
                }
            }
        } else {
            componentClasses.addAll(Angular2ComponentLocator.findComponentClasses((PsiElement)file));
        }
        PsiFile filter = (PsiFile)ObjectUtils.notNull((Object)Angular2InjectionUtils.getFirstInjectedFile(PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSExpression.class)), (Object)file);
        List components = ContainerUtil.mapNotNull((Collection)componentClasses, Angular2EntitiesProvider::getComponent);
        switch (components.size()) {
            case 0: {
                List list = Collections.emptyList();
                if (list == null) {
                    Angular2GotoRelatedProvider.$$$reportNull$$$0(2);
                }
                return list;
            }
            case 1: {
                List list = ContainerUtil.filter(Angular2GotoRelatedProvider.getRelatedItems((Angular2Component)components.get(0)), f -> !filter.equals(ObjectUtils.doIfNotNull((Object)f.getElement(), PsiElement::getContainingFile)));
                if (list == null) {
                    Angular2GotoRelatedProvider.$$$reportNull$$$0(3);
                }
                return list;
            }
        }
        List list = ContainerUtil.map((Collection)components, c -> new GotoRelatedItem((PsiElement)Objects.requireNonNull(c.getTypeScriptClass()), Angular2GotoRelatedProvider.getGroupName()));
        if (list == null) {
            Angular2GotoRelatedProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static List<GotoRelatedItem> getRelatedItems(Angular2Component component) {
        PsiFile file;
        SmartList result = new SmartList();
        TypeScriptClass cls = component.getTypeScriptClass();
        if (cls != null && cls.getName() != null) {
            result.add(new Angular2GoToRelatedItem((PsiElement)cls, 1, false, Angular2Bundle.message("angular.action.goto-related.component-class", new Object[0])));
        }
        if ((file = component.getTemplateFile()) != null) {
            result.add(new Angular2GoToRelatedItem((PsiElement)file, 2, true, Angular2Bundle.message("angular.action.goto-related.template", new Object[0])));
        }
        boolean first = true;
        int count = 1;
        Collection tests = TestFinderHelper.findTestsForClass((PsiElement)component.getSourceElement());
        for (PsiElement el : tests) {
            result.add(new Angular2GoToRelatedItem(el, first ? 3 : -1, false, Angular2Bundle.message("angular.action.goto-related.tests", tests.size() == 1 ? "" : " " + count++)));
            first = false;
        }
        List<PsiFile> cssFiles = component.getCssFiles();
        int mnemonic = 4;
        count = 1;
        for (PsiFile cssFile : cssFiles) {
            result.add(new Angular2GoToRelatedItem((PsiElement)cssFile, mnemonic++, true, Angular2Bundle.message("angular.action.goto-related.styles", cssFiles.size() == 1 ? "" : " " + count++)));
        }
        first = true;
        for (TypeScriptClass moduleClass : ContainerUtil.mapNotNull(component.getAllModules(), Angular2Entity::getTypeScriptClass)) {
            if (moduleClass.getName() == null) continue;
            result.add(new Angular2GoToRelatedItem((PsiElement)moduleClass, first ? 5 : -1, false, Angular2Bundle.message("angular.action.goto-related.module", new Object[0])));
            first = false;
        }
        return result;
    }

    @NlsContexts.Separator
    private static String getGroupName() {
        return Angular2Bundle.message("angular.action.goto-related.group-name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/navigation/Angular2GotoRelatedProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/navigation/Angular2GotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Angular2GoToRelatedItem
    extends GotoRelatedItem {
        private final String myContainerName;
        private final @NlsContexts.ListItem String myName;

        private Angular2GoToRelatedItem(@NotNull PsiElement element, int mnemonic, boolean inlineable, @Nullable @NlsContexts.ListItem String name) {
            if (element == null) {
                Angular2GoToRelatedItem.$$$reportNull$$$0(0);
            }
            super(element, Angular2GotoRelatedProvider.getGroupName(), mnemonic > 9 ? -1 : mnemonic);
            this.myContainerName = inlineable && InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile(element) != element.getContainingFile() ? Angular2Bundle.message("angular.action.goto-related.inline", new Object[0]) : null;
            this.myName = name;
        }

        @Nullable
        public String getCustomName() {
            return this.myName;
        }

        public String getCustomContainerName() {
            return this.myContainerName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angular2/navigation/Angular2GotoRelatedProvider$Angular2GoToRelatedItem", "<init>"));
        }
    }
}

