/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.selector;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.psi.Angular2TemplateBinding;
import org.angular2.lang.expr.psi.Angular2TemplateBindings;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2DirectiveSimpleSelector {
    private static final Pattern SELECTOR_REGEXP = Pattern.compile("(:not\\()|([-\\w]+)|(?:\\.([-\\w]+))|(?:\\[([-.\\w*]+)(?:=([\"']?)([^]\"']*)\\5)?])|(\\))|(\\s*,\\s*)");
    String element;
    final List<String> classNames = new SmartList();
    final List<String> attrs = new SmartList();
    final List<Angular2DirectiveSimpleSelector> notSelectors = new SmartList();

    @NotNull
    public static List<Angular2DirectiveSimpleSelector> parse(@NotNull String selector) throws ParseException {
        Angular2DirectiveSimpleSelector cssSelector;
        if (selector == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(0);
        }
        SmartList results = new SmartList();
        Consumer<Angular2DirectiveSimpleSelector> addResult = arg_0 -> Angular2DirectiveSimpleSelector.lambda$parse$0((List)results, arg_0);
        Angular2DirectiveSimpleSelector current = cssSelector = new Angular2DirectiveSimpleSelector();
        boolean inNot = false;
        Matcher matcher = SELECTOR_REGEXP.matcher(selector);
        while (matcher.find()) {
            if (matcher.start(1) >= 0) {
                if (inNot) {
                    throw new ParseException(Angular2Bundle.message("angular.parse.selector.nested-not", new Object[0]), new TextRange(matcher.start(1), matcher.end(1)));
                }
                inNot = true;
                current = new Angular2DirectiveSimpleSelector();
                cssSelector.notSelectors.add(current);
            } else if (matcher.start(2) >= 0) {
                current.setElement(matcher.group(2));
            }
            if (matcher.start(3) >= 0) {
                current.addClassName(matcher.group(3));
            }
            if (matcher.start(4) >= 0) {
                current.addAttribute(matcher.group(4), matcher.group(6));
            }
            if (matcher.start(7) >= 0) {
                inNot = false;
                current = cssSelector;
            }
            if (matcher.start(8) < 0) continue;
            if (inNot) {
                throw new ParseException(Angular2Bundle.message("angular.parse.selector.multiple-not", new Object[0]), new TextRange(matcher.start(8), matcher.end(8)));
            }
            addResult.accept(cssSelector);
            cssSelector = current = new Angular2DirectiveSimpleSelector();
        }
        addResult.accept(cssSelector);
        SmartList smartList = results;
        if (smartList == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    @NotNull
    public static List<Angular2DirectiveSimpleSelectorWithRanges> parseRanges(@NotNull String selector) throws ParseException {
        Angular2DirectiveSimpleSelectorWithRanges cssSelector;
        if (selector == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(2);
        }
        SmartList results = new SmartList();
        Angular2DirectiveSimpleSelectorWithRanges current = cssSelector = new Angular2DirectiveSimpleSelectorWithRanges();
        boolean inNot = false;
        Matcher matcher = SELECTOR_REGEXP.matcher(selector);
        while (matcher.find()) {
            if (matcher.start(1) >= 0) {
                if (inNot) {
                    throw new ParseException(Angular2Bundle.message("angular.parse.selector.nested-not", new Object[0]), new TextRange(matcher.start(1), matcher.end(1)));
                }
                inNot = true;
                current = new Angular2DirectiveSimpleSelectorWithRanges();
                cssSelector.notSelectors.add(current);
            } else if (matcher.start(2) >= 0) {
                current.setElement(matcher.group(2), matcher.start(2));
            }
            if (matcher.start(3) >= 0) {
                current.addClassName(matcher.group(3), matcher.start(3));
            }
            if (matcher.start(4) >= 0) {
                current.addAttribute(matcher.group(4), matcher.start(4));
            }
            if (matcher.start(7) >= 0) {
                inNot = false;
                current = cssSelector;
            }
            if (matcher.start(8) < 0) continue;
            if (inNot) {
                throw new ParseException(Angular2Bundle.message("angular.parse.selector.multiple-not", new Object[0]), new TextRange(matcher.start(8), matcher.end(8)));
            }
            results.add(cssSelector);
            cssSelector = current = new Angular2DirectiveSimpleSelectorWithRanges();
        }
        results.add(cssSelector);
        SmartList smartList = results;
        if (smartList == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    public static Angular2DirectiveSimpleSelector createTemplateBindingsCssSelector(@NotNull Angular2TemplateBindings bindings) {
        if (bindings == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(4);
        }
        Angular2DirectiveSimpleSelector cssSelector = new Angular2DirectiveSimpleSelector();
        cssSelector.setElement("ng-template");
        cssSelector.addAttribute(bindings.getTemplateName(), null);
        for (Angular2TemplateBinding binding : bindings.getBindings()) {
            if (binding.keyIsVar()) continue;
            cssSelector.addAttribute(binding.getKey(), (String)ObjectUtils.doIfNotNull((Object)binding.getExpression(), PsiElement::getText));
        }
        return cssSelector;
    }

    public static Angular2DirectiveSimpleSelector createElementCssSelector(@NotNull XmlTag element) {
        if (element == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(5);
        }
        Angular2DirectiveSimpleSelector cssSelector = new Angular2DirectiveSimpleSelector();
        String elNameNoNs = XmlUtil.findLocalNameByQualifiedName((String)element.getName());
        cssSelector.setElement(elNameNoNs);
        for (XmlAttribute attr : element.getAttributes()) {
            String attrNameNoNs = XmlUtil.findLocalNameByQualifiedName((String)attr.getName());
            Angular2AttributeNameParser.AttributeInfo info = Angular2AttributeNameParser.parse(attrNameNoNs, element);
            if (info.type == Angular2AttributeType.TEMPLATE_BINDINGS || info.type == Angular2AttributeType.LET || info.type == Angular2AttributeType.REFERENCE) continue;
            cssSelector.addAttribute(info.name, attr.getValue());
            if (!StringUtil.toLowerCase((String)attr.getName()).equals("class") || attr.getValue() == null) continue;
            StringUtil.split((String)attr.getValue(), (String)" ").forEach(clsName -> cssSelector.addClassName((String)clsName));
        }
        return cssSelector;
    }

    Angular2DirectiveSimpleSelector() {
    }

    public boolean isElementSelector() {
        return this.hasElementSelector() && this.classNames.isEmpty() && this.attrs.isEmpty() && this.notSelectors.isEmpty();
    }

    public boolean hasElementSelector() {
        return this.element != null;
    }

    @Nullable
    public String getElementName() {
        return this.element;
    }

    public void setElement(@Nullable String element) {
        this.element = element;
    }

    @NotNull
    public List<String> getAttrNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.classNames.isEmpty()) {
            result.add("class");
        }
        for (int i = 0; i < this.attrs.size(); i += 2) {
            result.add(this.attrs.get(i));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public List<Angular2DirectiveSimpleSelector> getNotSelectors() {
        List<Angular2DirectiveSimpleSelector> list = this.notSelectors;
        if (list == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void addAttribute(@NotNull String name, @Nullable String value) {
        if (name == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(8);
        }
        this.attrs.add(name);
        this.attrs.add(value != null ? StringUtil.toLowerCase((String)value) : "");
    }

    public void addClassName(@NotNull String name) {
        if (name == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(9);
        }
        this.classNames.add(StringUtil.toLowerCase((String)name));
    }

    @NotNull
    public String toString() {
        @NonNls StringBuilder result = new StringBuilder();
        if (this.element != null) {
            result.append(this.element);
        }
        this.classNames.forEach(cls -> {
            result.append('.');
            result.append((String)cls);
        });
        for (int i = 0; i < this.attrs.size(); i += 2) {
            result.append('[');
            result.append(this.attrs.get(i));
            String value = this.attrs.get(i + 1);
            if (!value.isEmpty()) {
                result.append("=");
                result.append(value);
            }
            result.append(']');
        }
        this.notSelectors.forEach(selector -> {
            result.append(":not(");
            result.append(selector.toString());
            result.append(')');
        });
        String string = result.toString();
        if (string == null) {
            Angular2DirectiveSimpleSelector.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void lambda$parse$0(List results, Angular2DirectiveSimpleSelector cssSel) {
        if (!cssSel.notSelectors.isEmpty() && cssSel.element == null && cssSel.classNames.isEmpty() && cssSel.attrs.isEmpty()) {
            cssSel.element = "*";
        }
        results.add(cssSel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/lang/selector/Angular2DirectiveSimpleSelector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/lang/selector/Angular2DirectiveSimpleSelector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRanges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttrNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotSelectors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseRanges";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateBindingsCssSelector";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createElementCssSelector";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAttribute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addClassName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ParseException
    extends Exception {
        private final TextRange myErrorRange;

        public ParseException(String s, TextRange errorRange) {
            super(s);
            this.myErrorRange = errorRange;
        }

        public TextRange getErrorRange() {
            return this.myErrorRange;
        }
    }

    public static final class Angular2DirectiveSimpleSelectorWithRanges {
        private Pair<String, Integer> element;
        private final List<Pair<String, Integer>> classNames = new SmartList();
        private final List<Pair<String, Integer>> attrs = new SmartList();
        private final List<Angular2DirectiveSimpleSelectorWithRanges> notSelectors = new SmartList();

        private Angular2DirectiveSimpleSelectorWithRanges() {
        }

        private void addAttribute(@NotNull String name, int offset) {
            if (name == null) {
                Angular2DirectiveSimpleSelectorWithRanges.$$$reportNull$$$0(0);
            }
            this.attrs.add((Pair<String, Integer>)Pair.pair((Object)name, (Object)offset));
        }

        private void addClassName(@NotNull String name, int offset) {
            if (name == null) {
                Angular2DirectiveSimpleSelectorWithRanges.$$$reportNull$$$0(1);
            }
            this.classNames.add((Pair<String, Integer>)Pair.pair((Object)name, (Object)offset));
        }

        private void setElement(@NotNull String name, int offset) {
            if (name == null) {
                Angular2DirectiveSimpleSelectorWithRanges.$$$reportNull$$$0(2);
            }
            this.element = Pair.pair((Object)name, (Object)offset);
        }

        @Nullable
        public Pair<String, Integer> getElementRange() {
            return this.element;
        }

        @NotNull
        public List<Pair<String, Integer>> getClassNameRanges() {
            List<Pair<String, Integer>> list = this.classNames;
            if (list == null) {
                Angular2DirectiveSimpleSelectorWithRanges.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public List<Pair<String, Integer>> getAttributeRanges() {
            List<Pair<String, Integer>> list = this.attrs;
            if (list == null) {
                Angular2DirectiveSimpleSelectorWithRanges.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public List<Angular2DirectiveSimpleSelectorWithRanges> getNotSelectors() {
            List<Angular2DirectiveSimpleSelectorWithRanges> list = this.notSelectors;
            if (list == null) {
                Angular2DirectiveSimpleSelectorWithRanges.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/angular2/lang/selector/Angular2DirectiveSimpleSelector$Angular2DirectiveSimpleSelectorWithRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/angular2/lang/selector/Angular2DirectiveSimpleSelector$Angular2DirectiveSimpleSelectorWithRanges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassNameRanges";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributeRanges";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotSelectors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addAttribute";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addClassName";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setElement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

