/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.html.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.html.HtmlParsing;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import com.intellij.xml.psi.XmlPsiBundle;
import com.intellij.xml.util.XmlUtil;
import java.util.Objects;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.parser.Angular2EmbeddedExprTokenType;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.angular2.lang.html.parser.Angular2ExpansionFormCaseContentTokenType;
import org.angular2.lang.html.parser.Angular2HtmlElementTypes;
import org.angular2.lang.html.parser.Angular2HtmlVarAttrTokenType;
import org.jetbrains.annotations.NotNull;

public class Angular2HtmlParsing
extends HtmlParsing {
    private static final TokenSet CUSTOM_CONTENT = TokenSet.create((IElementType[])new IElementType[]{Angular2HtmlElementTypes.EXPANSION_FORM_START, Angular2HtmlElementTypes.INTERPOLATION_START, Angular2HtmlElementTypes.XML_DATA_CHARACTERS, Angular2HtmlElementTypes.XML_COMMA});
    private static final TokenSet DATA_TOKENS = TokenSet.create((IElementType[])new IElementType[]{Angular2HtmlElementTypes.XML_COMMA, Angular2HtmlElementTypes.XML_DATA_CHARACTERS});
    private final Stack<PsiBuilder.Marker> ngNonBindableTags;

    public Angular2HtmlParsing(@NotNull PsiBuilder builder) {
        if (builder == null) {
            Angular2HtmlParsing.$$$reportNull$$$0(0);
        }
        super(builder);
        this.ngNonBindableTags = new Stack();
    }

    public void parseExpansionFormContent() {
        PsiBuilder.Marker expansionFormContent = this.mark();
        PsiBuilder.Marker xmlText = null;
        while (!this.eof()) {
            IElementType tt = this.token();
            if (tt == XmlTokenType.XML_START_TAG_START) {
                xmlText = Angular2HtmlParsing.terminateText(xmlText);
                this.parseTag();
                continue;
            }
            if (tt == XmlTokenType.XML_PI_START) {
                xmlText = Angular2HtmlParsing.terminateText((PsiBuilder.Marker)xmlText);
                this.parseProcessingInstruction();
                continue;
            }
            if (tt == XmlTokenType.XML_CHAR_ENTITY_REF || tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                xmlText = this.startText(xmlText);
                this.parseReference();
                continue;
            }
            if (tt == XmlTokenType.XML_CDATA_START) {
                xmlText = this.startText(xmlText);
                this.parseCData();
                continue;
            }
            if (tt == XmlTokenType.XML_COMMENT_START) {
                xmlText = this.startText(xmlText);
                this.parseComment();
                continue;
            }
            if (tt == XmlTokenType.XML_BAD_CHARACTER) {
                xmlText = this.startText(xmlText);
                PsiBuilder.Marker error = this.mark();
                this.advance();
                error.error(XmlPsiBundle.message((String)"xml.parsing.unescaped.ampersand.or.nonterminated.character.entity.reference", (Object[])new Object[0]));
                continue;
            }
            if (tt == XmlTokenType.XML_END_TAG_START) {
                PsiBuilder.Marker tagEndError = this.mark();
                this.advance();
                if (this.token() == XmlTokenType.XML_NAME) {
                    this.advance();
                    if (this.token() == XmlTokenType.XML_TAG_END) {
                        this.advance();
                    }
                }
                tagEndError.error(XmlPsiBundle.message((String)"xml.parsing.closing.tag.matches.nothing", (Object[])new Object[0]));
                continue;
            }
            if (tt instanceof ICustomParsingType || tt instanceof ILazyParseableElementType) {
                xmlText = Angular2HtmlParsing.terminateText((PsiBuilder.Marker)xmlText);
                this.advance();
                continue;
            }
            if (this.hasCustomTagContent()) {
                xmlText = this.parseCustomTagContent(xmlText);
                continue;
            }
            xmlText = this.startText(xmlText);
            this.advance();
        }
        Angular2HtmlParsing.terminateText(xmlText);
        expansionFormContent.done(Angular2HtmlElementTypes.EXPANSION_FORM_CASE_CONTENT);
    }

    protected boolean hasCustomTopLevelContent() {
        return CUSTOM_CONTENT.contains(this.token());
    }

    protected boolean hasCustomTagContent() {
        return CUSTOM_CONTENT.contains(this.token());
    }

    protected PsiBuilder.Marker parseCustomTagContent(PsiBuilder.Marker xmlText) {
        IElementType tt = this.token();
        if (tt == Angular2HtmlElementTypes.INTERPOLATION_START) {
            xmlText = this.ngNonBindableTags.isEmpty() ? Angular2HtmlParsing.terminateText((PsiBuilder.Marker)xmlText) : this.startText(xmlText);
            PsiBuilder.Marker interpolation = this.mark();
            this.advance();
            if (this.token() == Angular2EmbeddedExprTokenType.INTERPOLATION_EXPR) {
                this.advance();
            }
            if (this.ngNonBindableTags.isEmpty()) {
                if (this.token() == Angular2HtmlElementTypes.INTERPOLATION_END) {
                    this.advance();
                    interpolation.drop();
                } else {
                    interpolation.error(Angular2Bundle.message("angular.parse.template.unterminated-interpolation", new Object[0]));
                }
            } else {
                if (this.token() == Angular2HtmlElementTypes.INTERPOLATION_END) {
                    this.advance();
                }
                interpolation.collapse(Angular2HtmlElementTypes.XML_DATA_CHARACTERS);
            }
        } else if (tt == Angular2HtmlElementTypes.EXPANSION_FORM_START) {
            xmlText = Angular2HtmlParsing.terminateText((PsiBuilder.Marker)xmlText);
            this.parseExpansionForm();
        } else if (tt == Angular2HtmlElementTypes.XML_COMMA) {
            xmlText = this.startText(xmlText);
            this.getBuilder().remapCurrentToken(Angular2HtmlElementTypes.XML_DATA_CHARACTERS);
            this.advance();
        } else if (tt == Angular2HtmlElementTypes.XML_DATA_CHARACTERS) {
            xmlText = this.startText(xmlText);
            PsiBuilder.Marker dataStart = this.mark();
            while (DATA_TOKENS.contains(this.token())) {
                this.advance();
            }
            dataStart.collapse(Angular2HtmlElementTypes.XML_DATA_CHARACTERS);
        }
        return xmlText;
    }

    protected PsiBuilder.Marker parseCustomTopLevelContent(PsiBuilder.Marker error) {
        error = Angular2HtmlParsing.flushError((PsiBuilder.Marker)error);
        Angular2HtmlParsing.terminateText((PsiBuilder.Marker)this.parseCustomTagContent(null));
        return error;
    }

    protected PsiBuilder.Marker closeTag() {
        if (!this.ngNonBindableTags.isEmpty() && this.ngNonBindableTags.peek() == this.peekTagMarker()) {
            this.ngNonBindableTags.pop();
        }
        return super.closeTag();
    }

    protected void parseAttribute() {
        PsiBuilder.Marker attrName;
        assert (this.token() == Angular2HtmlElementTypes.XML_NAME);
        PsiBuilder.Marker att = this.mark();
        String tagName = XmlUtil.findLocalNameByQualifiedName((String)this.peekTagName());
        String attributeName = this.getBuilder().getTokenText();
        if ("ngNonBindable".equals(attributeName) && (this.ngNonBindableTags.isEmpty() || this.ngNonBindableTags.peek() != this.peekTagMarker())) {
            this.ngNonBindableTags.push((Object)this.peekTagMarker());
        }
        Angular2AttributeNameParser.AttributeInfo attributeInfo = Angular2AttributeNameParser.parse(Objects.requireNonNull(attributeName), tagName);
        if (attributeInfo.error != null) {
            attrName = this.mark();
            this.advance();
            attrName.error(attributeInfo.error);
        } else if (attributeInfo.type == Angular2AttributeType.REFERENCE) {
            attrName = this.mark();
            this.advance();
            attrName.collapse((IElementType)Angular2HtmlVarAttrTokenType.REFERENCE);
        } else if (attributeInfo.type == Angular2AttributeType.LET) {
            attrName = this.mark();
            this.advance();
            attrName.collapse((IElementType)Angular2HtmlVarAttrTokenType.LET);
        } else {
            this.advance();
        }
        IElementType attributeElementType = attributeInfo.type.getElementType();
        if (this.token() == Angular2HtmlElementTypes.XML_EQ) {
            this.advance();
            attributeElementType = this.parseAttributeValue(attributeElementType, attributeInfo.name);
        }
        att.done(attributeElementType != Angular2HtmlElementTypes.NG_CONTENT_SELECTOR ? attributeElementType : Angular2HtmlElementTypes.XML_ATTRIBUTE);
    }

    private IElementType parseAttributeValue(@NotNull IElementType attributeElementType, @NotNull String name) {
        if (attributeElementType == null) {
            Angular2HtmlParsing.$$$reportNull$$$0(1);
        }
        if (name == null) {
            Angular2HtmlParsing.$$$reportNull$$$0(2);
        }
        PsiBuilder.Marker attValue = this.mark();
        IElementType contentType = Angular2HtmlParsing.getAttributeContentType(attributeElementType, name);
        if (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            PsiBuilder.Marker contentStart;
            this.advance();
            PsiBuilder.Marker marker = contentStart = contentType != null ? this.mark() : null;
            while ((tt = this.token()) != null && tt != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlTokenType.XML_END_TAG_START && tt != XmlTokenType.XML_EMPTY_ELEMENT_END && tt != XmlTokenType.XML_START_TAG_START) {
                if (tt == Angular2EmbeddedExprTokenType.INTERPOLATION_EXPR && attributeElementType == Angular2HtmlElementTypes.XML_ATTRIBUTE) {
                    attributeElementType = Angular2HtmlElementTypes.PROPERTY_BINDING;
                }
                if (tt == XmlTokenType.XML_BAD_CHARACTER) {
                    PsiBuilder.Marker error = this.mark();
                    this.advance();
                    error.error(XmlPsiBundle.message((String)"xml.parsing.unescaped.ampersand.or.nonterminated.character.entity.reference", (Object[])new Object[0]));
                    continue;
                }
                if (tt == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                    this.parseReference();
                    continue;
                }
                this.advance();
            }
            if (contentStart != null) {
                if (contentType == Angular2HtmlElementTypes.NG_CONTENT_SELECTOR) {
                    contentStart.done(contentType);
                } else {
                    contentStart.collapse(contentType);
                }
            }
            if (this.token() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.advance();
            } else {
                this.error(XmlPsiBundle.message((String)"xml.parsing.unclosed.attribute.value", (Object[])new Object[0]));
            }
        } else if (this.token() != XmlTokenType.XML_TAG_END && this.token() != XmlTokenType.XML_EMPTY_ELEMENT_END) {
            if (contentType != null) {
                PsiBuilder.Marker contentStart = this.mark();
                this.advance();
                if (contentType == Angular2HtmlElementTypes.NG_CONTENT_SELECTOR) {
                    contentStart.done(contentType);
                } else {
                    contentStart.collapse(contentType);
                }
            } else {
                this.advance();
            }
        }
        attValue.done(XmlElementType.XML_ATTRIBUTE_VALUE);
        return attributeElementType;
    }

    private static IElementType getAttributeContentType(IElementType type, String name) {
        if (type == Angular2HtmlElementTypes.PROPERTY_BINDING || type == Angular2HtmlElementTypes.BANANA_BOX_BINDING) {
            return Angular2EmbeddedExprTokenType.BINDING_EXPR;
        }
        if (type == Angular2HtmlElementTypes.EVENT) {
            return Angular2EmbeddedExprTokenType.ACTION_EXPR;
        }
        if (type == Angular2HtmlElementTypes.TEMPLATE_BINDINGS) {
            return Angular2EmbeddedExprTokenType.createTemplateBindings(name);
        }
        if (type == Angular2HtmlElementTypes.NG_CONTENT_SELECTOR) {
            return Angular2HtmlElementTypes.NG_CONTENT_SELECTOR;
        }
        if (type == Angular2HtmlElementTypes.REFERENCE || type == Angular2HtmlElementTypes.LET || type == Angular2HtmlElementTypes.XML_ATTRIBUTE) {
            return null;
        }
        throw new IllegalStateException("Unsupported element type: " + type);
    }

    private void parseExpansionForm() {
        assert (this.token() == Angular2HtmlElementTypes.EXPANSION_FORM_START);
        PsiBuilder.Marker expansionForm = this.mark();
        this.advance();
        if (!this.remapTokensUntilComma((IElementType)Angular2EmbeddedExprTokenType.BINDING_EXPR) || !this.remapTokensUntilComma(Angular2HtmlElementTypes.XML_DATA_CHARACTERS)) {
            this.markCriticalExpansionFormProblem(expansionForm);
            return;
        }
        this.skipRealWhiteSpaces();
        boolean first = true;
        while (this.token() == Angular2HtmlElementTypes.XML_DATA_CHARACTERS || this.token() == Angular2HtmlElementTypes.EXPANSION_FORM_CASE_START) {
            if (!this.parseExpansionFormCaseContent() && first) {
                this.markCriticalExpansionFormProblem(expansionForm);
                return;
            }
            first = false;
            this.skipRealWhiteSpaces();
        }
        if (this.token() != Angular2HtmlElementTypes.EXPANSION_FORM_END) {
            expansionForm.error(Angular2Bundle.message("angular.parse.template.unterminated-expansion-form", new Object[0]));
            expansionForm = expansionForm.precede();
        } else {
            this.advance();
        }
        expansionForm.done(Angular2HtmlElementTypes.EXPANSION_FORM);
    }

    private void markCriticalExpansionFormProblem(PsiBuilder.Marker expansionForm) {
        expansionForm.rollbackTo();
        expansionForm = this.mark();
        assert (this.token() == Angular2HtmlElementTypes.EXPANSION_FORM_START);
        this.advance();
        expansionForm.error(Angular2Bundle.message("angular.parse.template.unterminated-expansion-form-critical", new Object[0]));
    }

    private boolean remapTokensUntilComma(IElementType textType) {
        PsiBuilder.Marker start = this.mark();
        while (!this.eof() && this.token() != Angular2HtmlElementTypes.XML_COMMA) {
            this.advance();
        }
        start.collapse(textType);
        if (this.token() != Angular2HtmlElementTypes.XML_COMMA) {
            start.precede().error(Angular2Bundle.message("angular.parse.template.invalid-icu-message-expected-comma", new Object[0]));
            return false;
        }
        this.advance();
        return true;
    }

    private boolean parseExpansionFormCaseContent() {
        IElementType tt;
        PsiBuilder.Marker expansionFormCase = this.mark();
        if (this.token() == Angular2HtmlElementTypes.XML_DATA_CHARACTERS) {
            this.advance();
            this.skipRealWhiteSpaces();
            if (this.token() != Angular2HtmlElementTypes.EXPANSION_FORM_CASE_START) {
                expansionFormCase.error(Angular2Bundle.message("angular.parse.template.invalid-icu-message-expected-left-brace", new Object[0]));
                expansionFormCase.precede().done(Angular2HtmlElementTypes.EXPANSION_FORM_CASE);
                return false;
            }
        } else if (this.token() == Angular2HtmlElementTypes.EXPANSION_FORM_CASE_START) {
            this.advance();
            expansionFormCase.error(Angular2Bundle.message("angular.parse.template.invalid-icu-message-missing-case-value", new Object[0]));
            expansionFormCase = expansionFormCase.precede();
        } else {
            throw new IllegalStateException();
        }
        this.advance();
        PsiBuilder.Marker content = this.mark();
        int level = 1;
        while ((tt = this.token()) != Angular2HtmlElementTypes.EXPANSION_FORM_CASE_END || level > 1) {
            if (tt == Angular2HtmlElementTypes.EXPANSION_FORM_CASE_START) {
                ++level;
            } else if (tt == Angular2HtmlElementTypes.EXPANSION_FORM_CASE_END) {
                --level;
            } else if (tt == null) {
                content.error(Angular2Bundle.message("angular.parse.template.invalid-icu-message-missing-right-brace", new Object[0]));
                expansionFormCase.done(Angular2HtmlElementTypes.EXPANSION_FORM_CASE);
                return false;
            }
            this.advance();
        }
        content.collapse((IElementType)Angular2ExpansionFormCaseContentTokenType.INSTANCE);
        this.advance();
        expansionFormCase.done(Angular2HtmlElementTypes.EXPANSION_FORM_CASE);
        return true;
    }

    private void skipRealWhiteSpaces() {
        while (this.token() == Angular2HtmlElementTypes.XML_REAL_WHITE_SPACE) {
            this.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/angular2/lang/html/parser/Angular2HtmlParsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseAttributeValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

