/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.expr.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Consumer;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.lexer.Angular2TokenTypes;
import org.angular2.lang.expr.parser.Angular2ElementTypes;
import org.angular2.lang.expr.parser.Angular2StubElementTypes;
import org.jetbrains.annotations.NonNls;

public class Angular2Parser
extends JavaScriptParser<Angular2ExpressionParser, Angular2StatementParser, FunctionParser, JSPsiTypeParser> {
    private final boolean myIsAction;
    private final boolean myIsSimpleBinding;
    private final boolean myIsJavaScript;

    public static void parseAction(PsiBuilder builder, IElementType root) {
        Angular2Parser.parseRoot(builder, root, Angular2ElementTypes.ACTION_STATEMENT, true, false, (Consumer<? super Angular2StatementParser>)((Consumer)Angular2StatementParser::parseChain));
    }

    public static void parseBinding(PsiBuilder builder, IElementType root) {
        Angular2Parser.parseRoot(builder, root, Angular2ElementTypes.BINDING_STATEMENT, false, false, (Consumer<? super Angular2StatementParser>)((Consumer)parser -> {
            if (!parser.parseQuote()) {
                parser.parseChain();
            }
        }));
    }

    public static void parseTemplateBindings(PsiBuilder builder, IElementType root, String templateKey) {
        Angular2Parser.parseRoot(builder, root, Angular2ElementTypes.createTemplateBindingsStatement(templateKey), false, false, (Consumer<? super Angular2StatementParser>)((Consumer)parser -> parser.parseTemplateBindings(templateKey)));
    }

    public static void parseInterpolation(PsiBuilder builder, IElementType root) {
        Angular2Parser.parseRoot(builder, root, Angular2ElementTypes.INTERPOLATION_STATEMENT, false, false, (Consumer<? super Angular2StatementParser>)((Consumer)Angular2StatementParser::parseChain));
    }

    public static void parseSimpleBinding(PsiBuilder builder, IElementType root) {
        Angular2Parser.parseRoot(builder, root, Angular2ElementTypes.SIMPLE_BINDING_STATEMENT, false, true, (Consumer<? super Angular2StatementParser>)((Consumer)parser -> {
            if (!parser.parseQuote()) {
                parser.parseChain();
            }
        }));
    }

    private static void parseRoot(PsiBuilder builder, IElementType root, IElementType statementType, boolean isAction, boolean isSimpleBinding, Consumer<? super Angular2StatementParser> parseAction) {
        PsiBuilder.Marker rootMarker = builder.mark();
        PsiBuilder.Marker statementMarker = builder.mark();
        parseAction.consume((Object)new Angular2Parser(builder, isAction, isSimpleBinding, false).getStatementParser());
        statementMarker.done(statementType);
        rootMarker.done(root);
    }

    public static void parseJS(PsiBuilder builder, IElementType root) {
        new Angular2Parser(builder).parseJS(root);
    }

    public Angular2Parser(PsiBuilder builder) {
        this(builder, false, false, true);
    }

    private Angular2Parser(PsiBuilder builder, boolean isAction, boolean isSimpleBinding, boolean isJavaScript) {
        super(DialectOptionHolder.JS_1_5, builder);
        this.myIsAction = isAction;
        this.myIsSimpleBinding = isSimpleBinding;
        this.myIsJavaScript = isJavaScript;
        this.myExpressionParser = new Angular2ExpressionParser();
        this.myStatementParser = new Angular2StatementParser(this);
    }

    private static void finishKey(PsiBuilder.Marker key, boolean isVariable) {
        if (isVariable) {
            key.collapse(Angular2TokenTypes.IDENTIFIER);
            key = key.precede();
            key.done((IElementType)Angular2ElementTypes.TEMPLATE_BINDING_VARIABLE);
            key.precede().done((IElementType)Angular2ElementTypes.VAR_STATEMENT);
        } else {
            key.done(Angular2ElementTypes.TEMPLATE_BINDING_KEY);
        }
    }

    protected class Angular2ExpressionParser
    extends ExpressionParser<Angular2Parser> {
        @NonNls
        private static final String CHAR_ENTITY_QUOT = "&quot;";
        @NonNls
        private static final String CHAR_ENTITY_APOS = "&apos;";

        public Angular2ExpressionParser() {
            super((JavaScriptParser)Angular2Parser.this);
        }

        public boolean parseAssignmentExpression(boolean allowIn) {
            return this.parsePipe();
        }

        public void parseScriptExpression() {
            throw new UnsupportedOperationException();
        }

        public boolean parsePipe() {
            PsiBuilder.Marker pipe = this.builder.mark();
            PsiBuilder.Marker firstParam = this.builder.mark();
            if (!this.parseAssignmentExpressionChecked()) {
                firstParam.drop();
                pipe.drop();
                return false;
            }
            while (this.builder.getTokenType() == Angular2TokenTypes.OR) {
                if (Angular2Parser.this.myIsSimpleBinding) {
                    this.builder.error(Angular2Bundle.message("angular.parse.expression.pipe-in-host-binding", new Object[0]));
                } else if (Angular2Parser.this.myIsAction) {
                    this.builder.error(Angular2Bundle.message("angular.parse.expression.pipe-in-action", new Object[0]));
                }
                firstParam.done(Angular2ElementTypes.PIPE_LEFT_SIDE_ARGUMENT);
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == Angular2TokenTypes.IDENTIFIER || Angular2TokenTypes.KEYWORDS.contains(this.builder.getTokenType())) {
                    PsiBuilder.Marker pipeName = this.builder.mark();
                    this.builder.advanceLexer();
                    pipeName.done(Angular2ElementTypes.PIPE_REFERENCE_EXPRESSION);
                } else {
                    this.builder.error(Angular2Bundle.message("angular.parse.expression.expected-identifier-or-keyword", new Object[0]));
                }
                PsiBuilder.Marker params = this.builder.mark();
                boolean hasParams = false;
                while (this.builder.getTokenType() == Angular2TokenTypes.COLON) {
                    this.builder.advanceLexer();
                    if (!this.parseAssignmentExpressionChecked()) {
                        this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                        continue;
                    }
                    hasParams = true;
                }
                if (hasParams) {
                    params.done(Angular2ElementTypes.PIPE_ARGUMENTS_LIST);
                } else {
                    params.drop();
                }
                pipe.done(Angular2ElementTypes.PIPE_EXPRESSION);
                firstParam = pipe.precede();
                pipe = firstParam.precede();
            }
            firstParam.drop();
            pipe.drop();
            return true;
        }

        public boolean parseAssignmentExpressionChecked() {
            PsiBuilder.Marker expr = this.builder.mark();
            if (this.builder.getTokenType() == Angular2TokenTypes.EQ) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                this.builder.advanceLexer();
                if (!this.parsePipe()) {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                expr.done((IElementType)JSStubElementTypes.ASSIGNMENT_EXPRESSION);
                return true;
            }
            PsiBuilder.Marker definitionExpr = this.builder.mark();
            if (!this.parseConditionalExpression(false)) {
                definitionExpr.drop();
                expr.drop();
                return false;
            }
            if (this.builder.getTokenType() == Angular2TokenTypes.EQ) {
                definitionExpr.done((IElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
                if (!Angular2Parser.this.myIsAction && !Angular2Parser.this.myIsJavaScript) {
                    this.builder.error(Angular2Bundle.message("angular.parse.expression.assignment-in-binding", new Object[0]));
                }
                this.builder.advanceLexer();
                if (!this.parsePipe()) {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                expr.done((IElementType)JSStubElementTypes.ASSIGNMENT_EXPRESSION);
            } else {
                definitionExpr.drop();
                expr.drop();
            }
            return true;
        }

        public boolean parsePrimaryExpression() {
            IElementType firstToken = this.builder.getTokenType();
            if (firstToken == JSTokenTypes.STRING_LITERAL_PART || this.isEntityStringStart(firstToken)) {
                return this.parsePartialStringLiteral(firstToken);
            }
            return super.parsePrimaryExpression();
        }

        private boolean isEntityStringStart(IElementType tokenType) {
            if (tokenType != Angular2TokenTypes.XML_CHAR_ENTITY_REF) {
                return false;
            }
            String text = this.builder.getTokenText();
            return text != null && (text.equals(CHAR_ENTITY_QUOT) || text.equals(CHAR_ENTITY_APOS));
        }

        protected boolean isIdentifierToken(IElementType tokenType) {
            return !Angular2TokenTypes.KEYWORDS.contains(tokenType) && super.isIdentifierToken(tokenType);
        }

        protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
            if (this.builder.getTokenType() == Angular2TokenTypes.OR) {
                return -1;
            }
            return super.getCurrentBinarySignPriority(allowIn, advance);
        }

        protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
            return tokenType == Angular2TokenTypes.ELVIS || tokenType == JSTokenTypes.DOT;
        }

        protected boolean isPropertyStart(IElementType elementType) {
            if (elementType != Angular2TokenTypes.IDENTIFIER && elementType != Angular2TokenTypes.STRING_LITERAL && !Angular2TokenTypes.KEYWORDS.contains(elementType)) {
                this.builder.error(Angular2Bundle.message("angular.parse.expression.expected-identifier-keyword-or-string", new Object[0]));
                return false;
            }
            return true;
        }

        protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef) {
            if (this.builder.getTokenType() == Angular2TokenTypes.EXCL) {
                this.builder.advanceLexer();
                PsiBuilder.Marker marker = (PsiBuilder.Marker)markerRef.get();
                marker.done(JSElementTypes.NOT_NULL_EXPRESSION);
                markerRef.set((Object)marker.precede());
                return true;
            }
            return false;
        }

        protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
            IElementType firstToken = this.builder.getTokenType();
            if (Angular2ElementTypes.PROPERTY_NAMES.contains(firstToken)) {
                String errorMessage = this.validateLiteral();
                this.advancePropertyName(firstToken);
                if (errorMessage != null) {
                    this.builder.error(errorMessage);
                }
            } else {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.property.name", (Object[])new Object[0]));
                this.builder.advanceLexer();
            }
            this.parsePropertyInitializer(false);
            property.done((IElementType)Angular2StubElementTypes.PROPERTY);
            property.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }

        private boolean parsePartialStringLiteral(IElementType firstToken) {
            PsiBuilder.Marker mark = this.builder.mark();
            IElementType currentToken = firstToken;
            StringBuilder literal = new StringBuilder();
            String text = this.getCurrentLiteralPartTokenText(currentToken);
            boolean singleQuote = text == null || text.startsWith("'");
            boolean first = true;
            while (text != null && (currentToken == JSTokenTypes.STRING_LITERAL_PART || Angular2TokenTypes.STRING_PART_SPECIAL_SEQ.contains(currentToken))) {
                literal.append(text);
                this.builder.advanceLexer();
                if (!first && (singleQuote && text.endsWith("'") && !text.endsWith("\\'") || !singleQuote && text.endsWith("\"") && !text.endsWith("\\\""))) break;
                first = false;
                currentToken = this.builder.getTokenType();
                text = this.getCurrentLiteralPartTokenText(currentToken);
            }
            mark.done((IElementType)JSStubElementTypes.LITERAL_EXPRESSION);
            String errorMessage = Angular2ExpressionParser.validateLiteralText((String)literal.toString());
            if (errorMessage != null) {
                this.builder.error(errorMessage);
            }
            return true;
        }

        private String getCurrentLiteralPartTokenText(IElementType currentToken) {
            String text = this.builder.getTokenText();
            if (text != null && currentToken == Angular2TokenTypes.XML_CHAR_ENTITY_REF) {
                if (text.equals(CHAR_ENTITY_APOS)) {
                    return "'";
                }
                if (text.equals(CHAR_ENTITY_QUOT)) {
                    return "\"";
                }
            }
            return text;
        }
    }

    protected class Angular2StatementParser
    extends StatementParser<Angular2Parser> {
        protected Angular2StatementParser(Angular2Parser parser) {
            super((JavaScriptParser)parser);
        }

        public void parseChain() {
            assert (!Angular2Parser.this.myIsJavaScript);
            PsiBuilder.Marker chain = this.builder.mark();
            int count = 0;
            while (!this.builder.eof()) {
                ++count;
                PsiBuilder.Marker expression = this.builder.mark();
                if (!((Angular2ExpressionParser)Angular2Parser.this.getExpressionParser()).parseExpressionOptional(false, false)) {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                    this.builder.advanceLexer();
                    expression.drop();
                } else if (Angular2Parser.this.myIsAction) {
                    expression.done(Angular2ElementTypes.EXPRESSION_STATEMENT);
                } else {
                    expression.drop();
                }
                IElementType tokenType = this.builder.getTokenType();
                if (tokenType == Angular2TokenTypes.SEMICOLON) {
                    if (!Angular2Parser.this.myIsAction) {
                        this.builder.error(Angular2Bundle.message("angular.parse.expression.chained-expression-in-binding", new Object[0]));
                    }
                    while (this.builder.getTokenType() == Angular2TokenTypes.SEMICOLON) {
                        this.builder.advanceLexer();
                    }
                    continue;
                }
                if (tokenType == null) continue;
                this.builder.error(Angular2Bundle.message("angular.parse.expression.unexpected-token", this.builder.getTokenText()));
            }
            switch (count) {
                case 0: {
                    if (Angular2Parser.this.myIsAction) {
                        chain.done(Angular2ElementTypes.EMPTY_STATEMENT);
                        break;
                    }
                    chain.done((IElementType)Angular2ElementTypes.EMPTY_EXPRESSION);
                    break;
                }
                case 1: {
                    chain.drop();
                    break;
                }
                default: {
                    if (Angular2Parser.this.myIsAction) {
                        chain.done(Angular2ElementTypes.CHAIN_STATEMENT);
                        break;
                    }
                    chain.drop();
                }
            }
        }

        public boolean parseQuote() {
            PsiBuilder.Marker quote = this.builder.mark();
            if (this.builder.getTokenType() != Angular2TokenTypes.IDENTIFIER && !Angular2TokenTypes.KEYWORDS.contains(this.builder.getTokenType()) || this.builder.lookAhead(1) != Angular2TokenTypes.COLON) {
                quote.drop();
                return false;
            }
            this.builder.advanceLexer();
            this.builder.enforceCommentTokens(TokenSet.EMPTY);
            this.builder.advanceLexer();
            PsiBuilder.Marker rest = this.builder.mark();
            while (!this.builder.eof()) {
                this.builder.advanceLexer();
            }
            rest.collapse(Angular2TokenTypes.STRING_LITERAL);
            quote.done(Angular2ElementTypes.QUOTE_STATEMENT);
            return true;
        }

        public void parseTemplateBindings(String templateKey) {
            boolean firstBinding = true;
            do {
                String rawKey;
                String key;
                PsiBuilder.Marker binding = this.builder.mark();
                boolean isVar = false;
                if (firstBinding) {
                    rawKey = key = templateKey;
                    firstBinding = false;
                } else {
                    boolean bl = isVar = this.builder.getTokenType() == Angular2TokenTypes.LET_KEYWORD;
                    if (isVar) {
                        this.builder.advanceLexer();
                    }
                    rawKey = this.parseTemplateBindingKey(isVar);
                    String string = key = isVar ? rawKey : templateKey + StringUtil.capitalize((String)rawKey);
                    if (this.builder.getTokenType() == Angular2TokenTypes.COLON) {
                        this.builder.advanceLexer();
                    }
                }
                String name = null;
                if (isVar) {
                    if (this.builder.getTokenType() == Angular2TokenTypes.EQ) {
                        this.builder.advanceLexer();
                        name = this.parseTemplateBindingKey(false);
                    } else {
                        name = "$implicit";
                    }
                } else if (this.builder.getTokenType() == Angular2TokenTypes.AS_KEYWORD) {
                    this.builder.advanceLexer();
                    name = rawKey;
                    key = this.parseTemplateBindingKey(true);
                    isVar = true;
                } else if (this.builder.getTokenType() != Angular2TokenTypes.LET_KEYWORD && !((Angular2ExpressionParser)Angular2Parser.this.getExpressionParser()).parsePipe()) {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                binding.done(Angular2ElementTypes.createTemplateBindingStatement(key, isVar, name));
                if (this.builder.getTokenType() == Angular2TokenTypes.AS_KEYWORD && !isVar) {
                    PsiBuilder.Marker localBinding = this.builder.mark();
                    this.builder.advanceLexer();
                    String letName = this.parseTemplateBindingKey(true);
                    localBinding.done(Angular2ElementTypes.createTemplateBindingStatement(letName, true, key));
                }
                if (this.builder.getTokenType() != Angular2TokenTypes.SEMICOLON && this.builder.getTokenType() != Angular2TokenTypes.COMMA) continue;
                this.builder.advanceLexer();
            } while (!this.builder.eof());
        }

        private String parseTemplateBindingKey(boolean isVariable) {
            PsiBuilder.Marker key = this.builder.mark();
            boolean operatorFound = true;
            StringBuilder result = new StringBuilder();
            do {
                if (!Angular2Parser.this.isIdentifierName(this.builder.getTokenType())) {
                    if (result.length() > 0) {
                        Angular2Parser.finishKey(key, isVariable);
                    } else {
                        key.drop();
                    }
                    this.builder.error(Angular2Bundle.message("angular.parse.expression.expected-identifier-or-keyword", new Object[0]));
                    this.builder.advanceLexer();
                    return result.toString();
                }
                result.append(this.builder.getTokenText());
                if (this.builder.rawLookup(1) == Angular2TokenTypes.MINUS) {
                    this.builder.advanceLexer();
                    result.append(this.builder.getTokenText());
                } else {
                    operatorFound = false;
                }
                this.builder.advanceLexer();
            } while (operatorFound);
            Angular2Parser.finishKey(key, isVariable);
            return result.toString();
        }
    }
}

