/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Function;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.Angular2InjectionUtils;
import org.angular2.entities.Angular2Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Angular2FixesPsiUtil {
    public static boolean insertNgModuleMember(Angular2Module module, String propertyName, String name) {
        ES6Decorator decorator = module.getDecorator();
        if (decorator == null) {
            return false;
        }
        JSObjectLiteralExpression initializer = Angular2DecoratorUtil.getObjectLiteralInitializer(decorator);
        if (initializer == null) {
            return false;
        }
        JSProperty targetListProp = initializer.findProperty(propertyName);
        if (targetListProp == null) {
            Angular2FixesPsiUtil.reformatJSObjectLiteralProperty(Angular2FixesPsiUtil.insertJSObjectLiteralProperty(initializer, propertyName, "[\n" + name + "\n]"));
        } else {
            JSExpression propValue = targetListProp.getValue();
            if (propValue == null) {
                return false;
            }
            if (!(propValue instanceof JSArrayLiteralExpression)) {
                JSProperty newProperty = (JSProperty)JSChangeUtil.createObjectLiteralPropertyFromText((String)(propertyName + ": [\n" + propValue.getText() + "\n]"), (PsiElement)initializer);
                targetListProp = (JSProperty)targetListProp.replace((PsiElement)newProperty);
                propValue = targetListProp.getValue();
                assert (propValue instanceof JSArrayLiteralExpression);
            }
            JSReferenceExpression newModuleIdent = (JSReferenceExpression)JSChangeUtil.createExpressionPsiWithContext((String)name, (PsiElement)propValue, JSReferenceExpression.class);
            assert (newModuleIdent != null);
            Angular2FixesPsiUtil.insertNewLinesAroundArrayItemIfNeeded((JSExpression)propValue.addAfter((PsiElement)newModuleIdent, (PsiElement)ObjectUtils.notNull((Object)((PsiElement)ArrayUtil.getLastElement((Object[])((JSArrayLiteralExpression)propValue).getExpressions())), (Object)propValue.getFirstChild())));
            FormatFixer.create((PsiElement)targetListProp, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        }
        return true;
    }

    public static JSProperty insertJSObjectLiteralProperty(@NotNull JSObjectLiteralExpression objectLiteral, @NotNull String propertyName, @NotNull String propertyValue) {
        if (objectLiteral == null) {
            Angular2FixesPsiUtil.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            Angular2FixesPsiUtil.$$$reportNull$$$0(1);
        }
        if (propertyValue == null) {
            Angular2FixesPsiUtil.$$$reportNull$$$0(2);
        }
        PsiElement property = JSChangeUtil.createObjectLiteralPropertyFromText((String)(propertyName + ": " + propertyValue), (PsiElement)objectLiteral);
        JSProperty added = (JSProperty)JSRefactoringUtil.addMemberToMemberHolder((PsiElement)objectLiteral, (PsiElement)property, (PsiElement)objectLiteral);
        Angular2FixesPsiUtil.insertNewLinesAroundPropertyIfNeeded(added);
        return added;
    }

    @NotNull
    public static JSProperty reformatJSObjectLiteralProperty(JSProperty property) {
        SmartPsiElementPointer propertyPointer = SmartPointerManager.createPointer((PsiElement)property);
        FormatFixer.create((PsiElement)property.getParent(), (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        property = (JSProperty)propertyPointer.getElement();
        assert (property != null);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)property.getProject());
        Document document = documentManager.getDocument(property.getContainingFile());
        assert (document != null);
        documentManager.commitDocument(document);
        PsiFile htmlContent = Angular2InjectionUtils.getFirstInjectedFile((PsiElement)property.getValue());
        if (htmlContent != null) {
            FormatFixer.create((PsiElement)htmlContent, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
        }
        JSProperty jSProperty = (JSProperty)propertyPointer.getElement();
        if (jSProperty == null) {
            Angular2FixesPsiUtil.$$$reportNull$$$0(3);
        }
        return jSProperty;
    }

    private static void insertNewLinesAroundArrayItemIfNeeded(@NotNull JSExpression expression) {
        if (expression == null) {
            Angular2FixesPsiUtil.$$$reportNull$$$0(4);
        }
        Angular2FixesPsiUtil.insertNewLinesAroundItemHolderIfNeeded((JSElement)expression, JSArrayLiteralExpression::getExpressions);
    }

    private static void insertNewLinesAroundPropertyIfNeeded(@NotNull JSProperty property) {
        if (property == null) {
            Angular2FixesPsiUtil.$$$reportNull$$$0(5);
        }
        Angular2FixesPsiUtil.insertNewLinesAroundItemHolderIfNeeded((JSElement)property, JSObjectLiteralExpression::getProperties);
    }

    private static <T extends PsiElement> void insertNewLinesAroundItemHolderIfNeeded(@NotNull JSElement item, Function<T, ? extends JSElement[]> getChildren) {
        boolean wrapWithNewLines;
        if (item == null) {
            Angular2FixesPsiUtil.$$$reportNull$$$0(6);
        }
        PsiElement parent = item.getParent();
        boolean bl = wrapWithNewLines = item.getText().contains("\n") || ContainerUtil.find((Object[])getChildren.apply(parent), e -> e != item && !Angular2FixesPsiUtil.isPrefixedWithNewLine(e)) == null;
        if (wrapWithNewLines) {
            LeafPsiElement comma;
            if (!Angular2FixesPsiUtil.isPrefixedWithNewLine(item)) {
                JSChangeUtil.addWs((ASTNode)parent.getNode(), (ASTNode)item.getNode(), (String)"\n");
            }
            if ((comma = Angular2FixesPsiUtil.findCommaOrBracket(item)) != null) {
                PsiElement next = comma.getNextSibling();
                if (!(next instanceof PsiWhiteSpace) || !next.getText().contains("\n")) {
                    JSChangeUtil.addWsAfter((PsiElement)parent, (PsiElement)comma, (String)"\n");
                }
            } else {
                for (PsiElement e2 = item.getNextSibling(); e2 != null; e2 = e2.getNextSibling()) {
                    if (!(e2 instanceof PsiWhiteSpace) || !e2.getText().contains("\n")) continue;
                    return;
                }
                JSChangeUtil.addWsAfter((PsiElement)parent, (PsiElement)item, (String)"\n");
            }
        }
    }

    private static boolean isPrefixedWithNewLine(@NotNull JSElement property) {
        PsiWhiteSpace whiteSpace;
        if (property == null) {
            Angular2FixesPsiUtil.$$$reportNull$$$0(7);
        }
        return (whiteSpace = (PsiWhiteSpace)ObjectUtils.tryCast((Object)property.getPrevSibling(), PsiWhiteSpace.class)) != null && whiteSpace.getText().contains("\n");
    }

    @Nullable
    private static LeafPsiElement findCommaOrBracket(@NotNull JSElement property) {
        PsiElement el;
        if (property == null) {
            Angular2FixesPsiUtil.$$$reportNull$$$0(8);
        }
        if (!((el = PsiTreeUtil.skipWhitespacesForward((PsiElement)property)) instanceof LeafPsiElement) || el.getNode().getElementType() != JSTokenTypes.COMMA) {
            return null;
        }
        return (LeafPsiElement)el;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/quickfixes/Angular2FixesPsiUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/quickfixes/Angular2FixesPsiUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "reformatJSObjectLiteralProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertJSObjectLiteralProperty";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertNewLinesAroundArrayItemIfNeeded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertNewLinesAroundPropertyIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertNewLinesAroundItemHolderIfNeeded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixedWithNewLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCommaOrBracket";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

