/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities.metadata.psi;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.angular2.entities.metadata.psi.Angular2MetadataElement;
import org.angular2.entities.metadata.psi.Angular2MetadataNodeModule;
import org.angular2.index.Angular2MetadataNodeModuleIndex;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalNodeModuleResolver {
    @NonNls
    private static final Logger LOG = Logger.getInstance(ExternalNodeModuleResolver.class);
    private static final Set<String> ourReportedErrors = new HashSet<String>();
    private static final String NODE_MODULES_SEGMENT = "/node_modules/";
    private final Angular2MetadataElement mySource;
    private final String myModuleName;
    private final String myMemberName;

    public ExternalNodeModuleResolver(@NotNull Angular2MetadataElement source, @NotNull String moduleName, @Nullable String memberName) {
        if (source == null) {
            ExternalNodeModuleResolver.$$$reportNull$$$0(0);
        }
        if (moduleName == null) {
            ExternalNodeModuleResolver.$$$reportNull$$$0(1);
        }
        this.mySource = source;
        this.myMemberName = memberName;
        this.myModuleName = moduleName;
    }

    public Angular2MetadataElement resolve() {
        Function<Angular2MetadataNodeModule, Angular2MetadataElement> memberExtractor;
        Function<Angular2MetadataNodeModule, Angular2MetadataElement> function = memberExtractor = this.myMemberName == null ? nodeModule -> nodeModule : nodeModule -> (Angular2MetadataElement)((Object)((Object)ObjectUtils.tryCast((Object)((Object)nodeModule.findMember(this.myMemberName)), Angular2MetadataElement.class)));
        if (this.myModuleName.startsWith("./") || this.myModuleName.startsWith("../")) {
            Angular2MetadataNodeModule module = (Angular2MetadataNodeModule)((Object)ObjectUtils.doIfNotNull((Object)this.mySource.loadRelativeFile(this.myModuleName, ".metadata.json"), file -> (Angular2MetadataNodeModule)PsiTreeUtil.getStubChildOfType((PsiElement)file, Angular2MetadataNodeModule.class)));
            return module != null ? memberExtractor.apply(module) : null;
        }
        Angular2MetadataElement result = this.resolveFromFileSystem(memberExtractor);
        return result != null ? result : this.resolveFromIndex(memberExtractor);
    }

    @Nullable
    private Angular2MetadataElement resolveFromFileSystem(@NotNull Function<Angular2MetadataNodeModule, Angular2MetadataElement> memberExtractor) {
        if (memberExtractor == null) {
            ExternalNodeModuleResolver.$$$reportNull$$$0(2);
        }
        return (Angular2MetadataElement)((Object)ObjectUtils.doIfNotNull((Object)NodeModuleSearchUtil.findAncestorNodeModulesDir((VirtualFile)this.mySource.getContainingFile().getVirtualFile()), dir -> {
            Angular2MetadataNodeModule module = (Angular2MetadataNodeModule)((Object)((Object)ObjectUtils.doIfNotNull((Object)this.mySource.loadRelativeFile((VirtualFile)dir, this.myModuleName, ".metadata.json"), file -> (Angular2MetadataNodeModule)PsiTreeUtil.getStubChildOfType((PsiElement)file, Angular2MetadataNodeModule.class))));
            return module != null ? (Angular2MetadataElement)((Object)((Object)memberExtractor.apply(module))) : null;
        }));
    }

    @Nullable
    private Angular2MetadataElement resolveFromIndex(@NotNull Function<Angular2MetadataNodeModule, Angular2MetadataElement> memberExtractor) {
        if (memberExtractor == null) {
            ExternalNodeModuleResolver.$$$reportNull$$$0(3);
        }
        MultiMap candidates = MultiMap.createSet();
        StubIndex.getInstance().processElements(Angular2MetadataNodeModuleIndex.KEY, (Object)this.myModuleName, this.mySource.getProject(), GlobalSearchScope.allScope((Project)this.mySource.getProject()), Angular2MetadataNodeModule.class, nodeModule -> {
            if (nodeModule.isValid()) {
                ObjectUtils.doIfNotNull((Object)((Object)((Angular2MetadataElement)((Object)((Object)memberExtractor.apply((Angular2MetadataNodeModule)((Object)nodeModule)))))), element -> {
                    candidates.putValue((Object)element, (Object)nodeModule);
                    return null;
                });
            }
            return true;
        });
        if (candidates.size() > 1) {
            this.retainReachableNodeModulesFolders((MultiMap<Angular2MetadataElement, Angular2MetadataNodeModule>)candidates);
        }
        if (candidates.size() > 1) {
            ExternalNodeModuleResolver.retainPackageTypingRoots((MultiMap<Angular2MetadataElement, Angular2MetadataNodeModule>)candidates);
        }
        if (candidates.size() > 1) {
            return (Angular2MetadataElement)((Object)StreamEx.of((Collection)candidates.keySet()).min(Comparator.comparing(candidate -> candidate.getContainingFile().getVirtualFile().getPath())).get());
        }
        return (Angular2MetadataElement)((Object)ContainerUtil.getFirstItem((Collection)candidates.keySet()));
    }

    private void retainReachableNodeModulesFolders(@NotNull MultiMap<Angular2MetadataElement, Angular2MetadataNodeModule> candidates) {
        String path;
        if (candidates == null) {
            ExternalNodeModuleResolver.$$$reportNull$$$0(4);
        }
        if ((path = ExternalNodeModuleResolver.getNodeModulesPath(this.mySource)) == null) {
            return;
        }
        HashSet<Angular2MetadataNodeModule> sameFolder = new HashSet<Angular2MetadataNodeModule>();
        HashSet<Angular2MetadataNodeModule> parentFolder = new HashSet<Angular2MetadataNodeModule>();
        candidates.values().forEach(nodeModule -> {
            String path1 = ExternalNodeModuleResolver.getNodeModulesPath(nodeModule);
            if (path1 != null) {
                if (path.equals(path1)) {
                    sameFolder.add((Angular2MetadataNodeModule)((Object)nodeModule));
                } else if (path.startsWith(path1)) {
                    parentFolder.add((Angular2MetadataNodeModule)((Object)nodeModule));
                }
            }
        });
        if (!sameFolder.isEmpty()) {
            ExternalNodeModuleResolver.retain(candidates, sameFolder);
        } else if (!parentFolder.isEmpty()) {
            ExternalNodeModuleResolver.retain(candidates, parentFolder);
        }
    }

    private static void retainPackageTypingRoots(@NotNull MultiMap<Angular2MetadataElement, Angular2MetadataNodeModule> candidates) {
        if (candidates == null) {
            ExternalNodeModuleResolver.$$$reportNull$$$0(5);
        }
        HashSet<Angular2MetadataNodeModule> packageTypingsRoots = new HashSet<Angular2MetadataNodeModule>();
        candidates.values().forEach(nodeModule -> {
            if (nodeModule.isPackageTypingsRoot()) {
                packageTypingsRoots.add((Angular2MetadataNodeModule)((Object)nodeModule));
            }
        });
        if (!packageTypingsRoots.isEmpty()) {
            ExternalNodeModuleResolver.retain(candidates, packageTypingsRoots);
        }
    }

    private static void retain(@NotNull MultiMap<Angular2MetadataElement, Angular2MetadataNodeModule> candidates, @NotNull Set<Angular2MetadataNodeModule> nodeModules) {
        if (candidates == null) {
            ExternalNodeModuleResolver.$$$reportNull$$$0(6);
        }
        if (nodeModules == null) {
            ExternalNodeModuleResolver.$$$reportNull$$$0(7);
        }
        Iterator iterator = candidates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Iterator listIterator = ((Collection)entry.getValue()).iterator();
            while (listIterator.hasNext()) {
                if (nodeModules.contains(listIterator.next())) continue;
                listIterator.remove();
            }
            if (!((Collection)entry.getValue()).isEmpty()) continue;
            iterator.remove();
        }
    }

    @Nullable
    private static String getNodeModulesPath(@NotNull Angular2MetadataElement element) {
        if (element == null) {
            ExternalNodeModuleResolver.$$$reportNull$$$0(8);
        }
        return ExternalNodeModuleResolver.stripNodeModulesPath((String)ObjectUtils.doIfNotNull((Object)element.getContainingFile().getOriginalFile().getVirtualFile(), VirtualFile::getPath));
    }

    @Nullable
    private static String stripNodeModulesPath(@Nullable String path) {
        int index = path != null ? path.lastIndexOf(NODE_MODULES_SEGMENT) : -1;
        return index >= 0 ? path.substring(0, index + 1) : null;
    }

    private static String renderFileName(@NotNull Angular2MetadataElement element) {
        String name;
        int index;
        if (element == null) {
            ExternalNodeModuleResolver.$$$reportNull$$$0(9);
        }
        if ((index = (name = element.getContainingFile().getVirtualFile().getPath()).lastIndexOf(NODE_MODULES_SEGMENT)) > 1 && (index = name.lastIndexOf("/", index - 1)) > 0) {
            return name.substring(index);
        }
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberExtractor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModules";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/angular2/entities/metadata/psi/ExternalNodeModuleResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveFromFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveFromIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "retainReachableNodeModulesFolders";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "retainPackageTypingRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "retain";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getNodeModulesPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "renderFileName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

