/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import one.util.streamex.StreamEx;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2FrameworkHandler;
import org.angular2.index.Angular2IndexingHandler;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.html.Angular2HtmlLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Angular2ComponentLocator {
    @Nullable
    public static TypeScriptClass findComponentClass(@NotNull PsiElement templateContext) {
        if (templateContext == null) {
            Angular2ComponentLocator.$$$reportNull$$$0(0);
        }
        return (TypeScriptClass)ContainerUtil.getFirstItem(Angular2ComponentLocator.findComponentClasses(templateContext));
    }

    @NotNull
    public static @NotNull List<@NotNull TypeScriptClass> findComponentClasses(@NotNull PsiElement templateContext) {
        PsiFile file;
        if (templateContext == null) {
            Angular2ComponentLocator.$$$reportNull$$$0(1);
        }
        if ((file = templateContext.getContainingFile()) == null || !file.getLanguage().isKindOf((Language)Angular2HtmlLanguage.INSTANCE) && !file.getLanguage().is((Language)Angular2Language.INSTANCE) && !Angular2ComponentLocator.isStylesheet(file)) {
            List<TypeScriptClass> list = Collections.emptyList();
            if (list == null) {
                Angular2ComponentLocator.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiFile hostFile = Angular2ComponentLocator.getHostFile(templateContext);
        if (hostFile == null) {
            List<TypeScriptClass> list = Collections.emptyList();
            if (list == null) {
                Angular2ComponentLocator.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (!file.getOriginalFile().equals(hostFile) && DialectDetector.isTypeScript((PsiElement)hostFile)) {
            List list = ContainerUtil.packNullables((Object[])new TypeScriptClass[]{Angular2DecoratorUtil.getClassForDecoratorElement((PsiElement)InjectedLanguageManager.getInstance((Project)templateContext.getProject()).getInjectionHost((PsiElement)file.getOriginalFile()))});
            if (list == null) {
                Angular2ComponentLocator.$$$reportNull$$$0(4);
            }
            return list;
        }
        SmartList result = new SmartList((Collection)StreamEx.of((Collection)Angular2FrameworkHandler.EP_NAME.getExtensionList()).toFlatList(h -> h.findAdditionalComponentClasses(hostFile)));
        if (result.isEmpty() || Angular2ComponentLocator.isStylesheet(file)) {
            result.addAll(Angular2ComponentLocator.resolveComponentsFromSimilarFile(hostFile));
        }
        if (result.isEmpty() || Angular2ComponentLocator.isStylesheet(file)) {
            result.addAll(Angular2IndexingHandler.resolveComponentsFromIndex(hostFile, dec -> Angular2ComponentLocator.hasFileReference(dec, hostFile)));
        }
        SmartList smartList = result;
        if (smartList == null) {
            Angular2ComponentLocator.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @NotNull
    public static @NotNull List<@NotNull TypeScriptClass> findComponentClassesInFile(@NotNull PsiFile file, @Nullable BiPredicate<TypeScriptClass, ES6Decorator> filter) {
        if (file == null) {
            Angular2ComponentLocator.$$$reportNull$$$0(6);
        }
        List list = ((StreamEx)StreamEx.of((Collection)JSStubBasedPsiTreeUtil.findDescendants((PsiElement)file, (TokenSet)Angular2IndexingHandler.TS_CLASS_TOKENS)).select(TypeScriptClass.class).filter(cls -> {
            ES6Decorator dec = Angular2DecoratorUtil.findDecorator((JSAttributeListOwner)cls, "Component");
            return dec != null && (filter == null || filter.test((TypeScriptClass)cls, dec));
        })).toList();
        if (list == null) {
            Angular2ComponentLocator.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static List<TypeScriptClass> resolveComponentsFromSimilarFile(@NotNull PsiFile file) {
        PsiFile directiveFile;
        if (file == null) {
            Angular2ComponentLocator.$$$reportNull$$$0(8);
        }
        String name = file.getViewProvider().getVirtualFile().getNameWithoutExtension();
        PsiDirectory dir = file.getParent();
        PsiFile psiFile = directiveFile = dir != null ? dir.findFile(name + ".ts") : null;
        if (directiveFile != null) {
            return Angular2ComponentLocator.findComponentClassesInFile(directiveFile, (cls, dec) -> Angular2ComponentLocator.hasFileReference(dec, file));
        }
        List<TypeScriptClass> list = Collections.emptyList();
        if (list == null) {
            Angular2ComponentLocator.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean hasFileReference(@Nullable ES6Decorator componentDecorator, @NotNull PsiFile file) {
        Angular2Component component;
        if (file == null) {
            Angular2ComponentLocator.$$$reportNull$$$0(10);
        }
        if ((component = Angular2EntitiesProvider.getComponent((PsiElement)componentDecorator)) != null) {
            return Angular2ComponentLocator.isStylesheet(file) ? component.getCssFiles().contains(file) : file.equals(component.getTemplateFile());
        }
        return false;
    }

    public static boolean isStylesheet(@NotNull PsiFile file) {
        if (file == null) {
            Angular2ComponentLocator.$$$reportNull$$$0(11);
        }
        return file instanceof StylesheetFile;
    }

    @Nullable
    private static PsiFile getHostFile(@NotNull PsiElement context) {
        PsiElement original;
        if (context == null) {
            Angular2ComponentLocator.$$$reportNull$$$0(12);
        }
        PsiFile hostFile = FileContextUtil.getContextFile((PsiElement)((original = CompletionUtil.getOriginalOrSelf((PsiElement)context)) != context ? original : context.getContainingFile().getOriginalFile()));
        return hostFile != null ? hostFile.getOriginalFile() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/entities/Angular2ComponentLocator";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/entities/Angular2ComponentLocator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentClassesInFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponentsFromSimilarFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findComponentClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findComponentClasses";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findComponentClassesInFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentsFromSimilarFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasFileReference";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStylesheet";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHostFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

