/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.io.FileUtil;
import javax.swing.JComponent;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkConfigurableForm;
import org.jetbrains.annotations.NotNull;

public class AndroidSdkConfigurable
implements AdditionalDataConfigurable {
    private final AndroidSdkConfigurableForm myForm;
    private Sdk mySdk;
    private final SdkModel.Listener myListener;
    private final SdkModel mySdkModel;

    public AndroidSdkConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            AndroidSdkConfigurable.$$$reportNull$$$0(0);
        }
        if (sdkModificator == null) {
            AndroidSdkConfigurable.$$$reportNull$$$0(1);
        }
        this.mySdkModel = sdkModel;
        this.myForm = new AndroidSdkConfigurableForm(sdkModel, sdkModificator);
        this.myListener = new SdkModel.Listener(){

            public void sdkAdded(@NotNull Sdk sdk) {
                if (sdk == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    AndroidSdkConfigurable.this.myForm.addJavaSdk(sdk);
                }
            }

            public void beforeSdkRemove(@NotNull Sdk sdk) {
                if (sdk == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    AndroidSdkConfigurable.this.myForm.removeJavaSdk(sdk);
                }
            }

            public void sdkChanged(@NotNull Sdk sdk, String previousName) {
                if (sdk == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    AndroidSdkConfigurable.this.myForm.updateJdks(sdk, previousName);
                }
            }

            public void sdkHomeSelected(@NotNull Sdk sdk, @NotNull String newSdkHome) {
                if (sdk == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (newSdkHome == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (sdk != null && AndroidSdks.getInstance().isAndroidSdk(sdk)) {
                    AndroidSdkConfigurable.this.myForm.internalJdkUpdate(sdk);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sdk";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newSdkHome";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/android/sdk/AndroidSdkConfigurable$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sdkAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeSdkRemove";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sdkChanged";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sdkHomeSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.mySdkModel.addListener(this.myListener);
    }

    public void setSdk(Sdk sdk) {
        this.mySdk = sdk;
    }

    public JComponent createComponent() {
        return this.myForm.getContentPanel();
    }

    public boolean isModified() {
        AndroidSdkAdditionalData data = AndroidSdks.getInstance().getAndroidSdkAdditionalData(this.mySdk);
        Sdk javaSdk = data != null ? data.getJavaSdk() : null;
        String javaSdkHomePath = javaSdk != null ? javaSdk.getHomePath() : null;
        Sdk selectedSdk = this.myForm.getSelectedSdk();
        String selectedSdkHomePath = selectedSdk != null ? selectedSdk.getHomePath() : null;
        return !FileUtil.pathsEqual((String)javaSdkHomePath, (String)selectedSdkHomePath);
    }

    public void apply() throws ConfigurationException {
        Sdk javaSdk = this.myForm.getSelectedSdk();
        AndroidSdkAdditionalData newData = new AndroidSdkAdditionalData(this.mySdk, javaSdk);
        newData.setBuildTarget(this.myForm.getSelectedBuildTarget());
        SdkModificator modificator = this.mySdk.getSdkModificator();
        modificator.setVersionString(javaSdk != null ? javaSdk.getVersionString() : null);
        modificator.setSdkAdditionalData((SdkAdditionalData)newData);
        ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)modificator).commitChanges());
    }

    public void reset() {
        if (this.mySdk == null) {
            return;
        }
        AndroidSdkAdditionalData data = AndroidSdks.getInstance().getAndroidSdkAdditionalData(this.mySdk);
        if (data == null) {
            return;
        }
        AndroidPlatform platform = data.getAndroidPlatform();
        this.myForm.init(data.getJavaSdk(), this.mySdk, platform != null ? data.getBuildTarget(platform.getSdkData()) : null);
    }

    public void disposeUIResources() {
        this.mySdkModel.removeListener(this.myListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkModificator";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/android/sdk/AndroidSdkConfigurable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

