/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPlatform {
    @NotNull
    private final AndroidSdkData mySdkData;
    @NotNull
    private final IAndroidTarget myTarget;

    public AndroidPlatform(@NotNull AndroidSdkData sdkData, @NotNull IAndroidTarget target) {
        if (sdkData == null) {
            AndroidPlatform.$$$reportNull$$$0(0);
        }
        if (target == null) {
            AndroidPlatform.$$$reportNull$$$0(1);
        }
        this.mySdkData = sdkData;
        this.myTarget = target;
    }

    @Nullable
    public static AndroidPlatform getInstance(@NotNull Module module) {
        if (module == null) {
            AndroidPlatform.$$$reportNull$$$0(2);
        }
        if (module.isDisposed()) {
            return null;
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        return sdk != null ? AndroidPlatform.getInstance(sdk) : null;
    }

    @Nullable
    public static AndroidPlatform getInstance(@NotNull Sdk sdk) {
        AndroidSdkAdditionalData data;
        if (sdk == null) {
            AndroidPlatform.$$$reportNull$$$0(3);
        }
        return (data = AndroidSdks.getInstance().getAndroidSdkAdditionalData(sdk)) != null ? data.getAndroidPlatform() : null;
    }

    @NotNull
    public AndroidSdkData getSdkData() {
        AndroidSdkData androidSdkData = this.mySdkData;
        if (androidSdkData == null) {
            AndroidPlatform.$$$reportNull$$$0(4);
        }
        return androidSdkData;
    }

    @NotNull
    public IAndroidTarget getTarget() {
        IAndroidTarget iAndroidTarget = this.myTarget;
        if (iAndroidTarget == null) {
            AndroidPlatform.$$$reportNull$$$0(5);
        }
        return iAndroidTarget;
    }

    @Nullable
    public static AndroidPlatform parse(@NotNull Sdk sdk) {
        IAndroidTarget target;
        SdkAdditionalData data;
        if (sdk == null) {
            AndroidPlatform.$$$reportNull$$$0(6);
        }
        if (!AndroidSdks.getInstance().isAndroidSdk(sdk)) {
            return null;
        }
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData != null && (data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData && (target = ((AndroidSdkAdditionalData)data).getBuildTarget(sdkData)) != null) {
            return new AndroidPlatform(sdkData, target);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static AndroidPlatform parse(@NotNull Library library, @Nullable Library.ModifiableModel model2, @Nullable Map<String, AndroidSdkData> parsedSdks) {
        VirtualFile sdkDir;
        if (library == null) {
            AndroidPlatform.$$$reportNull$$$0(7);
        }
        VirtualFile[] files2 = model2 != null ? model2.getFiles(OrderRootType.CLASSES) : library.getFiles(OrderRootType.CLASSES);
        HashSet<String> jarPaths = new HashSet<String>();
        VirtualFile frameworkLibrary = null;
        for (VirtualFile file : files2) {
            VirtualFile vFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (vFile == null) continue;
            if (vFile.getName().equals("android.jar")) {
                frameworkLibrary = vFile;
            }
            jarPaths.add(vFile.getPath());
        }
        if (frameworkLibrary != null && (sdkDir = frameworkLibrary.getParent()) != null) {
            AndroidSdkData sdkData;
            VirtualFile platformsDir = sdkDir.getParent();
            if (platformsDir != null && platformsDir.getName().equals("platforms") && (sdkDir = platformsDir.getParent()) == null) {
                return null;
            }
            String sdkPath = sdkDir.getPath();
            AndroidSdkData androidSdkData = sdkData = parsedSdks != null ? parsedSdks.get(sdkPath) : null;
            if (sdkData == null) {
                sdkData = AndroidSdkData.getSdkData(sdkPath);
                if (sdkData == null) {
                    return null;
                }
                if (parsedSdks != null) {
                    parsedSdks.put(sdkPath, sdkData);
                }
            }
            IAndroidTarget resultTarget = null;
            for (IAndroidTarget target : sdkData.getTargets()) {
                String targetsFrameworkLibPath = FileUtil.toCanonicalPath((String)target.getPath(1));
                if (!frameworkLibrary.getPath().equals(targetsFrameworkLibPath)) continue;
                if (target.isPlatform()) {
                    if (resultTarget != null) continue;
                    resultTarget = target;
                    continue;
                }
                boolean ok = true;
                List libraries = target.getAdditionalLibraries();
                if (libraries.isEmpty()) {
                    ok = false;
                } else {
                    for (OptionalLibrary optionalLibrary : libraries) {
                        if (jarPaths.contains(FileUtil.toCanonicalPath((String)optionalLibrary.getJar().getAbsolutePath()))) continue;
                        ok = false;
                    }
                }
                if (!ok) continue;
                resultTarget = target;
            }
            if (resultTarget != null) {
                return new AndroidPlatform(sdkData, resultTarget);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidPlatform platform = (AndroidPlatform)o;
        if (!this.mySdkData.equals(platform.mySdkData)) {
            return false;
        }
        return this.myTarget.equals(platform.myTarget);
    }

    public int hashCode() {
        int result2 = this.mySdkData.hashCode();
        result2 = 31 * result2 + this.myTarget.hashCode();
        return result2;
    }

    public boolean needToAddAnnotationsJarToClasspath() {
        return AndroidSdks.getInstance().needsAnnotationsJarInClasspath(this.myTarget);
    }

    public int getApiLevel() {
        return this.myTarget.getVersion().getApiLevel();
    }

    @NotNull
    public AndroidVersion getApiVersion() {
        AndroidVersion androidVersion = this.myTarget.getVersion();
        if (androidVersion == null) {
            AndroidPlatform.$$$reportNull$$$0(8);
        }
        return androidVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/sdk/AndroidPlatform";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/sdk/AndroidPlatform";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

