/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleResourceManagers {
    private final Module myModule;
    private FrameworkResourceManager myPublicFrameworkResourceManager;
    private FrameworkResourceManager myFullFrameworkResourceManager;
    private LocalResourceManager myLocalResourceManager;

    @NotNull
    public static ModuleResourceManagers getInstance(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            ModuleResourceManagers.$$$reportNull$$$0(0);
        }
        ModuleResourceManagers moduleResourceManagers = (ModuleResourceManagers)facet2.getModule().getService(ModuleResourceManagers.class);
        if (moduleResourceManagers == null) {
            ModuleResourceManagers.$$$reportNull$$$0(1);
        }
        return moduleResourceManagers;
    }

    private ModuleResourceManagers(final @NotNull Module module) {
        if (module == null) {
            ModuleResourceManagers.$$$reportNull$$$0(2);
        }
        this.myModule = module;
        MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private Sdk myPrevSdk = null;

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ModuleResourceManagers.this.myLocalResourceManager = null;
                Sdk newSdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (!(ModuleResourceManagers.this.myPublicFrameworkResourceManager == null && ModuleResourceManagers.this.myFullFrameworkResourceManager == null || Objects.equals(this.myPrevSdk, newSdk))) {
                    ModuleResourceManagers.this.myPublicFrameworkResourceManager = null;
                    ModuleResourceManagers.this.myFullFrameworkResourceManager = null;
                }
                this.myPrevSdk = newSdk;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/resourceManagers/ModuleResourceManagers$1", "rootsChanged"));
            }
        });
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage) {
        return this.getResourceManager(resourcePackage, null);
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage, @Nullable PsiElement contextElement) {
        if ("android".equals(resourcePackage)) {
            return this.getFrameworkResourceManager();
        }
        if (contextElement != null && AndroidSdks.getInstance().isInAndroidSdk(contextElement)) {
            return this.getFrameworkResourceManager();
        }
        return this.getLocalResourceManager();
    }

    @NotNull
    public LocalResourceManager getLocalResourceManager() {
        if (this.myLocalResourceManager == null || this.myLocalResourceManager.getFacet().isDisposed()) {
            this.myLocalResourceManager = new LocalResourceManager(this.getFacet());
        }
        LocalResourceManager localResourceManager = this.myLocalResourceManager;
        if (localResourceManager == null) {
            ModuleResourceManagers.$$$reportNull$$$0(3);
        }
        return localResourceManager;
    }

    @NotNull
    private AndroidFacet getFacet() {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)this.myModule);
        assert (facet2 != null);
        AndroidFacet androidFacet = facet2;
        if (androidFacet == null) {
            ModuleResourceManagers.$$$reportNull$$$0(4);
        }
        return androidFacet;
    }

    @Nullable
    public FrameworkResourceManager getFrameworkResourceManager() {
        return this.getFrameworkResourceManager(true);
    }

    @Nullable
    public FrameworkResourceManager getFrameworkResourceManager(boolean publicOnly) {
        if (publicOnly) {
            if (this.myPublicFrameworkResourceManager == null) {
                this.myPublicFrameworkResourceManager = new FrameworkResourceManager(this.myModule, true);
            }
            return this.myPublicFrameworkResourceManager;
        }
        if (this.myFullFrameworkResourceManager == null) {
            this.myFullFrameworkResourceManager = new FrameworkResourceManager(this.myModule, false);
        }
        return this.myFullFrameworkResourceManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ModuleResourceManagers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ModuleResourceManagers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalResourceManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

